/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: C_MOTIF_main.c
 *                    Author: Rick Avila & Morita
 *                      Date: 03/07/92
 *               Description: Motif Windowing Routines Of VolVis
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *       Theodossiou Andreas  03/93-05/93   cse528 project
 */



/******************************************************************/
/*                The standard C include files                    */
/******************************************************************/

#include <stdio.h>
#include <string.h>


/******************************************************************/
/*               The MOTIF include files                          */
/******************************************************************/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>


/******************************************************************/
/*                  VolVis include files                          */
/******************************************************************/
#include "C_ide.h"
#include "C_ide_new.h"
#include "C_mouse.h"
#include <gl/C_spaceball.h>
#include "C_dataglove.h"
#include "MOTIF_windefs.h"

/* Global Variables for program "accounting" */
C_IDE_simulation_method C_ide_simulation_method; /* Holds the device specific variables */
Open_Selection_Maps selection_maps;              /* Selection Map Widgets and their Text Widgets */
int Number_Of_Open_Selection_Maps;               /* Counter for the total number of open Selection Maps */
int Number_Of_Open_Modifiable_Selection_Maps;    /* Counter for Selection Maps opened from a Virtual device*/

/*
 *        Procedure Name:  incr_selection_maps
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *      Global Variables:  Number_Of_Open_Selection_Maps
 *           Description:  Increments the Number_Of_Open_Selection_Maps. If the
number exceeds a
 *                         certain limit the program exits.
 */
void incr_selection_maps() {
   if (Number_Of_Open_Selection_Maps > C_MAX_SELECTION_WIDGETS) {
       printf("Out of memory\n");
       exit(1);
   }
   Number_Of_Open_Selection_Maps++;
   printf("Number of open Selection Map Windows is : %d\n",
           Number_Of_Open_Selection_Maps+1);
}


/*
 *        Procedure Name:  decr_selection_maps
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *      Global Variables:  Number_Of_Open_Selection_Maps
 *           Description:  Decrements the Number_Of_Open_Selection_Maps. If the
number
 *                         becomes less than 0 then a logic error exists and the program exits.
 */
void decr_selection_maps() {
   if (Number_Of_Open_Selection_Maps == -1) {
       printf("Trying to close a non-existent widget\n");
       exit(1);
   }
   Number_Of_Open_Selection_Maps--;
   printf("Number of open Selection Map Windows is : %d\n",
           Number_Of_Open_Selection_Maps+1);
}

/*
 *        Procedure Name:  incr_modifiable_selection_maps
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *      Global Variables:  Number_Of_Open_Modifiable_Selection_Maps
 *           Description:  Increments the Number_Of_Open_Modifiable_Selection_Maps.
 *                         No check is needed. This cannot exceed the Number_Of_Open_Selection_Maps.
 */
void incr_modifiable_selection_maps() {
   Number_Of_Open_Modifiable_Selection_Maps++;
   printf("Number of open modifiable Selection Map Windows is : %d\n",
           Number_Of_Open_Modifiable_Selection_Maps);
}



/*
 *        Procedure Name:  incr_modifiable_selection_maps
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *      Global Variables:  Number_Of_Open_Modifiable_Selection_Maps
 *           Description:  Decrements the Number_Of_Open_Modifiable_Selection_Maps.
 *                         No check is needed. This cannot be less than the Number_Of_Open_Selection_Maps.
 */
void decr_modifiable_selection_maps() {
   Number_Of_Open_Modifiable_Selection_Maps--;
}


/*
 *        Procedure Name:  update_selection_maps
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *      Global Variables:  Number_Of_Open_Modifiable_Selection_Maps,
 *                         Number_Of_Open_Selection_Maps
 *           Description:  If a Virtual Device panel is closed then the
 *                         Number_Of_Open_Modifiable_Selection_Maps is subtracted from the
 *                         Number_Of_Open_Selection_Maps and then it is set to 0.
 */
void update_selection_maps() {
   Number_Of_Open_Selection_Maps -= Number_Of_Open_Modifiable_Selection_Maps;
   printf("Number of open Selection Map Windows is : %d\n",
           Number_Of_Open_Selection_Maps+1);
   Number_Of_Open_Modifiable_Selection_Maps = 0;
   printf("Number of open modifiable Selection Map Windows is : %d\n",
           Number_Of_Open_Modifiable_Selection_Maps);
}


/*
 *        Procedure Name:  init
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *      Global Variables:  Number_Of_Open_Modifiable_Selection_Maps,
 *                         Number_Of_Open_Selection_Maps, C_ide_simulation_method
 *           Description:  Initialization of the three above variables
 */
C_ide_init()
{
  int i;

  Number_Of_Open_Selection_Maps = -1;
  Number_Of_Open_Modifiable_Selection_Maps = 0;

  /* Mouse default settings */

  C_ide_simulation_method.mouse.trans_simu = C_Traid_Mouse;
  C_ide_simulation_method.mouse.rot_simu = C_Trackball;
  C_ide_simulation_method.mouse.trans_rot_simu = C_Manual;
  C_ide_simulation_method.mouse.simulate_switch_simu = 1;
  C_ide_simulation_method.mouse.mode_simu = C_WINDOW;
  C_ide_simulation_method.mouse.unit_simu = C_NORMALIZED;


  /* Spaceball default settings */

  C_ide_simulation_method.spaceball.view_simu = C_Object;
  C_ide_simulation_method.spaceball.trans_simu = C_Trans_Off;
  C_ide_simulation_method.spaceball.rot_simu = C_Rot_Off;
  C_ide_simulation_method.spaceball.vcr_simu = C_Recording;
  C_ide_simulation_method.spaceball.vcr_loop_simu = C_One_Play;

  /* Dataglove default settings */

  C_ide_simulation_method.dataglove.Repeat60.Flex = NOT_SET;
  C_ide_simulation_method.dataglove.Repeat60.Polhemus = NOT_SET;
  C_ide_simulation_method.dataglove.Repeat60.Gesture = NOT_SET;;
  C_ide_simulation_method.dataglove.Repeat30.Flex = NOT_SET;
  C_ide_simulation_method.dataglove.Repeat30.Polhemus = NOT_SET;
  C_ide_simulation_method.dataglove.Repeat30.Gesture = NOT_SET;
  C_ide_simulation_method.dataglove.OneShot.Flex = NOT_SET;
  C_ide_simulation_method.dataglove.OneShot.Polhemus = NOT_SET;
  C_ide_simulation_method.dataglove.OneShot.Gesture = NOT_SET;
  C_ide_simulation_method.dataglove.SetAngleOutput = SET;
  C_ide_simulation_method.dataglove.SetFlexOutput = SET;
  C_ide_simulation_method.dataglove.WritetoUserPort = 0;
  C_ide_simulation_method.dataglove.LoadTable.joint = 1;
  for (i=0; i<256; i++)
    C_ide_simulation_method.dataglove.LoadTable.translation[i] = 0;

  C_ide_simulation_method.dataglove.SetLEDLevel = 0;
  C_ide_simulation_method.dataglove.UserIRQ = NOT_SET;
  C_ide_simulation_method.dataglove.SetPolhemusUnits = Inches;
  C_ide_simulation_method.dataglove.NumberofSensors = 1;
  C_ide_simulation_method.dataglove.BaudRates = 19200;
}

