/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_ani_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 
 *		 Description: Animation Windowing Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <string.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <math.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_navigator.h"
#include "C_help.h"
#include "C_animate.h"


/* Global Variables For Motif Windowing */
extern Widget		vv_toplevel;	/* VolVis toplevel Shell Widget */
extern Widget		ani_bbdialog;	/* File I/O Bulletin Board Dialog */
extern C_WindowDefs	window_defs;

extern C_World	world;

C_AniInfo		*ani_info = NULL;


void create_ani_window()
{
	extern void 		close_callback();
	extern void 		help_callback();
	void			ani_flight_callback();
	void			ani_view_callback();
	void			ani_manual_callback();



	Arg			args[15];	/* Argument List */
	int			n;		/* Argument Count */
	XmString		label_string;
	Widget			label;
	Widget			button;
	Widget			frame;
	Widget			bboard;
	Widget			rowcolumn;
	
	int			loop;

	ani_info = C_New( C_AniInfo );
	ani_info->ani_flight_bbdialog = NULL;
	ani_info->ani_manual_bbdialog = NULL;
	ani_info->ani_view_bbdialog = NULL;
	ani_info->flight_file_text = NULL;
	ani_info->flight_base_text = NULL;
	ani_info->flight_start_text = NULL;
	ani_info->flight_end_text = NULL;
	ani_info->flight_frames_text = NULL;
	ani_info->manual_base_text = NULL;
	ani_info->manual_frames_text = NULL;
	ani_info->ani_cw_info = NULL;

	/* Create The File I/O Bulletin Board */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	label_string = XmStringCreate( "Animator", XmSTRING_DEFAULT_CHARSET);
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	ani_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
		       "animator", args, n );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame(ani_bbdialog,
                        "frame", args, n );
        XtManageChild( frame );
 
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

	/* Rotation Animation Button */
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Manual Animation",
		xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback, 
			ani_manual_callback, ani_info );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Flight",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_flight_callback, ani_info );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "View Animation",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_view_callback, ani_info );


        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 80 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame(ani_bbdialog,
                        "frame", args, n );
        XtManageChild( frame );
 
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       close_callback, ani_bbdialog );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Help",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       help_callback, C_ANI_HELP );

	XtManageChild( ani_bbdialog );
}

void ani_flight_callback( w, ani_info, call_data )
Widget          w;
C_AniInfo       *ani_info;
XtPointer       call_data;
{
        void    create_flight_window();

        if( ani_info->ani_flight_bbdialog )
        {
                if( XtIsManaged(ani_info->ani_flight_bbdialog) )
                {
                        XtUnmanageChild( ani_info->ani_flight_bbdialog );
                }
                XtManageChild( ani_info->ani_flight_bbdialog );
        }
        else
        {
		create_flight_window( ani_info );
        }
}

void ani_view_callback( w, ani_info, call_data )
Widget          w;
C_AniInfo       *ani_info;
XtPointer       call_data;
{
        void    create_view_window();

        if( ani_info->ani_view_bbdialog )
        {
                if( XtIsManaged(ani_info->ani_view_bbdialog) )
                {
                        XtUnmanageChild( ani_info->ani_view_bbdialog );
                }
                XtManageChild( ani_info->ani_view_bbdialog );
        }
        else
        {
		create_view_window( ani_info );
        }
}


void create_flight_window( ani_info )
C_AniInfo       *ani_info;
{
	extern void 		close_callback();
	extern void 		help_callback();

	void			ani_animate_callback();
	void			ani_flight_preview_callback();
	void			ani_setup_callback();
	void			ani_process_info_callback();
	void			ani_view_flight_callback();
	void			ani_rotation_setup_callback();


	Arg			args[15];	/* Argument List */
	int			n;		/* Argument Count */
	XmString		label_string;
	Widget			label;
	Widget			button;
	Widget			frame;
	Widget			bboard;
	Widget			rowcolumn;
	char			string[256];
	
	int			loop;


	/* Create The File I/O Bulletin Board */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	label_string = XmStringCreate( "Animator", XmSTRING_DEFAULT_CHARSET);
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	ani_info->ani_flight_bbdialog = 
		XmCreateBulletinBoardDialog( vv_toplevel, "animator", args, n );

	n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame( ani_info->ani_flight_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bboard =
                XmCreateBulletinBoard(frame, "bboard", args, n);
        XtManageChild (bboard);

	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 15 ); n++;
	label = XmCreateLabelGadget( bboard, "Flight File:", args, n );
	XtManageChild( label );

	n=0;
	XtSetArg( args[n], XmNx, 100 ); n++;
	XtSetArg( args[n], XmNy, 10 ); n++;
	XtSetArg( args[n], XmNcolumns, 40 ); n++;
	sprintf(string, "%s/data/FLT/flight", getenv("VOLVIS_HOME") );
	XtSetArg( args[n], XmNvalue, string ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->flight_file_text = 
		XmCreateTextField( bboard, "file_text", args, n );
	XtManageChild( ani_info->flight_file_text );

	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 55 ); n++;
	label = XmCreateLabelGadget( bboard, "Base Name:", args, n );
	XtManageChild( label );

	n=0;
	XtSetArg( args[n], XmNx, 100 ); n++;
	XtSetArg( args[n], XmNy, 50 ); n++;
	XtSetArg( args[n], XmNcolumns, 40 ); n++;
	sprintf(string, "%s/data/ANI/animation", getenv("VOLVIS_HOME") );
	XtSetArg( args[n], XmNvalue, string ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->flight_base_text = 
		XmCreateTextField( bboard, "base_text", args, n );
	XtManageChild( ani_info->flight_base_text );

	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 95 ); n++;
	label = XmCreateLabelGadget( bboard, "Start:", args, n );
	XtManageChild( label );
	XmStringFree( label_string );

	n=0;
	XtSetArg( args[n], XmNx, 80 ); n++;
	XtSetArg( args[n], XmNy, 90 ); n++;
	XtSetArg( args[n], XmNcolumns, 5 ); n++;
	XtSetArg( args[n], XmNvalue, "0" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->flight_start_text = 
			XmCreateTextField( bboard, "start_text", args, n );
	XtManageChild( ani_info->flight_start_text );

	n=0;
	XtSetArg( args[n], XmNx, 150 ); n++;
	XtSetArg( args[n], XmNy, 95 ); n++;
	label = XmCreateLabelGadget( bboard, "End:", args, n );
	XtManageChild( label );
	XmStringFree( label_string );

	n=0;
	XtSetArg( args[n], XmNx, 200 ); n++;
	XtSetArg( args[n], XmNy, 90 ); n++;
	XtSetArg( args[n], XmNcolumns, 5 ); n++;
	XtSetArg( args[n], XmNvalue, "99999" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->flight_end_text = 
		XmCreateTextField( bboard, "end_text", args, n );
	XtManageChild( ani_info->flight_end_text );

	n=0;
	XtSetArg( args[n], XmNx, 280 ); n++;
	XtSetArg( args[n], XmNy, 95 ); n++;
	label = XmCreateLabelGadget( bboard, "Frames:", args, n );
	XtManageChild( label );
	XmStringFree( label_string );

	n=0;
	XtSetArg( args[n], XmNx, 350 ); n++;
	XtSetArg( args[n], XmNy, 90 ); n++;
	XtSetArg( args[n], XmNcolumns, 5 ); n++;
	XtSetArg( args[n], XmNvalue, "0" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->flight_frames_text = 
		XmCreateTextField( bboard, "frames_text", args, n );
	XtManageChild( ani_info->flight_frames_text );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 170 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame(ani_info->ani_flight_bbdialog,
                        "frame", args, n );
        XtManageChild( frame );
 
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Preview",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_flight_preview_callback, FALSE );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Animate",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_flight_preview_callback, TRUE );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "View",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_view_flight_callback, 1 );

/***
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "View 2x",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_view_flight_callback, 2 );
***/

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 240 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame(ani_info->ani_flight_bbdialog,
                        "frame", args, n );
        XtManageChild( frame );
 
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       close_callback, ani_info->ani_flight_bbdialog );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Help",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       help_callback, C_ANI_FLIGHT_HELP );


	XtManageChild( ani_info->ani_flight_bbdialog );
}

void create_view_window( ani_info )
C_AniInfo       *ani_info;
{
	extern void 		close_callback();
	extern void 		help_callback();

	void			ani_flight_preview_callback();
	void			ani_view_anim_callback();


	Arg			args[15];	/* Argument List */
	int			n;		/* Argument Count */
	XmString		label_string;
	Widget			label;
	Widget			button;
	Widget			frame;
	Widget			bboard;
	Widget			rowcolumn;
	char			string[256];
	
	int			loop;


	/* Create The File I/O Bulletin Board */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	label_string = XmStringCreate( "View Animation", 
					XmSTRING_DEFAULT_CHARSET);
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	ani_info->ani_view_bbdialog = 
		XmCreateBulletinBoardDialog( vv_toplevel, "animator", args, n );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame =
            XmCreateFrame( ani_info->ani_view_bbdialog, "frame", args, n );
        XtManageChild( frame );
 
        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bboard =
                XmCreateBulletinBoard(frame, "bboard", args, n);
        XtManageChild (bboard);

	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 55 ); n++;
	label = XmCreateLabelGadget( bboard, "Base Name:", args, n );
	XtManageChild( label );

	n=0;
	XtSetArg( args[n], XmNx, 100 ); n++;
	XtSetArg( args[n], XmNy, 50 ); n++;
	XtSetArg( args[n], XmNcolumns, 40 ); n++;
	sprintf(string, "%s/data/ANI/animation", getenv("VOLVIS_HOME") );
	XtSetArg( args[n], XmNvalue, string ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->view_base_text = 
		XmCreateTextField( bboard, "base_text", args, n );
	XtManageChild( ani_info->view_base_text );

	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 95 ); n++;
	label = XmCreateLabelGadget( bboard, "Start:", args, n );
	XtManageChild( label );
	XmStringFree( label_string );

	n=0;
	XtSetArg( args[n], XmNx, 80 ); n++;
	XtSetArg( args[n], XmNy, 90 ); n++;
	XtSetArg( args[n], XmNcolumns, 5 ); n++;
	XtSetArg( args[n], XmNvalue, "0" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->view_start_text = 
			XmCreateTextField( bboard, "start_text", args, n );
	XtManageChild( ani_info->view_start_text );

	n=0;
	XtSetArg( args[n], XmNx, 150 ); n++;
	XtSetArg( args[n], XmNy, 95 ); n++;
	label = XmCreateLabelGadget( bboard, "End:", args, n );
	XtManageChild( label );
	XmStringFree( label_string );

	n=0;
	XtSetArg( args[n], XmNx, 200 ); n++;
	XtSetArg( args[n], XmNy, 90 ); n++;
	XtSetArg( args[n], XmNcolumns, 5 ); n++;
	XtSetArg( args[n], XmNvalue, "99999" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->view_end_text = 
		XmCreateTextField( bboard, "end_text", args, n );
	XtManageChild( ani_info->view_end_text );


        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 240 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame(ani_info->ani_view_bbdialog,
                        "frame", args, n );
        XtManageChild( frame );
 
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "View",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_view_anim_callback, 1 );

/****
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "View 2x",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       ani_view_anim_callback, 2 );
***/

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       close_callback, ani_info->ani_view_bbdialog );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Help",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       help_callback, C_ANI_VIEW_HELP );


	XtManageChild( ani_info->ani_view_bbdialog );
}

void ani_flight_preview_callback( w, generate_animation, call_data )
Widget			*w;
int			generate_animation;
XtPointer		call_data;
{
	extern void	C_setup_animation();
	char		*filename;
	char		*basename;
	char		*tmp_string;
	int		start, end;
	int		fd;
	int		start_num;

	int		wloop;
	int		some_workstation = FALSE;
	void		C_setup_stop_button();
	void		C_remove_stop_button();


	if( generate_animation )
		C_setup_stop_button( "Press Here To Abort Animation" );

	filename = (char *)XmTextGetString( ani_info->flight_file_text );
	basename = (char *)XmTextGetString( ani_info->flight_base_text );

	tmp_string = (char *)XmTextGetString( ani_info->flight_start_text );
	start = atoi( tmp_string );

	tmp_string = (char *)XmTextGetString( ani_info->flight_end_text );
	end = atoi( tmp_string );

	C_setup_animation( filename, basename, start, &fd, &start_num );
	C_view_animation( start, end, fd, filename, basename, start_num, 
			  generate_animation );

	if( generate_animation )
		C_remove_stop_button();
}

void ani_view_anim_callback( w, scale_factor, call_data )
Widget          w;
int	        scale_factor;
XtPointer       call_data;
{
	char		*basename;
	char		*tmp_string;
	int		start, end;
	char		command[200];

	basename = (char *)XmTextGetString( ani_info->view_base_text );

	tmp_string = (char *)XmTextGetString( ani_info->view_start_text );
	start = atoi( tmp_string );
	XtFree( tmp_string );

	tmp_string = (char *)XmTextGetString( ani_info->view_end_text );
	end = atoi( tmp_string );
	XtFree( tmp_string );

	sprintf(command, "%s/Utilities/animate/bin/animate %s %d %d %d", 
		getenv("VOLVIS_HOME"), basename, scale_factor, 
		start, end-start );
#ifdef C_SGI
	system(command);
#endif
	XtFree( basename );
}

void ani_view_flight_callback( w, scale_factor, call_data )
Widget          w;
int       	scale_factor;
XtPointer       call_data;
{
	char		*basename;
	char		*tmp_string;
	int		start, end;
	char		command[200];

	basename = (char *)XmTextGetString( ani_info->flight_base_text );

	tmp_string = (char *)XmTextGetString( ani_info->flight_start_text );
	start = atoi( tmp_string );
	XtFree( tmp_string );

	tmp_string = (char *)XmTextGetString( ani_info->flight_end_text );
	end = atoi( tmp_string );
	XtFree( tmp_string );

	sprintf(command, "%s/Utilities/animate/bin/animate %s %d %d %d", 
		getenv("VOLVIS_HOME"), basename, scale_factor, 
		start, end-start );
#ifdef C_SGI
	system(command);
#endif
	XtFree( basename );
}


void ani_manual_callback( w, ani_info, call_data )
Widget          w;
C_AniInfo       *ani_info;
XtPointer       call_data;
{
        void    create_manual_window();

        if( ani_info->ani_manual_bbdialog )
        {
                if( XtIsManaged(ani_info->ani_manual_bbdialog) )
                {
                        XtUnmanageChild( ani_info->ani_manual_bbdialog );
                }
                XtManageChild( ani_info->ani_manual_bbdialog );
        }
        else
        {
		create_manual_window( ani_info );
        }
}

void create_manual_window( ani_info )
C_AniInfo		*ani_info;
{
	extern void	close_callback();
	extern void     help_callback();

	void		ani_set_transform();
	void		ani_set_coord();
	void		ani_set_ref();
	void		ani_global_option();
	void		ani_manual_preview_callback();

	Arg             args[20];
        int             n;

        Widget          label;
        Widget          toggle;
	Widget		frame;
	Widget		button;
	Widget		rowcolumn;
        Widget 		radiobox;
	Widget		other_label[3];
	Widget		bb;

	char		string[C_MAX_STRING];

	int		i;

        static char *coord_toggle_name[2] = {"Local", "Global-"};
        static char *transform_toggle_name[3] = 
				{"Translate", "Rotate", "Scale"};
        static char *reference_toggle_name[3] = 
				{"Origin", "Center", "Other->"};
	static char *other_name[3] = {"X:", "Y:", "Z:"};




	C_NavCWInfo	*ani_cw_info;

        XmString        label_string;

	void		ani_rotate_callback();
        extern void     close_callback();

	ani_cw_info = C_New( C_NavCWInfo );
	ani_info->ani_cw_info = ani_cw_info;

        /***    initialize selections     ***/
        ani_cw_info->nav_global.nav_mode = C_ROTATE;
        ani_cw_info->nav_global.nav_coord = C_LOCAL_COORD;
        ani_cw_info->nav_global.nav_ref = C_CENTER_REF;
        ani_cw_info->nav_global.nav_option = 0;

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        label_string = XmStringCreate( "Manual Animation",
                                        XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
        ani_info->ani_manual_bbdialog = 
		XmCreateBulletinBoardDialog( vv_toplevel,
                       "ani_manual_bbdialog", args, n );


        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 10 ); n++;
        label = XmCreateLabelGadget(ani_info->ani_manual_bbdialog,
                                "Transformation:", args, n);
        XtManageChild(label);


        /***** the frame *****/
        n = 0;
        XtSetArg (args[n], XmNx, 140);  n++;
        XtSetArg (args[n], XmNy, 10);  n++;
        XtSetArg( args[n], XmNheight, 40 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame( ani_info->ani_manual_bbdialog, "frame", args, n);
        XtManageChild (frame);
 
        /***** the frame encloses a RadioBox *****/
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RadioBox( args, n, window_defs );
        radiobox = XmCreateRadioBox (frame, "radiobox", args, n);
        XtManageChild (radiobox);
 
        /*****  Create Children  ********************************************/
        n = 0;
        label_string = 
		XmStringCreate (transform_toggle_name[0], 
			        XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	XtSetArg (args[n], XmNset, False ); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget (transform_toggle_name[0], 
				xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (label_string);
        XtManageChild(toggle);
        XtAddCallback (toggle, XmNvalueChangedCallback, ani_set_transform,
                       C_TRANSLATE);
 
        n = 0;
        label_string = 
		XmStringCreate(transform_toggle_name[1], 
			       XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	XtSetArg (args[n], XmNset, True ); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget(transform_toggle_name[1], 
				xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (label_string);
        XtManageChild(toggle);
        XtAddCallback (toggle, XmNvalueChangedCallback, ani_set_transform,
                       C_ROTATE);
  
        n = 0;
        label_string = XmStringCreate(transform_toggle_name[2], 	
				      XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	XtSetArg (args[n], XmNset, False ); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget (transform_toggle_name[2], 
				 xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (label_string);
        XtManageChild(toggle);
        XtAddCallback (toggle, XmNvalueChangedCallback, ani_set_transform,
                       C_SCALE);
 

        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 60 ); n++;
        label = XmCreateLabelGadget(ani_info->ani_manual_bbdialog,
                                "Coordinate sys:", args, n);
        XtManageChild(label);

        /***** the frame *****/
        n = 0;
        XtSetArg (args[n], XmNx, 140);  n++;
        XtSetArg (args[n], XmNy, 60);  n++;
        XtSetArg( args[n], XmNheight, 40 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame(ani_info->ani_manual_bbdialog, "frame", args, n);
        XtManageChild (frame);
 
        /***** the frame encloses a RadioBox *****/
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RadioBox( args, n, window_defs );
        radiobox = XmCreateRadioBox (frame, "radiobox", args, n);
        XtManageChild (radiobox);
 
        /*****  Create Children  *****/
        n = 0;
        label_string = 
		XmStringCreate (coord_toggle_name[0], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg( args[n], XmNset, True ); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        ani_cw_info->nav_local_toggle = XtCreateWidget (coord_toggle_name[0],
                                xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (label_string);
        XtManageChild (ani_cw_info->nav_local_toggle);
        XtAddCallback (ani_cw_info->nav_local_toggle, XmNvalueChangedCallback,
                        ani_set_coord, C_LOCAL_COORD);

        n = 0;
        label_string = 
		XmStringCreate (coord_toggle_name[1], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg( args[n], XmNset, False ); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        ani_cw_info->nav_global_toggle = XtCreateWidget (coord_toggle_name[1],
                                xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (label_string);
        XtManageChild (ani_cw_info->nav_global_toggle);
        XtAddCallback (ani_cw_info->nav_global_toggle, XmNvalueChangedCallback,
                        ani_set_coord, C_GLOBAL_COORD);
 
	/***** Create a Row Column in bboard for global selection ********/
        n = 0;
        XtSetArg (args[n], XmNx, 315);  n++;
        XtSetArg (args[n], XmNy, 58);  n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        ani_cw_info->nav_global_rc = 
		XmCreateRowColumn(ani_info->ani_manual_bbdialog, "rc", args, n);
        XtManageChild (ani_cw_info->nav_global_rc);
 
        /***** Create a pulldown menu for global selection *************/
        n = 0;
        C_Set_Color_PullDown( args, n, window_defs );
        ani_cw_info->nav_pulldown = XmCreatePulldownMenu(
                        ani_cw_info->nav_global_rc, "pulldown", args, n);
 
        n = 0;
        label_string = XmStringCreate ("World", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        ani_cw_info->nav_options[0] = XmCreatePushButtonGadget(
                                ani_cw_info->nav_pulldown, "World", args, n);
        XmStringFree (label_string);
        XtAddCallback (ani_cw_info->nav_options[0], XmNactivateCallback,
                       ani_global_option, 0);
 
        n = 0;
        label_string = XmStringCreate ("View", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        ani_cw_info->nav_options[1] = XmCreatePushButtonGadget(
                                ani_cw_info->nav_pulldown, "View", args, n);
        XmStringFree (label_string);
        XtAddCallback (ani_cw_info->nav_options[1], XmNactivateCallback,
                       ani_global_option, 1);
 
        for (i=2; i<world.num_volumes+2; i++)
        {
            n = 0;
            label_string = XmStringCreate (world.volume[i-2]->volume_name,
                                        XmSTRING_DEFAULT_CHARSET);
            XtSetArg (args[n], XmNlabelString, label_string); n++;
            ani_cw_info->nav_options[i] = XmCreatePushButtonGadget(
                                        ani_cw_info->nav_pulldown,
                                   world.volume[i-2]->volume_name, args, n);
            XmStringFree (label_string);
            XtAddCallback (ani_cw_info->nav_options[i], XmNactivateCallback,
                           ani_global_option, i);
        }
 
        XtManageChildren (ani_cw_info->nav_options, world.num_volumes+2);
 
        /***** Create a option menu and attach the pulldown menu ********/
 
        n = 0;
        label_string = XmStringCreate (">", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg (args[n], XmNsubMenuId, ani_cw_info->nav_pulldown); n++;
        XtSetArg (args[n], XmNmenuHistory,
            ani_cw_info->nav_options[ani_cw_info->nav_global.nav_option]); n++;
        C_Set_Color_OptionMenu( args, n, window_defs );
        ani_cw_info->nav_option_menu = XmCreateOptionMenu(
                        ani_cw_info->nav_global_rc, "option_menu", args, n);
 
        XtManageChild(ani_cw_info->nav_option_menu);
        XmStringFree (label_string);
 

        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 110 ); n++;
        label = XmCreateLabelGadget(ani_info->ani_manual_bbdialog,
                                "Reference point:", args, n);
        XtManageChild(label);


        /***** the frame *****/
        n = 0;
        XtSetArg (args[n], XmNx, 140);  n++;
        XtSetArg (args[n], XmNy, 110);  n++;
        XtSetArg( args[n], XmNheight, 40 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame(ani_info->ani_manual_bbdialog, "frame", args, n);
        XtManageChild (frame);
 
        /***** the frame encloses a RadioBox *****/
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNsensitive, True ); n++;
        C_Set_Color_RadioBox( args, n, window_defs );
        ani_cw_info->nav_ref_radiobox =
                XmCreateRadioBox (frame, "radiobox", args, n);
        XtManageChild (ani_cw_info->nav_ref_radiobox);
 
        /*****  Create Children  *******************************************/
        n = 0;
        label_string = XmStringCreate (reference_toggle_name[0], 
				 XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget (reference_toggle_name[0], 
				 xmToggleButtonWidgetClass,
                                 ani_cw_info->nav_ref_radiobox, args, n);
	XtManageChild(toggle);
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, ani_set_ref,
                       C_ORIGIN_REF);
 
        n = 0;
        label_string = XmStringCreate (reference_toggle_name[1], 
				       XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg (args[n], XmNset, True); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget(reference_toggle_name[1], 
			        xmToggleButtonWidgetClass,
                                ani_cw_info->nav_ref_radiobox, args, n);
	XtManageChild(toggle);
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, ani_set_ref,
                       C_CENTER_REF);
 
        n = 0;
        label_string = XmStringCreate(reference_toggle_name[2], 
				      XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg (args[n], XmNset, False); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget(reference_toggle_name[2], 
				    xmToggleButtonWidgetClass,
                                    ani_cw_info->nav_ref_radiobox, args, n);
	XtManageChild(toggle);
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, ani_set_ref,
                       C_OTHER_REF);
 
        /***** the frame *****/
        n = 0;
        XtSetArg (args[n], XmNx, 425);  n++;
        XtSetArg (args[n], XmNy, 110);  n++;
        XtSetArg( args[n], XmNheight, 120 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame(ani_info->ani_manual_bbdialog, "frame", args, n);
        XtManageChild (frame);
 
        /***** the frame encloses a bulletin board *****/
        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        ani_cw_info->nav_bb = XmCreateBulletinBoard (frame, "bb", args, n);
        XtManageChild (ani_cw_info->nav_bb);
 
 
        /*****  Create Children  *******/
 
        n = 0;
        XtSetArg (args[n], XmNx, 5);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        label_string = 
	    XmStringCreate ("World Position", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        label = XmCreateLabel (ani_cw_info->nav_bb, "World Position", args, n);
        XmStringFree (label_string);
 
        XtManageChild (label);
 
 
        n = 0;
        XtSetArg (args[n], XmNx, 5);  n++;
        XtSetArg (args[n], XmNy, 45);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        label_string = XmStringCreate (other_name[0], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        other_label[0] = XmCreateLabel( ani_cw_info->nav_bb,
                                        other_name[0], args, n);
        XmStringFree (label_string);
 
        n  = 0;
        XtSetArg (args[n], XmNx, 30);  n++;
        XtSetArg (args[n], XmNy, 45);  n++;
        XtSetArg( args[n], XmNwidth, 100 ); n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        ani_cw_info->nav_other_text[0] =
                XmCreateText (ani_cw_info->nav_bb, "x", args, n);
 
 
        n = 0;
        XtSetArg (args[n], XmNx, 5);  n++;
        XtSetArg (args[n], XmNy, 80);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        label_string = XmStringCreate (other_name[1], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        other_label[1] = XmCreateLabel( ani_cw_info->nav_bb,
                                        other_name[1], args, n);
        XmStringFree (label_string);
 
        n = 0;
        XtSetArg (args[n], XmNx, 30);  n++;
        XtSetArg (args[n], XmNy, 80);  n++;
        XtSetArg( args[n], XmNwidth, 100 ); n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        ani_cw_info->nav_other_text[1] =
                XmCreateText( ani_cw_info->nav_bb, "y", args, n);
 
        n = 0;
        XtSetArg (args[n], XmNx, 5);  n++;
        XtSetArg (args[n], XmNy, 115);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        label_string = XmStringCreate (other_name[2], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        other_label[2] =
                XmCreateLabel (ani_cw_info->nav_bb, other_name[2], args, n);
        XmStringFree (label_string);
  
        n = 0;
        XtSetArg (args[n], XmNx, 30);  n++;
        XtSetArg (args[n], XmNy, 115);  n++;
        XtSetArg( args[n], XmNwidth, 100 ); n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        ani_cw_info->nav_other_text[2] =
                XmCreateText (ani_cw_info->nav_bb, "z", args, n);
 
        XtManageChildren (other_label, 3);
        XtManageChildren (ani_cw_info->nav_other_text, 3);



        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 165 ); n++;
        label = XmCreateLabelGadget(ani_info->ani_manual_bbdialog,
                                "Transform amount:", args, n);
        XtManageChild(label);

        /***** the frame *****/
 
        n = 0;
        XtSetArg (args[n], XmNshadowType, XmSHADOW_ETCHED_IN);  n++;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 190);  n++;
        XtSetArg( args[n], XmNheight, 135 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame (ani_info->ani_manual_bbdialog, "frame", args, n);
        XtManageChild (frame);
 
        /***** the frame encloses a bulletin board *****/
 
        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bb = XmCreateBulletinBoard (frame, "bb", args, n);
        XtManageChild (bb);
 
 
        /*****  Create Children  *****/
        ani_cw_info->nav_label_name[0] = "X angle:";
        ani_cw_info->nav_label_name[1] = "Y angle:";
        ani_cw_info->nav_label_name[2] = "Z angle:";
 
        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        label_string = XmStringCreate(ani_cw_info->nav_label_name[0],
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        ani_cw_info->nav_label[0] = XmCreateLabel(bb,
                                ani_cw_info->nav_label_name[0], args, n);
        XmStringFree (label_string);
 
        n  = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        ani_cw_info->nav_text[0] = XmCreateText (bb, "x", args, n);
 
        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 50);  n++;
        label_string = XmStringCreate(ani_cw_info->nav_label_name[1],
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        ani_cw_info->nav_label[1] = XmCreateLabel(bb,
                                ani_cw_info->nav_label_name[1], args, n);
        XmStringFree (label_string);
 
        n = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 50);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        ani_cw_info->nav_text[1] = XmCreateText (bb, "y", args, n);
 
        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 90);  n++;
        label_string = XmStringCreate(ani_cw_info->nav_label_name[2],
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        C_Set_Color_Label( args, n, window_defs );
        ani_cw_info->nav_label[2] = XmCreateLabel(bb,
                                ani_cw_info->nav_label_name[2], args, n);
        XmStringFree (label_string);
 
        n = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 90);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        ani_cw_info->nav_text[2] = XmCreateText (bb, "z", args, n);
 
        XtManageChildren (ani_cw_info->nav_label, 3);
        XtManageChildren (ani_cw_info->nav_text, 3);


	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 350 ); n++;
	label = XmCreateLabelGadget( ani_info->ani_manual_bbdialog, 
				     "Base Name:", args, n );
	XtManageChild( label );

	n=0;
	XtSetArg( args[n], XmNx, 100 ); n++;
	XtSetArg( args[n], XmNy, 350 ); n++;
	XtSetArg( args[n], XmNcolumns, 40 ); n++;
	sprintf(string, "%s/data/ANI/animation", getenv("VOLVIS_HOME") );
	XtSetArg( args[n], XmNvalue, string ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->manual_base_text = 
		XmCreateTextField( ani_info->ani_manual_bbdialog, 
				   "base_text", args, n );
	XtManageChild( ani_info->manual_base_text );

	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 390 ); n++;
	label = XmCreateLabelGadget( ani_info->ani_manual_bbdialog, 
				     "Frames:", args, n );
	XtManageChild( label );

	n=0;
	XtSetArg( args[n], XmNx, 100 ); n++;
	XtSetArg( args[n], XmNy, 390 ); n++;
	XtSetArg( args[n], XmNcolumns, 5 ); n++;
	XtSetArg( args[n], XmNvalue, "0" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	ani_info->manual_frames_text = 
		XmCreateTextField( ani_info->ani_manual_bbdialog, 
				   "frames_text", args, n );
	XtManageChild( ani_info->manual_frames_text );


	n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 440 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame( ani_info->ani_manual_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild(rowcolumn);

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Preview",
                xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback, 
		       ani_manual_preview_callback, FALSE );


        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Animate",
                xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback, 
		       ani_manual_preview_callback, TRUE );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "View",
                xmPushButtonWidgetClass, rowcolumn, args, n );


	/************************************/
	/* Create Close & Help Button Frame */
	/************************************/
	n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 490 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = 
	    XmCreateFrame( ani_info->ani_manual_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 50 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild(rowcolumn);

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       close_callback, ani_info->ani_manual_bbdialog );
        n = 0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget("Help",
                        xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       help_callback, C_ANI_MANUAL_HELP );

	XtManageChild( ani_info->ani_manual_bbdialog );
}

void ani_set_ref (w, ref_client, ref_data)
Widget                          w;
int                             ref_client;
XmToggleButtonCallbackStruct    *ref_data;
{
        if( ref_data->set == 0 )
                return;
 
        switch (ref_client)
        {
            case C_ORIGIN_REF :
                    ani_info->ani_cw_info->nav_global.nav_ref = C_ORIGIN_REF;
                    break;
            case C_CENTER_REF :
                    ani_info->ani_cw_info->nav_global.nav_ref = C_CENTER_REF;
                    break;
            case C_OTHER_REF :
                    ani_info->ani_cw_info->nav_global.nav_ref = C_OTHER_REF;
                    break;
        }
}
 

void ani_global_option( w, client_data, call_data )
Widget          w;
int             client_data;
XtPointer       call_data;
{
        ani_info->ani_cw_info->nav_global.nav_option = client_data;
}

void ani_set_coord(w, ref_client, ref_data)
Widget                          w;
int                             ref_client;
XmToggleButtonCallbackStruct    *ref_data;
{
	C_NavCWInfo		*ani_cw_info;

	ani_cw_info = ani_info->ani_cw_info;
 
        if( ref_data->set == 0 )
                return;
 
        switch (ref_client)
        {
            case C_LOCAL_COORD :
                        ani_cw_info->nav_global.nav_coord = C_LOCAL_COORD;
                        break;
            case C_GLOBAL_COORD :
                        ani_cw_info->nav_global.nav_coord = C_GLOBAL_COORD;
                        break;
        }
}

void ani_set_transform(w, mode_client, mode_data)
Widget                          w;
int                             mode_client;
XmToggleButtonCallbackStruct    *mode_data;
{
        Arg args[10];
        XmString string;
 
        int n;
	C_NavCWInfo		*ani_cw_info;
 
        if ( mode_data->set == 0 )
                return;

	ani_cw_info = ani_info->ani_cw_info;
 
        switch (mode_client)
        {
            case C_TRANSLATE :
                        ani_cw_info->nav_global.nav_mode = C_TRANSLATE;
                        ani_cw_info->nav_label_name[0] = "X unit:";
                        ani_cw_info->nav_label_name[1] = "Y unit:";
                        ani_cw_info->nav_label_name[2] = "Z unit:";
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[0],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[0], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[1],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[1], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[2],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[2], args, n);
                        XmStringFree (string);
 
                        XtSetSensitive(ani_cw_info->nav_global_toggle, True);
                        XtSetSensitive(ani_cw_info->nav_global_rc, True);
                        XtSetSensitive(ani_cw_info->nav_ref_radiobox, False);
                        XtSetSensitive(ani_cw_info->nav_bb, False);
 
                        break;
            case C_ROTATE :
                        ani_cw_info->nav_global.nav_mode = C_ROTATE;
                        ani_cw_info->nav_label_name[0] = "X angle:";
                        ani_cw_info->nav_label_name[1] = "Y angle:";
                        ani_cw_info->nav_label_name[2] = "Z angle:";
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[0],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[0], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[1],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[1], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[2],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[2], args, n);
                        XmStringFree (string);
 
                        XtSetSensitive(ani_cw_info->nav_global_toggle, True);
                        XtSetSensitive(ani_cw_info->nav_global_rc, True);
                        XtSetSensitive(ani_cw_info->nav_ref_radiobox, True);
                        XtSetSensitive(ani_cw_info->nav_bb, True);
                        break;
               case C_SCALE :
                        ani_cw_info->nav_global.nav_mode = C_SCALE;
                        ani_cw_info->nav_label_name[0] = "X factor:";
                        ani_cw_info->nav_label_name[1] = "Y factor:";
                        ani_cw_info->nav_label_name[2] = "Z factor:";
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[0],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[0], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[1],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[1], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        string = XmStringCreate (ani_cw_info->nav_label_name[2],
                                                 XmSTRING_DEFAULT_CHARSET);
                        XtSetArg (args[n], XmNlabelString, string); n++;
                        XtSetValues (ani_cw_info->nav_label[2], args, n);
                        XmStringFree (string);
 
                        n = 0;
                        XtSetArg( args[n], XmNset, False ); n++;
                        XtSetValues (ani_cw_info->nav_global_toggle, args, n);
 
                        n = 0;
                        XtSetArg( args[n], XmNset, TRUE ); n++;
                        XtSetValues (ani_cw_info->nav_local_toggle, args, n);
 
                        ani_cw_info->nav_global.nav_coord = C_LOCAL_COORD;
 
                        XtSetSensitive(ani_cw_info->nav_global_toggle, False);
                        XtSetSensitive(ani_cw_info->nav_global_rc, False);
                        XtSetSensitive(ani_cw_info->nav_ref_radiobox, True);
                        XtSetSensitive(ani_cw_info->nav_bb, True);
 
                        break;
        }
}

void ani_manual_preview_callback(  w, generate_animation, call_data )
Widget          w;
int       	generate_animation;
XtPointer	call_data;
{
        extern void     C_setup_stop_button();
        extern void     C_remove_stop_button();
	extern C_ReturnStatus	C_cast_rays();

	extern C_View		view;
	extern C_World		world;
	extern C_ImageTable	image_table;

	C_NavCWInfo		*ani_cw_info;
        C_NavCWParam    	ani_cw_param;
	char			*string;
	int			frames;
	int			loop;
        C_Byte          	*rptr, *gptr, *bptr;
        C_Image         	*image;
	char			*basename;
	int			iloop;
	char			image_name[C_MAX_STRING];
	char			image_file[C_MAX_STRING];
	C_ReturnStatus		status;
 


	ani_cw_info = ani_info->ani_cw_info;
 
	if ( generate_animation )
	{
            image = C_New( C_Image );
            C_create_image_from_view( image, &view );
 
            sprintf( image_name, "Anim_Image" );
            C_enter_image( &image_table, image, image_name, (char *)NULL );
 
            if (view.display_during_projection)
                create_ivi_display_window( image_table.num_images - 1);
 
	}

        ani_cw_param.global.nav_mode = ani_cw_info->nav_global.nav_mode;
        ani_cw_param.global.nav_coord = ani_cw_info->nav_global.nav_coord;
        ani_cw_param.global.nav_ref = ani_cw_info->nav_global.nav_ref;
        ani_cw_param.global.nav_option = ani_cw_info->nav_global.nav_option;

        string = (char *)XmTextGetString( ani_cw_info->nav_text[0] );
        sscanf( string, "%f", &ani_cw_param.trans_amt.x ); 
	XtFree( string );
        string = (char *)XmTextGetString( ani_cw_info->nav_text[1] );
        sscanf( string, "%f", &ani_cw_param.trans_amt.y ); 
	XtFree( string );
        string = (char *)XmTextGetString( ani_cw_info->nav_text[2] );
        sscanf( string, "%f", &ani_cw_param.trans_amt.z ); 
	XtFree( string );
 
        string = (char *)XmTextGetString( ani_cw_info->nav_other_text[0] );
        sscanf( string, "%f", &ani_cw_param.ref_point.x );
	XtFree( string );
        string = (char *)XmTextGetString( ani_cw_info->nav_other_text[1] );
        sscanf( string, "%f", &ani_cw_param.ref_point.y );
	XtFree( string );
        string = (char *)XmTextGetString( ani_cw_info->nav_other_text[2] );
        sscanf( string, "%f", &ani_cw_param.ref_point.z );
	XtFree( string );

	string = (char *)XmTextGetString( ani_info->manual_frames_text );
	sscanf( string, "%d", &frames );
	XtFree( string );

	basename = (char *)XmTextGetString( ani_info->manual_base_text );
	sscanf( string, "%d", &frames );

	if ( generate_animation )
		C_setup_stop_button( "Press Here To Abort Animation" );

	for ( loop = 0; loop < frames; loop++ )
	{
        	nav_transform(ani_cw_param);
		C_update_system( C_VOLUME_MODIFIED );

		if ( generate_animation )
		{
                      rptr = image->red;
                      gptr = image->green;
                      bptr = image->blue;
 
                      for(iloop=0; iloop < image->width*image->height; iloop++)
                      {
                          *(rptr++) = 0;
                          *(gptr++) = 0;
                          *(bptr++) = 0;
                      }
 
                      switch( view.projection_type )
                      {
                        case C_PARC:
                          status = C_cast_rays(&world, &view, image, TRUE );
                          break;
                        case C_RAY_TRACE:
                          status = C_cast_rays(&world, &view, image, FALSE );
                          break;
                      }

		      if ( status == C_ERROR_STATUS ||
			     status == C_CANCEL_STATUS )
		      {
				return;
		      }
 
                      sprintf( image_file, "%s.%d.img", basename, loop );
 
                      C_write_image_to_file( image, image_file);
 
		}
	}

	if ( generate_animation )
		C_remove_stop_button();
	
	XtFree( basename );
}

