/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: GL_nav_wireframe.c
 *		      Author: Rick Avila 
 *			Date: 08/15/92
 *		 Description: GL Drawing Routines For The Navigator 
 *			      Wireframe & Key Drawing Areas
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <X11/Xirisw/GlxMDraw.h>
#include <gl/gl.h>

#include "C_volvis.h"
#include "C_navigator.h"

/************************************************************************/
/*									*/
/*			Wireframe Creation Routines			*/
/*									*/
/************************************************************************/

Widget create_wf_drawing_area( parent )
Widget	parent;
{
	int			n;
	Arg			args[20];	/* Argument List */
	int			width;
	int			height;
	static GLXconfig 	glxConfig[] =
				{
					{ GLX_NORMAL, GLX_DOUBLE, TRUE },
					{ GLX_NORMAL, GLX_RGB, TRUE },
					{ GLX_NORMAL, GLX_ZSIZE, GLX_NOCONFIG },
					{ 0, 0, 0 }
				};
	extern C_View		view;
	extern C_NavInfo	nav_info;
	extern 			nav_wf_expose_CB();
	extern			nav_wf_resize_CB();

	/********************************************************/
	/*      Create a Drawing Area For Wireframe Projection  */
	/********************************************************/
	width 	= nav_info.wf_win_info.view.width_pixels;
	height	= nav_info.wf_win_info.view.height_pixels;

	n=0;
	XtSetArg( args[n], XmNx, 0 );
	XtSetArg( args[n], XmNy, 0 );
	XtSetArg( args[n], XmNwidth, width ); n++;
	XtSetArg( args[n], XmNheight, height ); n++;
	XtSetArg( args[n], GlxNglxConfig, glxConfig ); n++;
	nav_info.wf_win_info.drawing_area = 
		GlxCreateMDraw( parent, "nav_drawing_area", args, n );
	XtManageChild( nav_info.wf_win_info.drawing_area );

	XtAddCallback( nav_info.wf_win_info.drawing_area, 
		GlxNexposeCallback, nav_wf_expose_CB, NULL );

	XtAddCallback( nav_info.wf_win_info.drawing_area, GlxNresizeCallback,
			nav_wf_resize_CB, NULL );

	return( nav_info.wf_win_info.drawing_area );
}

/************************************************************************/
/*									*/
/*			Wireframe Key Routines				*/
/*									*/
/************************************************************************/

Widget create_wf_key_drawing_area( parent )
Widget	parent;
{
	int			n;
	Arg			args[20];	/* Argument List */
	int			width;
	int			height;
	static GLXconfig 	glxConfig[] =
				{
					{ GLX_NORMAL, GLX_DOUBLE, TRUE },
					{ GLX_NORMAL, GLX_RGB, TRUE },
					{ GLX_NORMAL, GLX_ZSIZE, GLX_NOCONFIG },
					{ 0, 0, 0 }
				};

	extern C_NavInfo	nav_info;

	extern void 		nav_wf_key_expose_CB();
	extern void		nav_wf_key_resize_CB();

	/*********************************************************/
	/*      Create a Drawing Area For Wireframe Keys 	 */
	/*********************************************************/
	width 	= nav_info.wf_key_win_info.width_pixels;
	height	= nav_info.wf_key_win_info.height_pixels;

	n=0;
	XtSetArg( args[n], XmNy, 0 );
	XtSetArg( args[n], XmNy, 0 );
	XtSetArg( args[n], XmNwidth, width ); n++;
	XtSetArg( args[n], XmNheight, height ); n++;
	XtSetArg( args[n], GlxNglxConfig, glxConfig ); n++;
	nav_info.wf_key_win_info.drawing_area = 
		GlxCreateMDraw( parent,"nav_key_drawing_area", args, n );
	XtManageChild( nav_info.wf_key_win_info.drawing_area );

	XtAddCallback( nav_info.wf_key_win_info.drawing_area, 
		GlxNexposeCallback, nav_wf_key_expose_CB, NULL );

	XtAddCallback( nav_info.wf_key_win_info.drawing_area, 
		GlxNresizeCallback, nav_wf_key_resize_CB, NULL );

	return( nav_info.wf_key_win_info.drawing_area );
}
