/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File:   GL_ide_spaceball.c 
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: GL routines for driving input device spaceball 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <gl/gl.h>
#include <gl/device.h>
#include <gl/spaceball.h>
#include "C_ide.h"

int SP_PRESS_RELEASE = 0;

static double velocity_x, velocity_y, velocity_z;

void gl_spaceball_rezero()
{
sbrezero();
}

void gl_spaceball_rotate(data, scale, result)
short data[3];
double scale;
Matrix result;
{
  float tmp[3];

  tmp[0] = ldexp( (double)data[0], -14);
  tmp[1] = ldexp( (double)data[1], -14);
  tmp[2] = ldexp( (double)data[2], -14);


  rotarbaxis(scale, tmp[0], tmp[1], tmp[2], result);

}

int spaceball_test_button()
{
  Device dev;
  short data;

  int button;

  button = -1;

  while (dev = qtest() && (button==-1))
   {
     dev = qread(&data);
     
     if (data == SP_PRESS_RELEASE) 
          switch (dev)
           {
             case SBBUT1: button = SPACEBALL_BUT1;
                          break;
             case SBBUT2: button = SPACEBALL_BUT2;
                          break;
             case SBBUT3: button = SPACEBALL_BUT3;
                          break;
             case SBBUT4: button = SPACEBALL_BUT4;
                          break;
             case SBBUT5: button = SPACEBALL_BUT5;
                          break;
             case SBBUT6: button = SPACEBALL_BUT6;
                          break;
             case SBBUT7: button = SPACEBALL_BUT7;
                          break;
             case SBBUT8: button = SPACEBALL_BUT8;
                          break;
             case SBPICK: button = SPACEBALL_BUTPICK;
                          break;
             default: button = -1;
                          break;
           }
     else
      button = -1;

    }
   sbprompt();
   return(button);
}


    
void get_data_from_spaceball(flag, button, trans_data, rota_data, period)
int *flag;
int *button;
short trans_data[3], rota_data[3], *period;
{

   Device dev;
   short  data;
   int stop;


   stop = 0;
   *flag = -1;

   while ((dev = qtest()) && (stop == 0))
        {
          dev = qread(&data);
          switch (dev)
             {
              case SBTX: trans_data[0] = data; break;
              case SBTY: trans_data[1] = data; break;
              case SBTZ: trans_data[2] = data; break;
              case SBRX: rota_data[0] = data; break;
              case SBRY: rota_data[1] = data; break;
              case SBRZ: rota_data[2] = data; break;
              case SBPERIOD: *period = data; 
                             *flag = 0;
                             break;
              default:
                  if (data == SP_PRESS_RELEASE)
                  switch (dev)
                   {
                     case SBBUT1:   *flag = 1; 
                                    *button = SPACEBALL_BUT1;  
                                    stop = 1;
                                    break;
                     case SBBUT2:   *flag = 1;
                                    *button = SPACEBALL_BUT2;
                                    stop = 1;
                                    break;
                     case SBBUT3:   *flag = 1;
                                    *button = SPACEBALL_BUT3;
                                    stop = 1;
                                    break;
                     case SBBUT4:   *flag = 1;
                                    *button = SPACEBALL_BUT4;
                                    stop = 1;
                                    break;
                     case SBBUT5:   *flag = 1;
                                    *button = SPACEBALL_BUT5;
                                    stop = 1;
                                    break;
                     case SBBUT6:   *flag = 1;
                                    *button = SPACEBALL_BUT6;
                                    stop = 1;
                                    break;
                     case SBBUT7:   *flag = 1;
                                    *button = SPACEBALL_BUT7;
                                    stop = 1;
                                    break;
                     case SBBUT8:   *flag = 1;
                                    *button = SPACEBALL_BUT8;
                                    stop = 1;
                                    break;
                     case SBPICK:   *flag = 1;
                                    *button = SPACEBALL_BUTPICK;
                                    stop = 1;
                                    break;
                   }
               break;
         }
        }

    sbprompt(); 
}      

int gl_init_spaceball()
{
    extern void C_ide_spaceball_reset_velocity();

    if (!sbexists())
      {
/*
        printf("Cannot initialize the spaceball\n" );
*/
        return(0);
      }

    qdevice( SBTX );
    qdevice( SBTY );
    qdevice( SBTZ );
    qdevice( SBRX );
    qdevice( SBRY );
    qdevice( SBRZ );
    qdevice( SBPERIOD );
    qdevice( SBPICK );
    qdevice( SBBUT1 );
    qdevice( SBBUT2 );
    qdevice( SBBUT3 );
    qdevice( SBBUT4 );
    qdevice( SBBUT5 );
    qdevice( SBBUT6 );
    qdevice( SBBUT7 );
    qdevice( SBBUT8 );
    qreset();

    C_ide_spaceball_reset_velocity();

    sbprompt();

    return(1);
}

void gl_quit_spaceball()
{
    unqdevice( SBTX );
    unqdevice( SBTY );
    unqdevice( SBTZ );
    unqdevice( SBRX );
    unqdevice( SBRY );
    unqdevice( SBRZ );
    unqdevice( SBPERIOD );
    unqdevice( SBPICK );
    unqdevice( SBBUT1 );
    unqdevice( SBBUT2 );
    unqdevice( SBBUT3 );
    unqdevice( SBBUT4 );
    unqdevice( SBBUT5 );
    unqdevice( SBBUT6 );
    unqdevice( SBBUT7 );
    unqdevice( SBBUT8 );

    qreset();
}

void gl_init_spaceball_queue()
{
    qreset();
}

