/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: C_image_control.c
 *		      Author: Lisa Sobierajski 
 *			Date: 
 *		 Description: Image Control Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */


# include <stdio.h>
# include <string.h>
# include "C_volvis.h"


int C_enter_image( image_table, image, image_name, file_name )
C_ImageTable		*image_table;
C_Image			*image;
char			*image_name;
char			*file_name;
{
	extern void	update_ivi_active_opt();

	char		tmp_name[30];
	int		loop;

	/****	Check if there are any available entries	****/

	if ( image_table->num_images == C_MAX_IMAGES )
	{
		C_error_message("Too many images!!!\n");
		return C_ERROR;
	}

	/****	Add image into the table - first create a new ****/
	/****	C_ImageEntry				      ****/
	image_table->image_entry[image_table->num_images] = 
						C_New( C_ImageEntry );

	/****	This image is not yet being displayed   ****/
	image_table->image_entry[image_table->num_images]->ui_win = NULL;
	image_table->image_entry[image_table->num_images]->parent_win = NULL;

	loop = 1;

        sprintf( tmp_name, "%s", image_name );

	while ( C_image_name_in_image_table( image_table, tmp_name) )
        {
                loop++;
                sprintf(tmp_name, "%s_%d", image_name, loop );
        }

	/****	Now make a copy of the image_name    ****/
	image_table->image_entry[image_table->num_images]->image_name = 
		(char *) malloc( sizeof(char)*(strlen(tmp_name) + 1) );
	strcpy(image_table->image_entry[image_table->num_images]->image_name, 
	       tmp_name);

	/****	Now make a copy of the file_name    ****/
	if ( file_name )
	{
	  image_table->image_entry[image_table->num_images]->file_name = 
		(char *) malloc( sizeof(char)*(strlen(file_name) + 1) );
	  strcpy(image_table->image_entry[image_table->num_images]->file_name, 
	       file_name);
	}
	else
	{
	  image_table->image_entry[image_table->num_images]->file_name = NULL;
	}

	/****	Finally, set the image pointer correctly, and    ****/
	/****   increment the image count			 ****/
	image_table->image_entry[image_table->num_images]->image = image;
	image_table->num_images++;

	if (image_table->active_image < 0 ) image_table->active_image = 0;

	update_ivi_active_opt();	

	return C_OK;

}

int C_delete_image( image_table, image_num )
C_ImageTable		*image_table;
int			image_num;
{
	int		loop;


	/**** 	Check if this is a valid image    ****/
	if ( image_table->num_images <= image_num )
	{
		C_error_message("Internal Error: invalid image number");
		return C_ERROR;
	}

	/****   Delete the image from the table    ****/
	free( image_table->image_entry[image_num]->image_name );
	free( image_table->image_entry[image_num]->file_name );
	free( image_table->image_entry[image_num]->image->red );
	free( image_table->image_entry[image_num]->image->green );
	free( image_table->image_entry[image_num]->image->blue );
	free( image_table->image_entry[image_num]->image );
	free( image_table->image_entry[image_num] );

	image_table->image_entry[image_num] = NULL;

	/****	Fix the following entries	****/
	for (loop = image_num+1; loop < image_table->num_images; loop++)
		image_table->image_entry[loop-1] = 
			image_table->image_entry[loop];

	image_table->image_entry[image_table->num_images - 1] = NULL;

	/****	Decrement the number of images    ****/
	image_table->num_images--;

	/****   Fix the active image if necessary    ****/
	if ( image_table->num_images == 0 )	
		image_table->active_image = -1;
	else if ( image_table->active_image == image_num )
		image_table->active_image = 0;

	C_update_system( C_IMAGE_DELETED );

	return C_OK;

}

int C_image_name_in_image_table( image_table, image_name )
C_ImageTable		*image_table;
char			*image_name;
{
	int loop;

	for (loop = 0; loop < image_table->num_images; loop++)
	{
		if ( strcmp( image_table->image_entry[loop]->image_name,
			     image_name ) == 0 )
			return TRUE;
	}

	return FALSE;

}

int C_get_image_number( image_table, image_name )
C_ImageTable		*image_table;
char			*image_name;
{
	int loop;

	for (loop = 0; loop < image_table->num_images; loop++)
	{
		if ( strcmp( image_table->image_entry[loop]->image_name,
			     image_name ) == 0 )
			return( loop );
	}

	return( -1 );

}
