/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: C_ide_infor_base.c
 *                Author: He, Taosong
 *                  Date: 1/19/93
 *           Description: C routines for input device UI creation
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/


# include <stdio.h>
# include <stdlib.h>
# include <string.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

# include "C_ide.h"


void C_ide_query_device_list(list)
int *list;
{
   list = IDE_avilable_list;
}

void C_ide_query_parameter_source(window, configuration)
Window window;
C_IDE_VD_configuration *configuration;
{

   extern void X_get_window_index();
   int window_index;

   X_get_window_index(window, &window_index); 

   if (window_index != -1)
    {
      configuration = &(IDE_VD_configuration[window_index]);
      configuration-> flag = 1;
    }
   else 
    {
      configuration->flag = -1;
    }
}

 
void C_ide_query_active_parameter_source(configuration)
C_IDE_VD_configuration *configuration;
{
    configuration = &IDE_active_config;
    configuration->flag = 1;
}

void C_ide_query_device_classification(window, classification)
Window window;
C_IDE_VD_classification *classification;
{
   
   extern void X_get_window_index();
   int window_index;

   X_get_window_index(window, &window_index);

   if (window_index != -1)
    {
      classification = &(IDE_VD_classification[window_index]);
      
      classification-> flag = 1;
    }
   else
    {
      classification->flag = -1;
    }
}
  
   
void C_ide_query_active_device_classification(classification)
C_IDE_VD_classification *classification;
{
   classification = &(IDE_VD_classification[window_index]);
   classification-> flag = 1;

}   


