/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: C_radiosity.h
 *                    Author:
 *                      Date: 
 *               Description: Routines Of VolVis
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *
 */


#define C_RANDOM_XY             0
#define C_RANDOM_YZ             1
#define C_RANDOM_ZX             2

#define C_RAD_MAX_GROUP         100

typedef struct
{
        int             cell;
        C_Byte          location[8][3];
        float           base_normal[3];
        float           max_normal_diff;
        C_Byte          normal_diff[8][3];
        float           intensity[8][3];
        float           delta_intensity[8][3];
} C_RadSampleCell;

struct C_rad_se_type
{
        C_RadSampleCell         sample_cell[C_RAD_MAX_GROUP];
        struct C_rad_se_type    *next;
};

typedef struct C_rad_se_type C_RadSampleElement;

typedef  struct
{
        C_Byte                  needs_recalculating;
        int                     sample_count;
        C_RadSampleElement      *samples;
} C_RadVolumeSamples;

