/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/





/****************************************************************/
/*								*/
/*	Global Color Declaration For Use In Navigator		*/
/*								*/
/****************************************************************/

static C_Color	nav_global_color_defs[6] = { {255,   0,   0},
		      {  0, 255,   0},
		      {  0, 100, 255},
		      {255,   0, 255},
		      {190, 190, 190},
		      {255, 255, 255} };

#define C_NAV_WF_RED		0
#define C_NAV_WF_GREEN		1
#define C_NAV_WF_BLUE		2	
#define C_NAV_WF_PURPLE		3
#define C_NAV_WF_GREY		4
#define C_NAV_WF_WHITE		5

static XColor		nav_global_xcolor;
static Pixel		nav_global_pixel;
static XGCValues	nav_global_gcvalues;

/****************************************************************/
/*								*/
/*			STARBASE Graphics Macros		*/
/*								*/
/****************************************************************/
#ifdef C_STARBASE

#include <starbase.c.h>

#define   C_Draw_Shaded_Rect(XTR,N,A,B,C,D)  \
		clist[0].x = n[N][0],  \
                clist[0].y = n[N][1],  \
                clist[0].z = n[N][2],  \
                clist[1].x = v[A][0],  \
                clist[1].y = v[A][1],  \
                clist[1].z = v[A][2],  \
                clist[2].x = v[B][0],  \
                clist[2].y = v[B][1],  \
                clist[2].z = v[B][2],  \
                clist[3].x = v[C][0],  \
                clist[3].y = v[C][1],  \
                clist[3].z = v[C][2],  \
                clist[4].x = v[D][0],  \
                clist[4].y = v[D][1],  \
                clist[4].z = v[D][2],  \
                polygon3d(nav_info.pj_win_info.fildes, clist, 4,FALSE)

#define	C_Draw_Wireframe_Rect(XTR,A,B,C,D)	

#define C_Draw_Line(XTR,A,B)

#define C_Draw_String(XTR,X,Y,S)

#define C_Set_Line_Color(XTR,A)

#define C_Set_Line_Style(XTR,A)

#define C_Setup_Line_Styles()

#define C_Setup_Matrix(XTR,N)  		\
	push_matrix3d(nav_info.pj_win_info.fildes, N )

#define C_Pop_Matrix(XTR,N)  		\
		pop_matrix3d(nav_info.pj_win_info.fildes,N)

#define C_Flush_Graphics(XTR)

#define C_Swap_Buffers(XTR,N)  		\
		dbuffer_switch(nav_info.pj_win_info.fildes, N = !N)

#endif

/****************************************************************/
/*								*/
/* 			GL Graphics Macros			*/
/*								*/
/****************************************************************/
#ifdef C_GL

#include <gl/gl.h>


#define  C_Draw_Shaded_Rect(XTR,N,A,B,C,D)	\
		bgnpolygon(),		\
		n3f(n[N]),		\
		v3f(v[A]),		\
		v3f(v[B]),		\
		v3f(v[C]),		\
		v3f(v[D]),		\
		endpolygon()

#define	C_Draw_Wireframe_Rect(XTR,A,B,C,D)	\
		bgnclosedline(),	\
		v3f(v[A]),		\
		v3f(v[B]),		\
		v3f(v[C]),		\
		v3f(v[D]),		\
		endclosedline()

#define C_Draw_Line(XTR,A,B)		\
		bgnline(),		\
		v3f(v[A]),		\
		v3f(v[B]),		\
		endline()

#define C_Draw_String(XTR,X,Y,S)		\
		cmov2i( X, Y ),		\
		charstr( S )

#define C_Set_Line_Color(XTR,A)		\
		RGBcolor( nav_global_color_defs[A].red, \
			  nav_global_color_defs[A].green, \
			  nav_global_color_defs[A].blue)

#define C_Set_Line_Style(XTR,A)		\
		setlinestyle(A)

#define C_Setup_Line_Styles()		\
		deflinestyle(1, 0xf0f0)

#define C_Setup_Matrix(XTR,N)  		\
		mmode(MVIEWING),	\
		pushmatrix(),  		\
		multmatrix( N )

#define C_Pop_Matrix(XTR,N)  		\
		mmode(MVIEWING),	\
		popmatrix()

#define C_Flush_Graphics(XTR)		\
		gflush()

#define C_Swap_Buffers(XTR,N) 		\
		swapbuffers()

#endif

/****************************************************************/
/*								*/
/* 			X_GRAPHICS Graphics Macros		*/
/*								*/
/****************************************************************/
#ifdef C_X_GRAPHICS

#define C_Draw_Shaded_Rect(XTR,N,A,B,C,D)  			\
	C_xgrph_draw_shaded_rect( XTR, v, A, B, C, D )

#define	C_Draw_Wireframe_Rect(XTR,A,B,C,D)

#define C_Draw_Line(XTR,A,B)					\
	C_xgrph_draw_line( XTR, v, A, B )

#define C_Draw_String(XTR,X,Y,S)

#define C_Setup_Matrix(XTR,N)  

#define C_Pop_Matrix(XTR,N)  

#define C_Set_Line_Color(XTR,A)						   \
	nav_global_xcolor.red   = nav_global_color_defs[A].red;    	   \
	nav_global_xcolor.green = nav_global_color_defs[A].green;  	   \
	nav_global_xcolor.blue  = nav_global_color_defs[A].blue;   	   \
	if ( XTR.depth == 24 )					 	   \
	{								   \
                nav_global_xcolor.red *= 256;				   \
                nav_global_xcolor.green *= 256;				   \
                nav_global_xcolor.blue *= 256;				   \
                nav_global_pixel = C_Get_Pixel( nav_global_xcolor );	   \
	}								   \
	else if ( XTR.depth == 8 )				  	   \
	{					   			   \
                nav_global_pixel = XTR.first_color_index +		   \
                    C_Round(((float)(nav_global_xcolor.red)/63.75))*25 +   \
                    C_Round(((float)(nav_global_xcolor.green)/63.75))*5 +  \
                    C_Round(((float)(nav_global_xcolor.blue)/63.75));	   \
	}					   			   \
	nav_global_gcvalues.foreground = nav_global_pixel;		   \
	XChangeGC( XTR.display, XTR.gc, GCForeground, &nav_global_gcvalues )


#define C_Set_Line_Style(XTR,A)

#define C_Setup_Line_Styles()

#define C_Flush_Graphics(XTR)

#define C_Swap_Buffers(XTR,N) 		\
	XCopyArea( XTR.display, XTR.pixmap, XTR.window, XTR.gc,  \
		   0, 0, XTR.width_pixels, XTR.height_pixels, 0, 0 )

#endif

#define	C_NAV_SOLID_LINE	0
#define	C_NAV_DASHED_LINE 	1

#define	C_Load_Normal(N)  \
		N[0][0] = -1.0, \
	 	N[0][1] =  0.0, \
		N[0][2] =  0.0, \
				\
		N[1][0] = 1.0,  \
		N[1][1] = 0.0,  \
		N[1][2] = 0.0,  \
				\
		N[2][0] =  0.0, \
		N[2][1] = -1.0, \
		N[2][2] =  0.0, \
				\
		N[3][0] = 0.0,  \
		N[3][1] = 1.0,  \
		N[3][2] = 0.0,  \
				\
		N[4][0] = 0.0,  \
		N[4][1] = 0.0,  \
		N[4][2] = -1.0, \
				\
		N[5][0] = 0.0,  \
		N[5][1] = 0.0,  \
		N[5][2] = 1.0

