/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: C_measure.h
 *                Author: Hui Chen
 *                  Date:
 *           Description:
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/************************************************************************/
/*                                                                      */
/*                      Measurement Constants                           */
/*                                                                      */
/************************************************************************/

/* Maximum index of the hash table used in the 
   list structure for surface tracking algorithm.
 */
#define C_MEA_HASH_MAX	511

/* mea_method defines */
#define C_VOXEL_METHOD    0
#define C_CELL_METHOD     1
#define C_ANALY_METHOD     2

/* mea_tool defines */
#define C_SURFACE       0
#define C_VOLUME        1
#define C_SURFACE_SEED	2
#define C_VOLUME_SEED	3
#define C_DISTANCE	4

/* surface tracking face direction defines */
#define	C_MEA_RIGHT	0
#define	C_MEA_LEFT	1
#define	C_MEA_UP	2
#define	C_MEA_DOWN	3
#define	C_MEA_BACK	4
#define	C_MEA_FRONT	5

/************************************************************************/
/*                                                                      */
/*                      Measurement Typedefs                            */
/*                                                                      */
/************************************************************************/

/* Seed point structure */
typedef struct
{
	C_MeasureFlag	flag; /* seed is valid or not */
	int	volume_index; /* which volume the seed belongs to */
	C_IPosition	seed; /* voxel coordinate of the seed point */
} C_SeedPoint;


/* Global structure used in measurement facility of VolVis */
typedef struct
{
	int mea_tool;		/* current tool used in measurement */ 
	int mea_method;		/* current method used in measurement */
	int mea_volume;		/* the index of volume being measured now */
	C_SeedPoint seed1;	/* current seed point used in measurement */
	C_SeedPoint seed2;	/* saved seed point, no use if don't compute
				   the distance between two seed points */
	int low;		/* low threshold value used for segmentation */
	int high;		/* high threshold value used for segmentation */
	int complementary;	/* indicate the complementary case of 
				   14 Marching Cube patterns, used for volume
				   computation of the third method */
	int steps;		/* maximum number used to devide a cell on each
				   edge of cell, for third method */
	Widget pulldown;
	Widget option_menu;
	Widget options[C_MAX_VOLUMES];
} C_MeaInfo;

/* structure contains pointers to the eight vertices
   of the cell in one of the standard patterns.
   See my report for numbering system.
 */
typedef struct
{
        C_Voxel_8bit *v1, *v2, *v3, *v4, *v5, *v6, *v7, *v8;
} C_Mea_Vertices;


/* Structure for a face element in a marked faces list 
   for surface tracking algorithm.
 */
typedef struct
{
	int		index;
	int		direction;
} C_MeaFaceElement;

/* Structure of a marked faces list for surface tracking algorithm. */
struct mea_facelist
{
	C_MeaFaceElement 	face;
	struct mea_facelist	*next_face;
};
typedef struct mea_facelist C_MeaFaceList;
	
/* Structure of a surface list for surface tracking algorithm. */
typedef struct
{
	int		index;
	C_Voxel_8bit		value;
} C_MeaVoxelElement;

struct mea_voxellist
{
	C_MeaVoxelElement	voxel;
	struct mea_voxellist	*next_voxel;
};

typedef struct mea_voxellist C_MeaVoxelList;

/************************************************************************/
/*                                                                      */
/*                      Measurement Macros                              */
/*                                                                      */
/************************************************************************/

#define triangle(ax,ay,az,bx,by,bz)                                         \
                        (float)sqrt( (double)C_Square(((ay*bz)-(az*by))) +  \
                                     (double)C_Square(((az*bx)-(ax*bz))) +  \
                                     (double)C_Square(((ax*by)-(ay*bx))))
/* notice that I didn't do "devided by 2. i.e. /2." for triangle area
   as the formula does in order to save time
*/

#define index_cal(P,L,H,X,Y,Z,I)        I = 0;                        \
                                        if(C_In_Range(*(P),L,H))      I = 1;  \
                                        if(C_In_Range(*(P+X),L,H))    I+= 2;  \
                                        if(C_In_Range(*(P+X+Y),L,H))  I+= 4;  \
                                        if(C_In_Range(*(P+Y),L,H))    I+= 8;  \
                                        if(C_In_Range(*(P+Z),L,H))    I+= 16; \
                                        if(C_In_Range(*(P+Z+X),L,H))  I+= 32; \
                                        if(C_In_Range(*(P+Z+Y+X),L,H)) I+= 64; \
                                        if(C_In_Range(*(P+Z+Y),L,H))   I+= 128



#define C_Count_Face(P,L,H,X,Y,Z)       (!(C_In_Range(*(P+X),L,H)) +  \
                                         !(C_In_Range(*(P-X),L,H)) +  \
                                         !(C_In_Range(*(P+Y),L,H)) +  \
                                         !(C_In_Range(*(P-Y),L,H)) +  \
                                         !(C_In_Range(*(P+Z),L,H)) +  \
                                         !(C_In_Range(*(P-Z),L,H)))


#define C_LEFT_Face(P,L,H,X)		(!(C_In_Range(*(P-X),L,H))) 

#define C_RIGHT_Face(P,L,H,X)		(!(C_In_Range(*(P+X),L,H))) 


/* Trilinear interpolation function which terms have been 
   reorganized to save computation time.
 */
#define C_Mea_Trilin(c0,c1,c2,c3,d0,d1,d2,d3,x,y,z)     \
         (int) (c0 + c1 * x + c2 * y + c3 * x * y +     \
              (d0 + d1 * x + d2 * y + d3 * x * y) * z)

