/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: C_ide.h
 *                Author: Taosong He 
 *                  Date: 05/11/1993
 *           Description: Constants and typedefs
 *  Modification History:
 *
 *         who?               when?           why?
 *    -----------------------------------------------------------
 *
 */

/* Mouse constants */

# define C_MOUSE_MAX_LABELS 3
# define C_MAX_TRANS        1
# define C_MAX_ROT          3
# define C_MAX_TRANS_ROT    1
# define C_Traid_Mouse      0
# define C_Trackball        0
# define C_Arcball          1
# define C_Slides           2
# define C_Manual           0
# define MOUSE_THREE_AXES_MODE 0
# define MOUSE_ONE_AXIS_MODE   1
# define MOUSE_ARCBALL_MODE    2
# define MOUSE_ACTIVE          TRUE
# define MOUSE_INACTIVE        FALSE
# define MOUSE_TIMEOUT         50

/* Spaceball constants */

# define C_ACCELERATION_MODE 1
# define C_VELOCITY_MODE 0
# define SPACEBALL_PRESS 1
# define SPACEBALL_TIMEOUT 50
# define SPACEBALLBUTTON -1
# define SPACEBALL_BUTPICK 8
# define SPACEBALL_BUT1 0
# define SPACEBALL_BUT2 1
# define SPACEBALL_BUT3 2
# define SPACEBALL_BUT4 3
# define SPACEBALL_BUT5 4
# define SPACEBALL_BUT6 5
# define SPACEBALL_BUT7 6
# define SPACEBALL_BUT8 7

/* DataGlove constants */

# define C_DATAGLOVE_MAX_SIMULATION_NUMBER 1
# define C_DATAGLOVE_BAUDRATE_NUMBER 6
# define C_VPL 0
# define C_DATAGLOVE_GESTURE -2

/* VPL Datagloev contants */
# define C_VPL_LEFT_HAND 0
# define C_VPL_RIGHT_HAND 1

# define C_SCREEN           0
# define C_WINDOW           1
# define C_PIXEL            0
# define C_NORMALIZED       1
#define C_MAX_OPERATION_NUMBER 10
#define C_MAX_STRING_LENGTH 20
# define MAX_DEG  360
# define C_MAX_SELECTION_NUMBER 10
# define C_MOUSE    0
# define C_KEYBOARD  4
# define C_SPACEBALL 2
# define C_ISOTRAK  1
# define C_DATAGLOVE 3
# define C_CURRENT_RD_NUMBER 5
# define KEYBOARD_TIMEOUT 20
# define C_EULER  0
# define C_QUATERNION 1
# define C_MATRIX 2
# define IDE_DEFAULT 0
# define C_MAX_VD_NUMBER 10
# define C_MAX_RD_NUMBER 10
# define C_MAX_WINDOW_NUMBER 10 
# define SEL_TIMEOUT           50
# define C_WIN_EXPOSE          0
# define C_WIN_RESIZE          1
# define C_WIN_REDRAW          2
# define C_WIN_ENTER           3
# define C_WIN_LEAVE           4



/* Linked List Queue Structure For Input Device Selection */
struct select_node
{
	int                     selection;
	struct select_node	*next;
}; 

typedef struct select_node C_SelectionQ;

/* Linked List Queue Structure For Window Events */
struct window_node
{
        int			win_event;
	struct window_node	*next;
};


typedef struct window_node C_WindowQ;

typedef struct {
        int source_device;
        int operation_number;
} selection_map;

typedef struct {
        char name[C_MAX_STRING_LENGTH];
} C_ide_operation_map;

typedef struct 
{
int window_index;
int process_status;
} C_ide_start_end_information;

typedef struct {
int width;
int height;
int window_index;
} C_IDE_window_information;

typedef struct
{
int  device;
int  button;
int  state;
} select_information;

typedef struct {

int device_involved[C_MAX_RD_NUMBER];

int orientation_mode;
int ori;  

int pos2dx;
int pos2dy;

int pos3dx;
int pos3dy;
int pos3dz;

int oriazi;
int oriele;
int orirol;

selection_map selection[C_MAX_SELECTION_NUMBER]; 
} C_IDE_VD_configuration;

typedef struct {
int orientation_mode;
int orientation;

int pos2dx;
int pos2dy;

int pos3dx;
int pos3dy;
int pos3dz;

selection_map selection[C_MAX_SELECTION_NUMBER];
} C_VD_CONFIGURATION;

typedef struct {
int flag;
int type;
unsigned int state;
unsigned int button;
} C_IDE_mouse_lookup;

typedef struct {
int flag;
int type;
unsigned int state;
unsigned int keycode;
} C_IDE_keyboard_lookup;

typedef struct {
int type;
int flag;
int button;
} C_IDE_spaceball_lookup;

/* Mouse simulation data type */
typedef struct {
    int                             trans_simu;
    int                             rot_simu;
    int                             trans_rot_simu;
    int                             simulate_switch_simu;
} mouse_simulation;

/* Spaceball simulation data type */
typedef struct {
    int                 rotation_dominate;
    int                 translate_dominate;
    int                 acceleration_velocity_mode;
    float               rotation_rate;
    float               translation_rate;
} spaceball_simulation;

/* DataGlove simulation data type */
typedef struct {
    int                 active;
    int                 baudrate;
    int                 simulation;
    int                 calibrated;
} dataglove_simulation;

typedef struct {
    char                gesture_path[100];
    char                gesture_file[100];
    int                 hand;
} C_IDE_dataglove_vpl_simulation;

/* Data type to keep track of all the input devices */
typedef struct {
    mouse_simulation     mouse;
    spaceball_simulation spaceball;
    dataglove_simulation dataglove;
    int unit;
    int mode;
} C_IDE_simulation_method;
