/* -*- c -*-
  $Id: pycdio.swg,v 1.6 2008/05/01 16:55:05 karl Exp $

  Copyright (C) 2006, 2008 Rocky Bernstein <rocky@gnu.org>

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
%define DOCSTRING 
"This is a wrapper for The CD Input and Control library (libcdio) which
encapsulates CD-ROM reading and control. Python programs wishing to be
oblivious of the OS- and device-dependent properties of a CD-ROM can
use this library."
%enddef
%module(docstring=DOCSTRING) pycdio
%{
/* Includes the header in the wrapper code */
#include <cdio/cdio.h>
#include <cdio/audio.h>
#include <cdio/cdtext.h>
#include <cdio/cd_types.h>
%}

#include <cdio/cdio.h> 
#include <cdio/audio.h>
#include <cdio/cdtext.h>

%include "compat.swg"

%include "typemaps.i"
%include "cstring.i"

/* Various libcdio constants and typedefs */
%include "types.swg"

%feature("autodoc", 1);

%include "audio.swg"
%include "read.swg"
%include "track.swg"
%include "cdtext.swg"

/* In the presence of the exception handling, the order is important. 
   The below use %exception.
*/
%include "device.swg"
%include "disc.swg"

/* Encapsulation is done in two parts. The lower-level python
interface is called pycdio and is generated by SWIG.

The more object-oriented module is cdio; it is a Python class that
uses pycdio. Although pycdio is perfectly usable on its own, it is
expected that cdio is what most people will use. As pycdio more
closely models the C interface, it is conceivable (if unlikely) that
diehard libcdio C users who are very familiar with that interface
could prefer that.

It is probably possible to change the SWIG in such a way to combine
these pieces. However there are the problems. First, I'm not that much
of a SWIG expert. Second it looks as though the resulting SWIG code
would be more complex. Third the separation makes translation very
straight forward to understand and maintain: first get what's in C
into Python as a one-to-one translation. Then we implement some nice
abstraction off of that. The abstraction can be modified without
having to redo the underlying translation. (But the reverse is
generally not true: usually changes to the C-to-python translation,
pycdio, do result in small, but obvious and straightforward changes to
the abstraction layer cdio.)
 */
#define INCLUDE_CLASS 0
#if INCLUDE_CLASS
/* In spite of the above, if we were to do things as a one-step approach,
   this might be how it would be done. */
%pythoncode %{
%include "cdio.py"
%}
#endif
