/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class InstanceOfExpression
extends ComputedExpression {
    Expression source;
    ItemType targetType;
    int targetCardinality;

    public InstanceOfExpression(Expression expression, SequenceType sequenceType) throws XPathException {
        this.source = expression;
        this.targetType = sequenceType.getPrimaryType();
        if (this.targetType == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.targetCardinality = sequenceType.getCardinality();
    }

    public Expression simplify() throws XPathException {
        this.source = this.source.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.source = this.source.analyze(staticContext);
        if (this.source instanceof Value) {
            return (AtomicValue)this.evaluateItem(null);
        }
        if (Cardinality.subsumes(this.targetCardinality, this.source.getCardinality()) && Type.isSubType(this.source.getItemType(), this.targetType)) {
            return BooleanValue.get(true);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.source = this.source.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.source};
        return expressionArray;
    }

    public int computeCardinality() {
        return 512;
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.source.iterate(xPathContext);
        int n = 0;
        while ((item = sequenceIterator.next()) != null) {
            ++n;
            if (!this.targetType.matchesItem(item)) {
                return false;
            }
            if (n != 2 || Cardinality.allowsMany(this.targetCardinality)) continue;
            return false;
        }
        return n != 0 || (this.targetCardinality & 0x100) != 0;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "instance of");
        this.source.display(n + 1, namePool);
        System.err.println(ExpressionTool.indent(n + 1) + this.targetType.toString() + Cardinality.getOccurrenceIndicator(this.targetCardinality));
    }
}

