/* HDF RIS8 module */
#include "defs.h"
#include <stdio.h>
#include <math.h>
#include "hdf.h"
#include "df.h"				/*  get this from NCSA */
#define byte_size 8
#define BASE_INDEX 8
/* store these pointers to allow lookups into the CGM data structures */
static struct one_opt 		*popt;	/* the command line options, in only */
static struct mf_d_struct 	*pc1;	/* the class 1 elements, in only */
static struct pic_d_struct 	*pc2;	/* the class 2 elements, in only */
static struct control_struct	*pc3;	/* the class 3 elements, in only */
static struct attrib_struct	*pc5;	/* the class 5 elements, in only */
static struct info_struct 	*dptr;	/* device info in and out */

/* these are the screen variables */
#define max_str 128
static char fname[max_str + 1];
static int state_level;
void set_colour();
extern char *allocate_mem();
static int max_val;	/* maximum colour value */
#define MAX_D_VAL 255		/* max direct colour value */

/* HDF image stuff */
#define	SINGLE_FILE	1
static int ftype;
static char palette[(MAX_D_VAL+1)*3];
static char ccolor;
static char *image;
int x_imsize=640,y_imsize=480;
int x_imoffset=0,y_imoffset=0;
int hdf_xsize,hdf_ysize,xymin;

/* macro to convert from real to integer colour value */
#define byte_col(r_col) ((unsigned char) ((r_col) * MAX_D_VAL + 0.49999))
static struct rgbi_struct back_col;
static int my_inds[3];
/* start everything up */
hdf_begin(comment, file_name, prog_name)
char *comment, *file_name, *prog_name;

{
	return(1);
}
/* start a page  */
hdf_bpage(pic_name, xoffset, yoffset, rotation, rb, gb, bb, page_no, 
    xsize, ysize)
char *pic_name;
float rotation;
int xoffset, yoffset, page_no, xsize, ysize;
float rb, gb, bb;	/* background colour values */
{
int i, top_index;
short red, green, blue;

	/* set the background colour */
	back_col.ind = 0;
	back_col.red = rb;
	back_col.green = gb;
	back_col.blue = bb;
	palette[0] = byte_col(rb);
	palette[1] = byte_col(gb);
	palette[2] = byte_col(bb);
	set_colour(&back_col);

	x_imoffset = xoffset;
	y_imoffset = yoffset;

	image = (char *) malloc(x_imsize*y_imsize);
	for(i=0;i<x_imsize*y_imsize;i++)
		image[i] = ccolor;
	xymin = min(x_imsize,y_imsize);

	if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
		fprintf(stderr,"No support for direct color yet");
		exit(22);
	} else 
	if (pc2->c_s_mode == i_c_mode) {	/* indexed colour */
	    /* fill out the colour map */
	    top_index = ((pc1->max_c_index) > max_val) ? max_val :
	    	pc1->max_c_index;
	    for (i=1; i < top_index; ++i) {
	            palette[i*3] =  byte_col(*(pc5->ctab + i * 3));
		    palette[i*3+1] = byte_col(*(pc5->ctab + i * 3 + 1)); 
		    palette[i*3+2] = byte_col(*(pc5->ctab + i * 3 + 2));
	    }
	} else {
	    fprintf(stderr, "illegal colour mode %d\n", (int) pc2->c_s_mode);
	}
	return(1);

}
/* end a page */
hdf_epage(copies)
int copies;
{
static int frames=0;
int ret;
char ffname[128];
char f2name[128];

   if( ftype == SINGLE_FILE )
   {
	if( frames==0 )
	{
	   DFR8setpalette( palette );
	   ret=DFR8putimage(fname, image, x_imsize, y_imsize,DFTAG_RLE);
	}
	else
	   DFR8addimage(fname, image, x_imsize, y_imsize,DFTAG_RLE);

    }
    else
    {
	strcpy(f2name,fname);
	sprintf(ffname,strcat(f2name,"%04d.hdf"),frames);
	DFR8setpalette( palette );
	DFR8putimage(ffname,image,x_imsize,y_imsize,DFTAG_RLE);
    }

	frames++;
	free(image);
	return(1);
}
/* end the metafile */
hdf_end(pages_done)
int pages_done;
{
	return(1);
}
/* plot a set of lines between alternate points */
hdf_dpline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
unsigned int dpl_atb;

	return(1);
}
/* do line between a series of points */
hdf_pline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
int i;
void rline();

	set_colour(&pc5->line_colour);

	for(i=0; i< no_pairs-1; i++)
		rline(x1_ptr[i],y1_ptr[i],
		      x1_ptr[i+1],y1_ptr[i+1]);

	return(1);
}

/* do a polygon, may want to fill it */
hdf_pgon(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
#define MAX_VERTICES 8192
long my_vert[2];
int i, want_edge;
void rpoly();
static int pn_num=0;
	if ( no_pairs <= 1 ) return(1);
	if (no_pairs > MAX_VERTICES) no_pairs = MAX_VERTICES; /* for now */

	/* first do the polygon interior */
	switch (pc5->int_style) {
	case hollow :
	case empty :		set_colour(&back_col); break;

	
	case pattern :	
		/* no pattern fill yet */
	case hatch :	
		/* no hatch fill yet */
	case solid_i :		set_colour(&pc5->fill_colour);
				rpoly(no_pairs,x1_ptr,y1_ptr);
				break;
	}

	/* may want visible edge */
	want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);
	if (want_edge){	
	    if (pc5->edge_vis == on) set_colour(&pc5->edge_colour);
	    else set_colour(&pc5->fill_colour);

	    for(i=0; i< no_pairs-1; i++)
	              rline(x1_ptr[i],y1_ptr[i],
			    x1_ptr[i+1],y1_ptr[i+1]);
	}

	return(1);
}
#undef MAX_VERTICES
/* do a rectangle */
hdf_rectangle(x1, y1, x2, y2)
int x1, x2, y1, y2;
{
	return(1);
}
/* first the basic circle routine */
static do_circle(x, y, r, deg0, deg1, use_atb)
int x, y, r;	/* position of centre and radius */
float deg0, deg1;	/* beginning and ending degrees (start at top) */
unsigned int use_atb;
{
	return(1);
}
/* set  a Circle */
hdf_circle(x, y, r)
int x, y, r;
{
	return(1);
}

/* set an arc, we get the positions of 1st pt, intermediate pt, end pt */
/* see utils.c for details */
hdf_c3(pt_ptr)
int *pt_ptr;
{
	return(1);
}
/* set  a closed arc, get the positions of 1st pt, intermdiate pt, end pt */
hdf_c3_close(pt_ptr, chord)
int *pt_ptr;
enum boolean chord;
{
	return(1);
}
/* set an arc, ends specified by vectors */
hdf_c_centre(x, y, vec_array, r)
int x, y, *vec_array, r;
{
	return(1);
}
/* set an arc, ends specified by vectors, but close it */
hdf_c_c_close(x, y, vec_array, r, chord)
int x, y, *vec_array, r;
enum boolean chord;
{
	return(1);
}
/* first the basic  ellipse routine */
static do_ellipse(x, y, r, deg0, deg1)
int x, y, r;	/* position of centre and radius */
float *deg0, *deg1;	/* beginning and ending degrees (start at top) */
{
	return(1);
}
/* set an ellipse, centre and two endpoints */
hdf_ellipse(pt_array)
int *pt_array;
{

	return(1);
}
/* set an elliptical arc, centre, two endpoints, vectors for ends */
hdf_ell_arc(pt_array, vec_array)
int *pt_array, *vec_array;
{

	return(1);
}
/* set an elliptical arc, close it */
hdf_e_a_close(pt_array, vec_array, chord)
int *pt_array, *vec_array;
enum boolean chord;
{

	return(1);
}

/* set marker at a series of points */
hdf_pmarker(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
	int i;
	void SetPixel();

	set_colour( &pc5->mk_colour );
	for(i=0;i<no_pairs;i++)
		SetPixel(x1_ptr[i],y1_ptr[i]);
	return(1);
}
/* for cell arrays */
hdf_carray(cp, cq, cr, nx, ny, col_prec, dat_ptr, rep_mode, no_bytes)
int *cp;	/* first corner */
int *cq;	/* the diagonal to cp p*/
int *cr;	/* first row is from cp to cr */
int nx;		/* number of elements in x rows (i.e., parallel to cp-cr) */
int ny;		/* number of rows */
int col_prec;	/* the colour precision (how many possible colour values */
unsigned char *dat_ptr;	/* pointer to the body of information */
int rep_mode;	/* the representation mode; 0, run length encoded, 1 normal */
int no_bytes;	/* number of data bytes */
{
short *new_ptr;
unsigned int new_bytes, i, j, row_size, bdone, c_size, new_size;
int x1, x2, y1, y2;
#define lctab_size 2
static float lctab[3 * lctab_size] = {1.0, 1.0, 1.0, 0.0, 0.0, 0.0};
int out_flag;
int my_flag = 0;
int want_rmode = 1;
int want_cp;
int want_csmode = 0;
int new_nx, new_ny;
int bytes_needed, bits_row, bytes_row, first_index;
int px, py, qx, qy, rx, ry;	/* the local co-ord system */

	px = cp[0];
	py = cp[1];
	qx = cq[0];
	qy = cq[1];
	rx = cr[0];
	ry = cr[1];
	want_cp = 16	/* 16 bits per pixel */;
	first_index =  (pc2->c_s_mode == d_c_mode) ? 1 : 0;
	/* the rows and columns we need */
	new_nx = (rx > px) ? 1 + rx - px : 1 + px - rx;
	new_ny = (qy > py) ? 1 + qy - py : 1 + py - qy;
	
	bits_row = new_nx * want_cp;
	bytes_row = (bits_row + byte_size - 1) / byte_size;
	bytes_needed = bytes_row * new_ny;

	if (!(new_ptr = (short *) allocate_mem(bytes_needed, 1)))
	    return(2);

	/* basically only need the bottom left hand corner, nx and ny */
	x1 = (cp[0] < cr[0]) ? cp[0] : cr[0];
	y1 = (cp[1] < cq[1]) ? cp[1] : cq[1];
	x2 = x1 + new_nx - 1;
	y2 = y1 + new_ny - 1;

/* lets make the cell array fit */

	new_carray(NULL, nx, ny, col_prec, rep_mode, 
	    0, dat_ptr, no_bytes, pc2->c_s_mode,
	    pc5->ctab, pc1->max_c_index, px, py, qx, qy,
	    rx, ry, new_nx, new_ny,
	    want_cp, want_rmode, bits_row, new_ptr, bytes_needed, 
	    want_csmode, lctab, lctab_size, my_flag, &out_flag, 
	    first_index, my_inds, &(pc1->c_v_extent));

	/* at this point we are sure of a normal cell array in cgm format; */
	/* everything almost in shape */

	/* write out the array */

	(void) free(new_ptr);
	return(1);
}
/* set text */
hdf_text(x, y, final, buffer)
int x, y, final;
char *buffer;
{
	return(1);

}
/* now set the attributes */
/* set the line type */
hdf_l_type(l_type)
enum line_enum l_type;
{
	return(1);
}
/* set the line width */
hdf_l_width(l_width, rmul)
int l_width;
float rmul;
{

	return(1);
}
/* set the character height */
hdf_cheight(size)
int size;
{

	return(1);
}
/* get a colour table here */
hdf_ctab(beg_index, no_entries, ctab)
int beg_index, 	/* beginning index */
no_entries; 	/* number of entries to add starting at beg_index */
float *ctab;	/* direct colour array, *(ctab + i*3) is the red
		   entry for the i'th index, followed by g and b */
{
int i, top_index;

	if (pc2->c_s_mode != i_c_mode) return(2);
	/* fill out the colour map */
	top_index = beg_index + no_entries;
	top_index = (top_index > max_val) ? max_val : top_index;
	for (i=beg_index; i < top_index; ++i) {
	      palette[i*3] =  byte_col(*(pc5->ctab + i * 3));
	      palette[i*3+1] = byte_col(*(pc5->ctab + i * 3 + 1)); 
	      palette[i*3+2] = byte_col(*(pc5->ctab + i * 3 + 2));
	}
	return(1);
}

/* set a font */
hdf_font(index, size)
int index, size;
{
	
	return(1);
}
/* this is the routine that sets everything up */
/* the initialising routine for the IRIS GL module */
void hdf_setup(opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl,
	gprim, attr, escfun, extfun, ctrl, pargc, argv)

struct one_opt 		*opt;	/* the command line options, in only */
struct info_struct *dev_info;	/* device info to fill out, out only */
struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
struct control_struct	*c3;	/* the class 3 elements, in only */
struct attrib_struct	*c5;	/* the class 5 elements, in only */
int (*delim[Delim_Size])();	/* delimiter functions */
int (*mfdesc[MfDesc_Size])();	/* metafile descriptor functions */
int (*pdesc[PDesc_Size])();	/* page descriptor functions */
int (*mfctrl[Control_Size])();	/* control functions */
int (*gprim[GPrim_Size])();	/* graphical primitives */
int (*attr[Att_Size])();	/* the attribute functions */
int (*escfun[Esc_Size])();	/* the escape functions */
int (*extfun[Ext_Size])();	/* the external functions */
int (*ctrl[Delim_Size])();	/* external controller functions */
int *pargc;			/* argc pointer */
char **argv;			/* argv */	
{
long xw_size, yw_size, x_wanted, y_wanted, x_start, y_start;
int no_planes;

	/* store the command line argument pointer */
	popt = opt;
	/* store the device info pointer */
	dptr = dev_info;
	/* store the CGM data structure pointers */
	pc1 = c1;
	pc2 = c2;
	pc3 = c3;
	pc5 = c5;

	/* fill out the device info structure */
	dev_info->pxl_in 	= 1.0;
	dev_info->ypxl_in 	= 1.0;


	if ( (strlen(popt[(int) device].val.str) > 3) && 
	     (popt[(int) device].val.str[3] == '2' ))
		ftype = SINGLE_FILE;
	else
		ftype = !SINGLE_FILE;

/* do we want a particular size or position ? */
	if (popt[(int) x_size].set && popt[(int) y_size].set)
	{
	    x_imsize = (int) popt[(int) x_size].val.r;
	    y_imsize = (int) popt[(int) y_size].val.r;
	}


	max_val = 256;
	ccolor = 1;
	dev_info->x_size 	= ((float)(x_imsize))-1.0;
	dev_info->y_size 	= ((float)(y_imsize))-1.0;
	dev_info->x_offset	= 0.0;	/* fix later */
	dev_info->y_offset	= 0.0;
	dev_info->c_height	= 12;
	dev_info->c_width	= 12;
	dev_info->d_l_width	= 1;				
	dev_info->d_e_width	= 1;				
	dev_info->d_m_size	= dev_info->c_height;	/* marker size */
	*dev_info->out_name	= '\0';		/* no output file */
	dev_info->capability	= 0;	/* for now */

	/* now fill out the function pointer arrays for CGM */
	/* the delimiter functions */
	delim[(int) B_Mf] 	= hdf_begin;
	delim[(int) E_Mf]	= hdf_end;
	delim[(int) B_Pic_Body]	= hdf_bpage;
	delim[(int) E_Pic]	= hdf_epage;

	/* the graphical primitives */
	gprim[(int) PolyLine]	= hdf_pline;
	gprim[(int) Polygon]	= hdf_pgon;
	gprim[(int) Cell_Array]	= hdf_carray; 
/*	gprim[(int) Dis_Poly]	= hdf_dpline;
	gprim[(int) PolyMarker]	= hdf_pmarker;
	gprim[(int) Text]	= hdf_text;
	gprim[(int) Rectangle]	= hdf_rectangle;
	gprim[(int) Cgm_Circle]	= hdf_circle;
	gprim[(int) Circ_3]	= hdf_c3;
	gprim[(int) Circ_3_Close]	= hdf_c3_close;
	gprim[(int) Circ_Centre]	= hdf_c_centre;
	gprim[(int) Circ_C_Close]	= hdf_c_c_close;
	gprim[(int) Ellipse]	= hdf_ellipse;
	gprim[(int) Ellip_Arc]	= hdf_ell_arc;
	gprim[(int) El_Arc_Close] 	= hdf_e_a_close;

*/	/* the attributes */
	attr[(int) LType]	= hdf_l_type;
	attr[(int) LWidth]	= hdf_l_width;
	attr[(int) CHeight]	= hdf_cheight;
	attr[(int) ColTab] 	= hdf_ctab;

	if( opt[(int)out_name].set )
	{
		strcpy(fname,opt[(int)out_name].val.str);
		opt[(int)out_name].set = 0;
	}
	else
	{
		if( ftype==SINGLE_FILE)
			strcpy(fname,"cgm.hdf");
		else
			strcpy(fname,"cgm");
	}

	return;
}
/* general colour setting routine */
static void set_colour(cptr)
struct rgbi_struct *cptr;
{

	if (pc2->c_s_mode == i_c_mode) {	/* indexed */
	    ccolor = (char) cptr->ind; 
	}
	return;
}

void SetPixel( x, y )
int x,y;
{
	image[(y_imsize-y-1)*x_imsize+x] = (char) ccolor;
}


