/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.finish;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.automation.AutomatedPanelView;
import com.izforge.izpack.installer.automation.AutomatedPanels;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsoleInstaller;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanelAutomationHelper;
import com.izforge.izpack.installer.container.provider.AutomatedPanelsProvider;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

public class FinishConsolePanel
extends AbstractConsolePanel {
    private static final Logger LOGGER = Logger.getLogger(FinishConsolePanel.class.getName());
    private static final String AUTO_INSTALL_SCRIPT_NAME = "auto-install.xml";
    private final Prompt prompt;
    private final ObjectFactory factory;
    private final PlatformModelMatcher matcher;
    private final ConsoleInstaller parent;
    private final UninstallData uninstallData;

    public FinishConsolePanel(ObjectFactory factory, ConsoleInstaller parent, PlatformModelMatcher matcher, UninstallData uninstallData, Prompt prompt, PanelView<ConsolePanel> panel) {
        super(panel);
        this.parent = parent;
        this.prompt = prompt;
        this.factory = factory;
        this.matcher = matcher;
        this.uninstallData = uninstallData;
    }

    public FinishConsolePanel(PanelView<ConsolePanel> panel) {
        this(null, null, null, null, null, panel);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        if (this.doGenerateAutoInstallScript()) {
            this.generateAutoInstallScript(installData, this.uninstallData, console);
        }
        if (installData.isInstallSuccess()) {
            console.println("Installation was successful");
            console.println("Application installed on " + installData.getInstallPath());
        } else {
            console.println("Installation failed!");
        }
        return true;
    }

    private boolean doGenerateAutoInstallScript() {
        return this.factory != null && this.matcher != null && this.prompt != null;
    }

    private void generateAutoInstallScript(InstallData installData, UninstallData uninstallData, Console console) {
        Prompt.Option userAnswer = this.prompt.confirm(Prompt.Type.QUESTION, installData.getMessages().get("FinishPanel.auto", new Object[0]), Prompt.Options.YES_NO);
        if (userAnswer == Prompt.Option.YES) {
            String parentPath = installData.getVariable("INSTALL_PATH");
            if (parentPath == null) {
                parentPath = installData.getVariable("USER_HOME");
            }
            File file = new File(parentPath, AUTO_INSTALL_SCRIPT_NAME);
            String filePath = console.promptLocation("Select the installation script (path must be absolute)[" + file.getAbsolutePath() + "]", file.getAbsolutePath());
            File newFile = new File(filePath);
            if (!newFile.isAbsolute()) {
                console.println("Path of the installation script must be absolute");
                this.promptRerunPanel(installData, console);
            } else {
                this.generateAutoInstallScript(newFile, installData, uninstallData, console);
            }
        }
    }

    private void generateAutoInstallScript(File file, InstallData installData, UninstallData uninstallData, Console console) {
        try {
            this.parent.writeInstallationRecord(file, uninstallData);
        }
        catch (Exception err) {
            console.println("Failed to save the installation into file [" + file.getAbsolutePath() + "]");
        }
    }

    protected AutomatedPanels getAutomatedPanels(InstallData aInstallData) {
        AutomatedPanelsProvider provider = new AutomatedPanelsProvider();
        AutomatedPanels automatedPanels = provider.provide(this.factory, (AutomatedInstallData)aInstallData, new ConsolePanelAutomationHelper(), this.matcher);
        return automatedPanels;
    }

    protected void makeXML(AutomatedPanelView panelView, InstallData installData, IXMLElement root) {
        try {
            ((PanelAutomation)panelView.getView()).createInstallationRecord(installData, root);
        }
        catch (Exception e) {
            LOGGER.warning("Unsupported panel " + panelView.getPanel().getClassName() + ": no automated helper associated?");
            this.prompt.warn(e.getMessage());
        }
    }
}

