//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//---------------------------------------------

#include <stream.h>
#include <math.h>

class lorenz {
 private:
    float in[4],out[4],f[4],savevar[4],delta_time;
    float sigma,lambda,b;
    int num_equations;
  public:
    lorenz();
    void next_state();
    void integrate();
    void print_time();
  };

lorenz lor1;
float simtime;

main()
{
  simtime = 0.0;
  while (simtime < 100.0) {
   lor1.next_state();
   lor1.integrate(); 
   // output x2,x3 
   lor1.print_time();
  } // end while 
} // end main 

lorenz::lorenz()
{
  num_equations = 3;
  out[1] = 1.0;
  out[2] = 1.0;
  out[3] = 1.0;

  sigma= 10.0;
  lambda = 24.0;
  b = 2.0;
  delta_time = 0.01;
}

void lorenz::next_state()
{ 
// Calculate state 
  in[1] = sigma*(out[2] - out[1]);
  in[2] = (1+lambda-out[3])*out[1] - out[2];
  in[3] = out[1]*out[2] - b*out[3];
}
 
void lorenz::integrate()
{
  int i;

  for (i=1;i<=num_equations;i++) {
    f[i] = delta_time*in[i];
    savevar[i] = out[i];
    out[i] += f[i]/2;
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i]/2;
  }
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i];
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) 
    out[i] = savevar[i] + (f[i] + delta_time*in[i])/6;
}

void lorenz::print_time()
{
  cout<<out[2]<<"  "<<out[3]<<"\n";
}
