%{

/************************************************************************\
*                                                                        *
*  GS: A Generalized, stochastic petri net Simulator                     *
*      V0.01      March 1989      Andreas Nowatzyk (agn@unh.cs.cmu.edu)  *
*      Carnegie-Mellon Univerity, School of Computer Science             *
*      Schenley Park, Pittsburgh, PA 15213                               *
*                                                                        *
\************************************************************************/

/*
 *  Grammar of the GSPN-Simuator input format.
 *
 *  I know that this isn't compatible with GreatSPAN's files,
 *  but I want something that could be understood with an normal
 *  text editor as well as with a specialized graphic tool. A simple
 *  list of numbers isn't my style.
 *
 */

#include <strings.h>
#include <stdio.h>
#include "gs_pp.h"

char src_file[80] = "<stdin>", it_opr;

%}

%start gspn			/* Grammar entry		 */

%union ytoken { char *SYM; double VALUE;}
%type <SYM> sum item marking logic_cond compare opt_val
%token <SYM> NAME REL_OP
%token <VALUE> VAL
%token END TERM SEP COL NEXT NOT RATE MARKS DEPEND DET IMM EXP TRANS PLACE RESULT PARAM
%token PROB EXP OP_BR CL_BR OP_PAR CL_PAR COND AND OR HASH PLUS MINUS BIMOD NORM DWT FIRE

%left OR
%left AND
%left NOT

%%

gspn	    :	body END
	    ;

body	    :	statement
	    |	body statement
	    ;

statement   :	place TERM
	    |	transition TERM
	    |	parameter TERM
	    |   result TERM
	    |	error TERM
	    ;


parameter   :	PARAM NAME VAL		{add_param($2, $3);}
	    ;


place	    :	PLACE NAME		{add_place($2);}
		pl_plist
	    ;

pl_plist    :
	    |	pl_params
	    ;

pl_params   :	pl_param
	    |	pl_params SEP pl_param
	    ;

pl_param    :	MARKS VAL		{chg_marks($2);}
	    |	MARKS NAME		{chg_p_marks($2);}
	    ;


transition  :	TRANS NAME		{add_transition($2);}
		type COL from NEXT to
	    ;

type	    :	DET tr_plist		{set_type(TTY_DET);}
	    |   IMM tr_plist		{set_type(TTY_IMM);}
	    |	EXP tr_plist		{set_type(TTY_EXP);}
	    |   BIMOD tr_plist		{set_type(TTY_BIM);}
	    |   NORM tr_plist		{set_type(TTY_NRM);}
	    ;

tr_plist    :
	    |   tr_params
	    ;

tr_params   :	tr_param
	    |	tr_params SEP tr_param
	    ;

tr_param    :	RATE VAL		{chg_rate($2);}
	    |   RATE NAME		{chg_p_rate($2);}
	    |	DEPEND VAL		{chg_depend($2);}
	    ;

from	    :
	    |	from NAME		{add_input($2);}
	    |	from NOT NAME		{add_inhib($3);}
	    ;

to	    :
	    |	to NAME			{add_output($2);}
	    ;


result	    :	RESULT						{ini_result();}
		NAME COL	sum				{add_result($3, $5);}
	    ;

sum	    :			{it_opr = '+';}	 item		{$$ = $2;}
	    |	sum PLUS	{it_opr = '+';}  item		{$$ = concat ($1, $4);}
	    |	sum MINUS	{it_opr = '-';}  item		{$$ = concat ($1, $4);}
	    ;

item	    :	opt_val PROB OP_BR logic_cond CL_BR		{$$ = do_prob ($1, $4);}
	    |   opt_val EXP OP_BR marking CL_BR			{$$ = do_exp  ($1, $4);}
	    |   opt_val EXP OP_BR marking COND logic_cond CL_BR	{$$ = do_cexp ($1, $4, $6);}
	    |   opt_val DWT OP_BR NAME CL_BR			{$$ = do_dwell  ($1, $4);}
	    |   opt_val FIRE OP_BR NAME CL_BR			{$$ = do_fire  ($1, $4);}
	    ;

opt_val	    :							{$$ = get_val(1.0);}
	    |   VAL						{$$ = get_val($1);}
	    |   NAME						{$$ = get_para($1);}
	    ;

marking	    :   HASH NAME					{$$ = get_place ($2);}
	    ;

logic_cond  :	compare
	    |   NOT logic_cond					{$$ = c_negate ($2);}
	    |   OP_PAR logic_cond CL_PAR			{$$ = do_paren ($2);}
	    |   logic_cond AND logic_cond			{$$ = do_and ($1, $3);}
	    |   logic_cond OR logic_cond			{$$ = do_or ($1, $3);}
	    ;

compare	    :   marking REL_OP VAL				{$$ = do_cmp ($1, $2, $3);}
	    ;

%%

#include "gs_pp_lex.c"
#include "gs_pp.c"
