/*
 *
 * Global variables for gr
 *
 * $Id: globals.h,v 1.18 90/05/02 21:21:07 pturner Exp Locker: pturner $
 */

#ifdef MAIN

char version[] = "Grtool version 1.04 Beta - PJ Turner OGI-ESE";

int maxplot = MAXPLOT;
int maxarr = MAXARR;

double *ax, *bx, *cx, *dx;	/* scratch arrays used in scanner */

double xg1 = 0.0, xg2 = 1.0, yg1 = 0.0, yg2 = 1.0;	/* world coordinates */
double xv1 = 0.2, xv2 = 0.9, yv1 = 0.2, yv2 = 0.9;	/* viewpoint coordinates */
double xt1 = 1.0, xt2 = 0.5, yt1 = 1.0, yt2 = 0.5;	/* xmajor, xminor,
							 * ymajor, yminor tic
							 * marks */
char xlabel[128];		/* x-axis label */
char ylabel[128];		/* y-axis label */
char title[128];		/* graph title */
char stitle[128];		/* graph subtitle */

int hardcopyflag = FALSE;	/* TRUE if printing out a hardcopy */

int inplotter = FALSE;		/* TRUE if plotting the current graph */

int boxflag = TRUE;		/* boxflag=TRUE => closed box, =FALSE => half
				 * open */
int boxon = TRUE;		/* toggle box on or off */
int boxcol = 1;			/* box color */
int boxlin = 1;			/* box line style */

int xform;			/* format for x-axis labels */
int yform;			/* format for y-axis labels */

int xticnum = 6;		/* default number of X-axis ticks */
int yticnum = 6;		/* default number of Y-axis ticks */

int xticsintflag = FALSE;	/* major tic marks on integer divisions */
int yticsintflag = FALSE;	/* not used in grtool */

int xticflag = TRUE;		/* toggle ticmark display */
int yticflag = TRUE;

int fformx = TRUE;		/* decimal or exponential ticmark labels .. */
int fformy = TRUE;		/* default to decimal */

int xticlflag = TRUE;		/* toggle ticmark labels on or off */
int yticlflag = TRUE;

int xgridflag = FALSE;		/* toggle ticmarks as grid lines */
int ygridflag = FALSE;
int xgcol = 1, xglin = 1;	/* grid colors and linestyles */
int ygcol = 1, yglin = 1;
double xticsize = 1.0, yticsize = 1.0;	/* length of tickmarks */

int xticslog = FALSE;		/* logarithmic ticmarks */
int yticslog = FALSE;
int logtransflag = FALSE;	/* TRUE if all data has been logarithmized */
int dologtransform = FALSE;	/* TRUE if all data is to transformed */

int xticinoutflag = FALSE;	/* tics inward by default */
int yticinoutflag = FALSE;

int xabsflag = FALSE;		/* tic labels absolute value */
int yabsflag = FALSE;

int xticopflag = TRUE;		/* tics on opposite side */
int yticopflag = TRUE;
int xtopflag = FALSE;		/* x tic labels on top */
int ytopflag = FALSE;		/* y tic labels on right */
int xticangle = 0;		/* angle to draw x-axis tics */
int yticangle = 0;		/* angle to draw x-axis tics */
int xticlskip = 0;		/* tic labels to skip */
int yticlskip = 0;		/* tic labels to skip */

int xzflag = TRUE;		/* toggle the lines x=0 or y=0 */
int yzflag = TRUE;
int xztflag = FALSE;		/* toggle ticmarks for the lines x=0, y=0 */
int yztflag = FALSE;

int defline = 1;		/* default linestyle */
double defchar = 1.0;		/* default character size */
double defsymsize = 1.0;	/* default symbol size */
int defcolor = 1;		/* default color */

/* default location types, 0 -> world coordinates
			   1 -> viewport coordinates
*/
int defstrloc = 1;		/* default string location type */
int deflineloc = 1;		/* default line location type */
int defboxloc = 1;		/* default box location type */
int curfont = 2;		/* default font */

int legendflag = FALSE;		/* flag for legend */
int legloctype = 1;		/* world or viewport location (default is
				 * viewport coordinates) */
int lgap = 2, llen = 6;		/* gap between legned entries and length of
				 * legend line */
double legx = 0.6, legy = 0.7;	/* legend location */

double errbarper = 1.0;		/* length of error bar */

int showdefault = TRUE;		/* display the default graph */
int labeldefault = FALSE;	/* label the default graph */

char plfile[80];		/* load paramaters file name */
char fname[80];			/* last data file read */

int device;			/* graphics device */
int tdevice = TDEV;		/* default devices */
int hdevice = HDEV;

int erronread = FALSE;		/* in startup code was there an error on
				 * reading a data file, assume not  */
char progname[80];		/* our name */

int gflag = FALSE;		/* hacks for generic graphics drivers */
char gfile[80];			/* used if gflag set to true on command line */
char resfile[80];		/* results to file resfile */

int inwin = FALSE;		/* true if running sunview */

char buf[1024];			/* a string used here and there */

char *curprint;			/* the default printer */

#endif

#ifndef MAIN

extern char *open_err_msg;

extern int inwin;	/* true if running sunview */
extern int ispipe;	/* true if reading from stdin */

extern int maxarr, maxplot;
extern double xg1, xg2, yg1, yg2;	/* world coordinates */
extern double xv1, xv2, yv1, yv2;	/* viewpoint coordinates */
extern double xt1, xt2, yt1, yt2;

extern char xlabel[];
extern char ylabel[];
extern char title[];
extern char stitle[];

extern char plfile[], psfile[];
extern char resfile[];

extern int xform, yform, device, tdevice, hdevice;
extern int hardcopyflag;

extern int inplotter;

extern int xticsintflag;
extern int yticsintflag;
extern int boxflag;
extern int boxon;
extern int boxcol;
extern int boxlin;
extern int xticflag;
extern int yticflag;
extern int fformx;
extern int fformy;
extern int xticlflag;
extern int yticlflag;
extern int xticnum;
extern int yticnum;
extern int xgridflag;
extern int xgcol, xglin;
extern int ygridflag;		/* tics grid */
extern int ygcol, yglin;
extern int xticslog;
extern int yticslog;
extern int logtransflag;
extern int xticinoutflag;
extern int yticinoutflag;
extern int xticopflag;
extern int yticopflag;
extern int xtopflag;
extern int ytopflag;
extern int xticangle;
extern int yticangle;
extern int xticlskip;
extern int yticlskip;
extern int xabsflag;
extern int yabsflag;
extern double xticsize, yticsize;

extern int xzflag;
extern int yzflag;
extern int xztflag;
extern int yztflag;

extern int defline;
extern double defchar;
extern double defsymsize;
extern int defcolor;
extern int curfont;

extern int showdefault;
extern int labeldefault;

extern int legendflag;
extern int legloctype;
extern int lgap,llen;
extern double legx, legy;

extern double errbarper;

extern char fname[];
extern int nsets;
extern char buf[];

extern char *curprint;

#endif
