/*
 * File: cycle.m256.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       September 1989
 *
 * A rule based on A.K. Dewdney's "Computer Recreations" article
 * in the August 1989 scientific american
 *
 * "parm1" says how many states to use.
 * Start with a random configuration of cells with values between
 * 0 and parm-1.  For example, with 16 states, start with a random
 * array of values between 0 and 15 inclusive (use the "general"
 * random array generator to do this).
 *
 * Observe the effects of varying parm1 slightly.
 */

#include "nborhood.h"

byte cycle();

void
init_function()
{
    update_function = cycle;
    parm1 = 16;
}

byte
cycle(nbors)
moore_nbors *nbors;
{
    int tmp;

    Get_moore_nbors;
    tmp = (c + 1) % parm1;
    if ((tmp == tl) || (tmp == l) || (tmp == bl) || (tmp == t) ||
	(tmp == b) || (tmp == tr) || (tmp == r) || (tmp == br))
	return tmp;
    else
	return c;
}
