
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	waitc.h
 *
 *	Wait context descriptors.
 *
$Log$
 */


/* Wait context info */

struct waitc {
	struct waitc *wa_link;		/* list of all, ordered by wid */
	struct waitc *wa_rlink;
	int wa_wid;					/* unique identifier, >0 */
	int wa_kind;				/* why waiting */
	int wa_on;					/* entity waiting on */
	int wa_tid;					/* entity waiting */
	int wa_dep;					/* remote wait id that depends on us or 0 */
	struct waitc *wa_peer;		/* dll of peers, not sorted */
	struct waitc *wa_rpeer;
/* wait kind-specific stuff below */
	struct mesg *wa_mesg;		/* message being built */
	void *wa_spec;				/* for kind-specific data */
};

/* Wait kinds */

#define	WT_ADDHOST		1	/* hosts being added for us */
#define	WT_SPAWN		2	/* tasks being spawned for us */
#define	WT_HOSTSTART	3	/* pvmd' starting slaves for us */
#define	WT_TASK			4	/* getting task list from other pvmds */
#define	WT_DELHOST		5	/* hosts being deleted for us */
#define	WT_HTUPD		6	/* host table update waiting to commit */
#define	WT_PSTAT		7	/* query status of task */
#define	WT_TASKX		8	/* waiting for task to exit */
#define	WT_MSTAT		9	/* query status of host */
#define	WT_DB			10	/* name-server query */
#define	WT_HOSTF		11	/* waiting for host to fail */

void wait_init __ProtoGlarp__(( void ));
struct waitc *wait_new __ProtoGlarp__(( int kind ));
struct waitc *wait_find __ProtoGlarp__(( int wid ));
void wait_delete __ProtoGlarp__(( struct waitc *wp ));
void wait_dump __ProtoGlarp__(( struct waitc *wp ));
void wait_dumpall __ProtoGlarp__(( void ));

struct waitc_spawn {
	char *w_file;				/* executable name */
	int w_flags;				/* spawn flags */
	int w_argc;					/* length of argv */
	char **w_argv;				/* arg list */
	struct htab *w_ht;			/* set of usable hosts */
	int *w_vec;					/* result/status vector */
	int w_veclen;				/* length of wa_tids */
	int w_togo;					/* num of unresolved in vec */
};

