
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmumbuf.h
 *
 *	Libpvm message descriptors.
 *
$Log$
 */

/* vector of pack/unpack routines for an encoding */

struct encvec {
	int (*enc_init)();	/* initialize write */
	int (*dec_init)();	/* initialize read */
	int (*enc_byte)();	/* encode bytes */
	int (*dec_byte)();	/* decode bytes */
	int (*enc_short)();	/* encode shorts */
	int (*dec_short)();	/* ... */
	int (*enc_int)();
	int (*dec_int)();
	int (*enc_long)();
	int (*dec_long)();
	int (*enc_float)();
	int (*dec_float)();
	int (*enc_double)();
	int (*dec_double)();
	int (*enc_cplx)();
	int (*dec_cplx)();
	int (*enc_dcplx)();
	int (*dec_dcplx)();
};

/* all context associated with message */

struct umbuf {
	struct umbuf *ub_link;		/* chain or 0 */
	struct umbuf *ub_rlink;
	int ub_mid;					/* message id */
	int ub_len;					/* total length */
	int ub_cod;					/* type code */
	int ub_src;					/* src tid */
	int ub_dst;					/* dst tid */
	int ub_enc;					/* data encoding */
	int ub_flag;
	struct encvec *ub_codef;	/* data encoders/decoders */
	struct frag *ub_frag;		/* master frag or 0 if we're master mesg */
	struct frag *ub_cfrag;		/* unpack position */
	int ub_cpos;				/* unpack position */
	XDR ub_encxdr;
	XDR ub_decxdr;
};

#define	UB_PACK		1	/* initialized for packing */
#define	UB_UPACK	2	/* initialized for unpacking */

/* message heap element */

struct mhp {
	int m_free;					/* free list (next or 0) */
	struct umbuf *m_umb;		/* message or null if on free list */
};

int umbuf_new __ProtoGlarp__((void));
int umbuf_free __ProtoGlarp__((int mid));
struct umbuf *midtobuf __ProtoGlarp__((int mid));

