
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	archcode.c
 *
 *	Architecture classification.
 *
$Log$
 */

#include "protoglarp.h"
#include "pvmalloc.h"
#ifdef	SYSVSTR
#include <string.h>
#else
#include <strings.h>
#endif

#ifndef	max
#define	max(a,b)	((a)>(b)?(a):(b))
#endif

struct archtypes {
	char *archname;
	int archnum;
};

struct nl {
	char *nl_name;
	int nl_num;
	struct nl *nl_next;
};

static char rcsid[] = "$Id$";
static char pvmtxt[512];				/* scratch for error log */
static struct nl *morearches = 0;
static int lastarch = 0;

/*	This array groups machine types by data-representation compatibility
*	i.e.  machines that are integer, floating-point binary compatible
*	should be in the same class number.
*
*	The numbers are also used in process-process messages to identify
*	the data encoding used.  Stay away from 0 and 1, using for XDR
*	and foo.
*/

static struct archtypes arches[] = {
	{"", 10},

	{"AFX8", 11}, {"BFLY", 11}, {"CNVX", 11}, {"CM2", 11}, {"CM5", 11},
	{"CRAYSMP", 11}, {"DGAV", 11}, {"HP300", 11}, {"HPPA", 11},
	{"NEXT", 11}, {"RS6K", 11}, {"RT", 11}, {"SGI", 11}, {"SUN3", 11},
	{"SUN4", 11}, {"TITN", 11},

	{"BSD386", 12}, {"IPSC2", 12}, {"PMAX", 12}, {"SYMM", 12},

	{"I860", 13}, {"PGON", 13},

	{"BAL", 14},
	{"CNVXN", 15},
	{"CRAY", 16},
	{"KSR1", 17},
	{"UVAX", 18},
	{"VCM2", 19},
	{"ALPHA", 20},
	{"", 0}
};

/*	getarchcode()
*
*	Look up the integer code for a architecture string.  Make up
*	one if necessary and cache it.
*/

int
getarchcode(arch)
	char *arch;
{
	int i;
	struct nl *nlp;

	for (i = 0; arches[i].archnum; i++)
		if (!strcmp(arch, arches[i].archname))
			return arches[i].archnum;

	for (nlp = morearches; nlp; nlp = nlp->nl_next)
		if (!strcmp(arch, nlp->nl_name))
			return nlp->nl_num;

	if (!morearches)
		for (i = 0; arches[i].archnum; i++)
			lastarch = max(lastarch, arches[i].archnum);

	sprintf(pvmtxt, "getarchcode: Warning - unknown arch %s\n", arch);
	pvmlogerror(pvmtxt);
	if (nlp = TALLOC(1, struct nl, "nl")) {
		nlp->nl_name = STRALLOC(arch);
		nlp->nl_num = ++lastarch;
		nlp->nl_next = morearches;
		morearches = nlp;
		return nlp->nl_num;
	} else {
		pvmlogerror("getarchcode: can't malloc\n");
		return -1;
	}
}

