
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	tdpro.h
 *
 *	Task-pvmd protocol
 *
$Log$
 */


/* protocol version */

#ifndef	TDPROTOCOL
#define	TDPROTOCOL	1310
#endif

/* message/frag hdr sizes */

#define	TDFRAGHDR	16
#define	TTMSGHDR	8
#define	MAXHDR		((DDFRAGHDR>TDFRAGHDR?DDFRAGHDR:TDFRAGHDR) \
					+(DDMSGHDR>TTMSGHDR?DDMSGHDR:TTMSGHDR))

#define	TDSOCKNAME	"/tmp/pvmd.%d"	/* file with task->pvmd sockaddr */
#if 0
#define	DTSOCKNAME	"/tmp/pvmt.%d"	/* socket pvmd->task */
#endif

#define	TM_CONNECT	1		/* task connects */
#define	TM_CONN2	2		/* 2nd round of connect */
#define	TM_EXIT		3		/* task disconnects */
#define	TM_ADDHOST	4		/* add hosts to machine */
#define	TM_DELHOST	5		/* delete hosts from machine */
#define	TM_CONFIG	6		/* get machine config */
#define	TM_MSTAT	7		/* get host status */
#define	TM_HALT		8		/* halt machine */
#define	TM_TICKLE	9		/* tickle pvmd */
#define	TM_SPAWN	10		/* spawn new tasks */
#define	TM_PSTAT	11		/* get task status */
#define	TM_SENDSIG	12		/* signal a task */
#define	TM_TASK		13		/* list tasks */
#define	TM_MCA		14		/* request multicast tid */
#define	TM_NOTIFY	15		/* request notification */
#define	TM_DB		16		/* name-server request */

#ifdef IMA_I860
#define TM_SPAWNACK 17      /* receive tids of newly spawned node tasks */
#endif

#define	TMDB_INSERT	1
#define	TMDB_DELETE	2
#define	TMDB_LOOKUP	3

