#include "xhist.h"

/* Global Variables */

Widget toplevel,form,scrollform,quit,info,resetmin,resetmax,
       minscroll,maxscroll,binscroll,
       minlabel,mincount,maxlabel,maxcount,binlabel,bincount,hair,haircount,
       viewport,canvas;
Widget samplelabel,samplesize;
Widget proclabel,*proclistlabel;

Colormap cmap;
Window win;
Display *dpy;
int screen;
GC gc,gcxor;
long foreground,background;
int have_color,frame_depth;
int curr_height,curr_width;

double data[MAXINPUTS];
double x[MAXPOINTS],y[MAXINPUTS],sx[MAXPOINTS],sy[MAXINPUTS];
int numpoints;
char color[50];
int count[MAXBINS];
double max,min;
double rangemax,rangemin;
double hairpos;
int bins;
int maxcounts;
int numvalues;
double range;
double left;
int all,num_proc,*proclist; 
int num_proclistwid;
char *procliststr;

struct str {
    char list[40];
};

struct {
    int x_start,
        y_start,
        x_last,
        y_last;
} rbdata;

Dimension display_height,display_width;
char buf[20];

main(argc,argv)
int argc;
char *argv[];
{

    InputData(argc,argv);
    InitGraphics(argc,argv);
    XtMainLoop();
    
}  /* End of Main Function */

void InitGraphics(argc,argv)
int argc;
char *argv[];
{
    Arg args[10];
    int i,j,n;
    XSetWindowAttributes w_attr;
    XGCValues values;
    char temp[8];
    struct str *procstr;

    /* Initialize some values */
    
    min = rangemin = data[0];
    max = rangemax = data[numvalues - 1];
    left = data[0];
    range = data[numvalues-1] - data[0];
    maxcounts = 0;
    bins = 25;
    hairpos = min;
    curr_height = CANVAS_SIZE;
    curr_width = CANVAS_SIZE;

    /* the top level for this program */
    
    toplevel = XtInitialize(argv[0],"Xhist",NULL,0,&argc,argv);

    dpy = XtDisplay(toplevel);
    screen = DefaultScreen(dpy);
    cmap = DefaultColormap(dpy,screen);

    frame_depth = XDefaultDepth(dpy,screen);

    have_color = (frame_depth > 1 ? 1 : 0);

    /* set up colors */
    
    if (have_color)
    {
	foreground = ConvertColor(canvas,"red");
	background = ConvertColor(canvas,"LightGray");
    }
    else
    {
	foreground = ConvertColor(canvas,"black");
	background = ConvertColor(canvas,"white");
    }

    /* the containg form */
    
    form = XtCreateManagedWidget("form",formWidgetClass,toplevel,NULL,0);

    /* the form to hold the scrollbars */
    
    scrollform = XtCreateManagedWidget("scrollform",formWidgetClass,
				       form,NULL,0);

    /* the label for the minimum scrollbar */
    
    n = 0;
    XtSetArg(args[n],XtNlabel,"Min");n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,40);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    minlabel = XtCreateManagedWidget("minlabel",labelWidgetClass,
				     scrollform,args,n);

    /* the minimum scrollbar */
    
    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,minlabel);n++;
    XtSetArg(args[n],XtNorientation,XtorientHorizontal);n++;
    XtSetArg(args[n],XtNlength,200);n++;
    XtSetArg(args[n],XtNthickness,15);n++;
    minscroll = XtCreateManagedWidget("minscroll",scrollbarWidgetClass,
				      scrollform,args,n);
    XtAddCallback(minscroll,XtNjumpProc,MinJump,NULL);

    XawScrollbarSetThumb(minscroll,0.0,0.01);

    /* the counter for the minimum scrollbar */
    
    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,minscroll);n++;
    sprintf(buf,"%8.2lf",min);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,100);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    mincount = XtCreateManagedWidget("mincount",labelWidgetClass,
				     scrollform,args,n);

    /* the label for the maximum scrollbar */

    n = 0;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,minlabel);n++; 
    XtSetArg(args[n],XtNlabel,"Max");n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,40);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    maxlabel = XtCreateManagedWidget("maxlabel",labelWidgetClass,
				     scrollform,args,n);    

    /* the maximum scrollbar */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,maxlabel);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,minscroll);n++; 
    XtSetArg(args[n],XtNorientation,XtorientHorizontal);n++;
    XtSetArg(args[n],XtNlength,200);n++;
    XtSetArg(args[n],XtNthickness,15);n++;
    maxscroll = XtCreateManagedWidget("maxscroll",scrollbarWidgetClass,
				      scrollform,args,n);
    XtAddCallback(maxscroll,XtNjumpProc,MaxJump,NULL);

    XawScrollbarSetThumb(maxscroll,1.0,0.01);

    /* the counter for the maximum scrollbar */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,maxscroll);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,mincount);n++; 
    sprintf(buf,"%8.2lf",max);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,100);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    maxcount = XtCreateManagedWidget("maxcount",labelWidgetClass,
				     scrollform,args,n);

    /* the label for the bin scrollbar */

    n = 0;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,maxlabel);n++; 
    XtSetArg(args[n],XtNlabel,"Bins");n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,40);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    binlabel = XtCreateManagedWidget("binlabel",labelWidgetClass,
				     scrollform,args,n);

    /* the bin scrollbar */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,binlabel);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,maxscroll);n++; 
    XtSetArg(args[n],XtNorientation,XtorientHorizontal);n++;
    XtSetArg(args[n],XtNlength,200);n++;
    XtSetArg(args[n],XtNthickness,15);n++;
    binscroll = XtCreateManagedWidget("binscroll",scrollbarWidgetClass,
				      scrollform,args,n);
    XtAddCallback(binscroll,XtNjumpProc,BinJump,NULL);

    XawScrollbarSetThumb(binscroll,25.0/(float) MAXBINS,0.01);

    /* the counter for the bin scrollbar */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,binscroll);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,maxcount);n++; 
    sprintf(buf,"%4d",bins);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,100);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    bincount = XtCreateManagedWidget("bincount",labelWidgetClass,
				     scrollform,args,n);

    /* the viewport */

    n = 0;
    XtSetArg(args[n],XtNfromVert,scrollform);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    /*XtSetArg(args[n],XtNallowHoriz,False); n++;
    XtSetArg(args[n],XtNallowVert,False); n++;*/
    viewport = XtCreateManagedWidget("viewport",viewportWidgetClass,
                                      form,args,n);

    /* the canvas */

    n = 0;
    XtSetArg(args[n],XtNheight,CANVAS_SIZE); n++;
    XtSetArg(args[n],XtNwidth,CANVAS_SIZE+1); n++;
    XtSetArg(args[n],XtNborderWidth,0); n++;
    XtSetArg(args[n],XtNforeground,foreground); n++;
    XtSetArg(args[n],XtNbackground,background); n++;
    canvas = XtCreateManagedWidget("canvas",compositeWidgetClass,
                                    viewport,args,n);

    /* the sample label */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10); n++;
    XtSetArg(args[n],XtNfromHoriz,viewport); n++;
    XtSetArg(args[n],XtNvertDistance,20); n++;
    XtSetArg(args[n],XtNfromVert,scrollform); n++;
    XtSetArg(args[n],XtNborderWidth,0); n++;
    XtSetArg(args[n],XtNlabel,"Sample  "); n++;
    samplelabel = XtCreateManagedWidget("samplelabel",labelWidgetClass,
				form,args,n);

    /* the sample size */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,5); n++;
    XtSetArg(args[n],XtNfromHoriz,samplelabel); n++;
    XtSetArg(args[n],XtNvertDistance,20); n++;
    XtSetArg(args[n],XtNfromVert,scrollform); n++;
    sprintf(buf,"%d",numvalues);
    XtSetArg(args[n],XtNlabel,buf); n++;
    XtSetArg(args[n],XtNheight,15); n++;
    XtSetArg(args[n],XtNwidth,50); n++;
    XtSetArg(args[n],XtNborderWidth,0); n++;
    samplesize = XtCreateManagedWidget("samplesize",labelWidgetClass,
				form,args,n);

    /* the hair label */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,viewport);n++;
    XtSetArg(args[n],XtNvertDistance,50);n++;
    XtSetArg(args[n],XtNfromVert,scrollform);n++;
    XtSetArg(args[n],XtNborderWidth,0); n++;
    XtSetArg(args[n],XtNlabel,"Hair");n++;
    hair = XtCreateManagedWidget("hair",labelWidgetClass,
				 form,args,n);

    /* the counter for the crosshair */
    
    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,hair);n++;
    XtSetArg(args[n],XtNvertDistance,50);n++;
    XtSetArg(args[n],XtNfromVert,scrollform);n++;
    sprintf(buf,"%8.2lf",hairpos);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,100);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    haircount = XtCreateManagedWidget("haircount",labelWidgetClass,
				      form,args,n);

    /* the reset min button */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,viewport);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,hair);n++;
    resetmin = XtCreateManagedWidget("resetmin",commandWidgetClass,
				     form,args,n);
    XtAddCallback(resetmin,XtNcallback,Resetmin,0);

    /* the reset max button */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,viewport);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,resetmin);n++;
    resetmax = XtCreateManagedWidget("resetmax",commandWidgetClass,
				     form,args,n);
    XtAddCallback(resetmax,XtNcallback,Resetmax,0);

    /* the information button */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,viewport);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,resetmax);n++;
    info = XtCreateManagedWidget("info",commandWidgetClass,
				 form,args,n);
    XtAddCallback(info,XtNcallback,Info,0);

    /* the quit button */
    
    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,viewport);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,info);n++;
    quit = XtCreateManagedWidget("quit",commandWidgetClass,
				 form,args,n);
    XtAddCallback(quit,XtNcallback,Quit,0);

    /* process list label */

    n = 0;
    XtSetArg(args[n],XtNvertDistance,10); n++;
    XtSetArg(args[n],XtNfromVert,viewport); n++;
    XtSetArg(args[n],XtNheight,20); n++;
    XtSetArg(args[n],XtNborderWidth,0); n++;
    proclabel = XtCreateManagedWidget("Processes:",
			labelWidgetClass,form,args,n);

    /* process list */

    if(all){
	n = 0;
	XtSetArg(args[n],XtNvertDistance,10); n++;
    	XtSetArg(args[n],XtNfromVert,viewport); n++;
    	XtSetArg(args[n],XtNhorizDistance,100); n++;
    	XtSetArg(args[n],XtNheight,20); n++;
    	XtSetArg(args[n],XtNborderWidth,0); n++;
	proclistlabel = (Widget *)malloc(sizeof(Widget));
	*proclistlabel = XtCreateManagedWidget("all",
			labelWidgetClass,form,args,n);
	}
    else{
    	num_proclistwid = num_proc/10;
    	if((num_proc%10)>0)
	    ++num_proclistwid;
    	proclistlabel = (Widget *)calloc(num_proclistwid,sizeof(Widget));
    	procstr = (struct str *)calloc(num_proclistwid,sizeof(struct str));

    	for(i=0;i<num_proclistwid;++i)
	    strcpy(procstr[i].list,"");	/* initialize */

    	for(i=0,j=0;(i<num_proclistwid)&&(j<num_proc);){
	    sprintf(temp,"%d ",proclist[j]);
	    strcat(procstr[i].list,temp);
	    ++j;
	    if((j%10)==0)
	    	++i;
	    }

    	for(i=0;i<num_proclistwid;++i){
    	    n = 0;
    	    XtSetArg(args[n],XtNvertDistance,10); n++;
     	    if(i<1){
    		XtSetArg(args[n],XtNfromVert,viewport); n++;
		}
    	    else{
    		XtSetArg(args[n],XtNfromVert,proclistlabel[i-1]); n++;
		}
    	    XtSetArg(args[n],XtNhorizDistance,100); n++;
    	    XtSetArg(args[n],XtNheight,20); n++;
    	    XtSetArg(args[n],XtNborderWidth,0); n++;
    	    proclistlabel[i] = XtCreateManagedWidget(procstr[i].list,
			labelWidgetClass,form,args,n);
    	    }
    }

    XtRealizeWidget(toplevel);

    XtAddEventHandler(canvas,ButtonPressMask,FALSE,start_rubber_band,&rbdata);
    XtAddEventHandler(canvas,ButtonMotionMask,FALSE,track_rubber_band,&rbdata);
    XtAddEventHandler(canvas,ButtonReleaseMask,FALSE,end_rubber_band,&rbdata);
    XtAddEventHandler(canvas,StructureNotifyMask,FALSE,resize_jobs,NULL);

    win = XtWindow(canvas);
    dpy = XtDisplay(canvas);

    XGrabButton(dpy,AnyButton,AnyModifier,win, TRUE,
		ButtonPressMask | ButtonMotionMask | ButtonReleaseMask, 
		GrabModeAsync,GrabModeAsync,win,
                XCreateFontCursor(dpy,XC_sb_up_arrow));

    /* set up graphics context */

    gc = XCreateGC(dpy,win,NULL,NULL);

    /* set up Xor graphics context for drawing the hair */
    
    n = 0;
    XtSetArg(args[n],XtNforeground,&values.foreground);n++;
    XtSetArg(args[n],XtNbackground,&values.background);n++;
    XtGetValues(canvas,args,n);

    values.foreground = values.foreground ^ values.background;
    values.function = GXxor;

    gcxor = XtGetGC(canvas,GCForeground | GCBackground | GCFunction,&values);

    /* Additions so that the picture is saved when the window is changed */

    w_attr.backing_store = Always;   /* retain window contents */
    w_attr.save_under = True;	 /* save invisible part of canvas */

    XChangeWindowAttributes(dpy,win,(CWBackingStore | CWSaveUnder),&w_attr);
    
    Redraw();

}  /* End of Function InitGraphics */


void Quit(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    
    exit(0);
    
}  /* End of Function Quit */

void resize_jobs(w,data,event,continue_to_dispatch)
Widget w;
caddr_t data;
XEvent *event;
Boolean *continue_to_dispatch;
{
    int newwidth,newheight;

    *continue_to_dispatch = True;

    Redraw();

    newwidth = event->xconfigure.width;
    newheight = event->xconfigure.height;

    curr_height = newheight;
    curr_width = newwidth-1;

}  /* End of Function Resize_Jobs */

void start_rubber_band(w, data, event)
Widget w;
caddr_t data;
XEvent *event;
{
    Arg args[5];
    int n;

    rbdata.x_last = rbdata.x_start = event->xbutton.x;
    rbdata.y_last = rbdata.y_start = event->xbutton.y;

    hairpos = ((double) rbdata.x_last/(double) curr_width)*(max-min) + min;

    n = 0;
    sprintf(buf,"%6.2lf",hairpos);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(haircount,args,n);

    XDrawLine(dpy,win,gcxor,rbdata.x_start,0,rbdata.x_start,curr_height);

}  /* End of Function Start_Rubber_Band */


void track_rubber_band(w, data, event)
Widget w;
caddr_t data;
XEvent *event;
{
    Arg args[5];
    int n;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,curr_height);

    rbdata.x_last = event->xbutton.x;
    rbdata.y_last = event->xbutton.y;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,curr_height);

    n = 0;
    hairpos = ((double) rbdata.x_last/(double) curr_width)*(max-min) + min;
    sprintf(buf,"%6.2lf",hairpos);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(haircount,args,n);

}  /* End of Function Track_Rubber_Band */


void end_rubber_band(w, data, event)
Widget w;
caddr_t data;
XEvent *event;
{
    Arg args[5];
    int n;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,curr_height);

    rbdata.x_last = event->xbutton.x;
    rbdata.y_last = event->xbutton.y;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,curr_height);

    /* pause */

    for(n=0;n<1000;n++)
	;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,curr_height);

    n = 0;
    hairpos = ((double) rbdata.x_last/(double) curr_width)*(max-min) + min;
    sprintf(buf,"%6.2lf",hairpos);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(haircount,args,n);

}  /* End of Function End_Rubber_Band */

void Resetmin(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    Arg args[2];
    int n;
    char *temp;

    n = 0;
    XtSetArg(args[n],XtNlabel,&temp);n++;
    XtGetValues(mincount,args,n);

    rangemin = atof(temp);

    range = rangemax - rangemin;
    left = rangemin;

    XawScrollbarSetThumb(minscroll,0.0,-1.0);

    Redraw();

}  /* End of Function Resetmin */

void Resetmax(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    Arg args[2];
    int n;
    char *temp;

    n = 0;
    XtSetArg(args[n],XtNlabel,&temp);n++;
    XtGetValues(maxcount,args,n);

    rangemax = atof(temp);

    range = rangemax - rangemin;

    XawScrollbarSetThumb(maxscroll,1.0,-1.0);

    Redraw();

}  /* End of Function Resetmax */

void Info(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    
    printf("max = %lf, min = %lf, bins = %d\n",max,min,bins);
    
}  /* End of Function Info */

/* Function MinJump

   This function is a minjump callback routine.  It is called when
   NotifyThumb is sensed on the minjump Widget. */

void MinJump(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{

    float pct = *((float *) call_data);
    Arg args[1];

    min = left + pct * range;
    
    sprintf(buf,"%6.2lf",min);
    XtSetArg(args[0],XtNlabel,buf);
    XtSetValues(mincount,args,1);
    
    Redraw();
    
}  /* End of Function MinJump */

/* Function MaxJump

   This function is a maxjump callback routine.  It is called when
   NotifyThumb is sensed on the maxjump Widget. */

void MaxJump(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    float pct = *((float *) call_data);
    Arg args[1];

    max = left + pct * range;

    sprintf(buf,"%6.2lf",max);
    XtSetArg(args[0],XtNlabel,buf);
    XtSetValues(maxcount,args,1);

    Redraw();
    
}  /* End of Function MaxJump */

/* Function BinJump

   This function is a binjump callback routine.  It is called when
   NotifyThumb is sensed on the binjump Widget. */

void BinJump(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    float pct_left;
    float range;
    float bin_value;
    Arg args[1];

    pct_left = *((float *) call_data);
    range = MAXBINS - MINBINS;
    bin_value = range * pct_left + MINBINS;

    bins = (int) bin_value;

    sprintf(buf,"%d",bins);
    XtSetArg(args[0],XtNlabel,buf);
    XtSetValues(bincount,args,1);

    Redraw();

}  /* End of Function BinScroll */

void Rebin()
{
    int i,j;
    int count;
    double binsize;
    double binleft;
    int samplecount,n;
    Arg args[10];

    maxcounts = 0;
    numpoints = 2*bins+2;  /* Two for each bin and the two ends */
    binleft = min;
    binsize = (max - min) / bins;

    x[0] = min;   /* Graph the initial zero */
    y[0] = 0;

    j = 0;
    while(data[j] < min)
	j++;  /* Ignore the data points before the minimum */
    
    samplecount = 0;
    for (i = 1 ; i < (numpoints - 1) ; i++){
	count = 0;
	while ((data[j] < (binleft + binsize + 0.000001)) && (j<numvalues)){
	    count++;
	    j++;
	    }
	x[i] = binleft;
	y[i] = count;
	i++;
	binleft = binleft + binsize;
	x[i] = binleft;
	y[i] = count;
	if ( count > maxcounts )
	    maxcounts = count;
	samplecount += count;
        }

    x[numpoints-1] = max;
    y[numpoints-1] = 0;

    n = 0;
    sprintf(buf,"%d",samplecount);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(samplesize,args,n);
    
}  /* End of Function Rebin */

void Scale()
{
    Arg args[5];
    int n;
    int j;

    n = 0;
    XtSetArg(args[n],XtNheight,&display_height); n++;
    XtSetArg(args[n],XtNwidth,&display_width); n++;
    XtGetValues(viewport,args,n);
	     
    for (j=0;j<numpoints;j++){
	sx[j] = ((display_width)/(max-min)) * (x[j] - min);
	sy[j] = display_height - (((display_height * (0.8))/maxcounts) * y[j]);
        }

}  /* End of Function Scale */

void Plot()
{
    XPoint points[MAXPOINTS];
    int k;

    for(k=0;k<numpoints;k++){
	points[k].x = (short) sx[k];
	points[k].y = (short) sy[k];
        }

    if(have_color){
	XSetForeground(dpy,gc,background);
	XFillRectangle(dpy,win,gc,0,0,display_width,display_height);
	XSetForeground(dpy,gc,ConvertColor(canvas,color));
	XFillPolygon(dpy,win,gc,points,numpoints,Nonconvex,CoordModeOrigin);
        }
    else{
	XSetForeground(dpy,gc,background);
	XFillRectangle(dpy,win,gc,0,0,display_width,display_height);
	XSetForeground(dpy,gc,foreground);
	XFillPolygon(dpy,win,gc,points,numpoints,Nonconvex,CoordModeOrigin);
/*
	XDrawLines(dpy,win,gc,points,numpoints,CoordModeOrigin);
*/
        }

}  /* End of Function Plot */

int ConvertColor(w,colorname)
Widget w;
char *colorname;
{
    XColor color,ignore;

    if(XAllocNamedColor(dpy,cmap,colorname,&color,&ignore))
	return (color.pixel);
    else{
	printf("Warning: couldn't allocate color %s\n",colorname);
	return (BlackPixel(dpy, screen));
        }
    
}  /* End of Function ConvertColor */

void Redraw()
{
    Rebin();
    Scale();
    Plot();
}  /* End of Function Redraw */

