#include "xedge.h"

extern struct event *buffer;
extern struct procinfo *proc;
extern int num_procs,num_states;
extern long unsigned num_legal_events;
extern timevar t0,tfinal,total_time;
extern double conv_factor;
extern char units[15];
extern int cellwidth,cellheight,gridsize;
extern struct statetype state[MAXNUMSTATES];

void InputData(argc,argv)
int argc;
char *argv[];
{
    FILE *logfile,*statefile;
    int finished,legal;
    int event_type,process_id,task_id,int_data,clock_cycle;
    timevar timestamp;
    char str_data[MAXSTRLEN],line[100];
    int num_events;
    int i,j,k;
    long end_of_controls;
    double dbl_gridsize;

    if(argc != 3){
	printf("Usage : XEDGE <logfile> <statefile>\n");
	exit(1);
        }

    if((logfile=fopen(argv[1],"r")) == NULL){
	printf("File I/O error.\n");
	exit(1);
        }

    if((statefile=fopen(argv[2],"r")) == NULL){
	printf("File I/O error.\n");
	exit(1);
        }

    num_states = 0;
    
    while( fgets(line,sizeof(line),statefile) != NULL ){

	sscanf(line,"%d %d %d %s %*s",&state[num_states].state_num,
	       &state[num_states].entry,&state[num_states].exit,
	       state[num_states].color);

	if(num_states >= MAXNUMSTATES) break;  /* safety mechanism */

	num_states++;
	
        }

    fclose(statefile);

    finished = 0;

    /* Read the control statements at the top of the log file */

    while((fgets(line,sizeof(line),logfile) != NULL) && (!finished)){
	if(sscanf(line,"%d %d %d %d %d %ul",&event_type,&process_id,&task_id,
		  &int_data,&clock_cycle,&timestamp) == 6)
	    ;
	else if(sscanf(line,"%d %d %d %d %d %ul %s",&event_type,&process_id,
		       &task_id,&int_data,&clock_cycle,&timestamp,
		       str_data) == 7)
	    ;
	else
	    printf("invalid : %s\n",line);

	if(event_type >=0)    /* Have ended the control statements */
	    finished = 1;
	
	switch(event_type){
	    case -2 : num_events = int_data;
	              break;
	    case -3 : num_procs = int_data;
	              break;
	    case -6 : t0 = timestamp;
	              break;
	    case -7 : tfinal = timestamp;
	              break;
	  }  /* end of switch */
	
	if(!finished)
	    end_of_controls = ftell(logfile);

        }  /* End of "while" loop to read the control statements */
	
    total_time = tfinal - t0;

    if( ((double) total_time/(double) num_events) < 1000.0 ){
	conv_factor = 1.0;          /* leave as microseconds */
	strcpy(units,"microseconds");
        }
    else if( ((double) total_time/(double) num_events) < 1000000.0 ){
	conv_factor = 1000.0;       /* change to milliseconds */
	strcpy(units,"milliseconds");
        }
    else if( ((double) total_time/(double) num_events) > 1000000.0 ){
	conv_factor = 1000000.0;    /* change to seconds */
	strcpy(units,"seconds");
        }

    /* allocate just enough space for all of the events */
    
    buffer = (struct event *)malloc(sizeof(struct event)*num_events);

    i = 0;

    /* rewind the file one line so that we catch the first non-control line */

    if(fseek(logfile,end_of_controls,0) != 0){
	printf("File I/O error.\n");
	exit(1);
        }

    /* "while" loop to read in all of the events */

    while( fgets(line,sizeof(line),logfile) != NULL ){
	if(sscanf(line,"%d %d %d %d %d %ul",&event_type,&process_id,&task_id,
		  &int_data,&clock_cycle,&timestamp) == 6)
	    ;
	else if(sscanf(line,"%d %d %d %d %d %ul %s",&event_type,&process_id,
		       &task_id,&int_data,&clock_cycle,&timestamp,
		       str_data) == 7)
	    ;
	else
	    printf("invalid : %s\n",line);

	legal = 0;
	
	for(k=0;k<num_states;k++){
	    if(state[k].entry == event_type){
		buffer[i].status = 1;
		legal = 1;
		break;
	        }
	    else if(state[k].exit == event_type){
		buffer[i].status = 0;
		legal = 1;
		break;
	        }
	    }  /* end of "for" */

	if(legal){
	    buffer[i].event = k + 2;               /* Add 2 since 0,1 are */
                                                   /* black and white */
	    buffer[i].id = process_id;
	    buffer[i].relative_time = timestamp - t0;  /* time since t0 */
	    i++;  /* Increment the number of events by one */
	    }  /* Endif */
	else{
/*	    printf("Excluded event %d\n",event_type);  */
	    }

        }  /* End of "while" loop to read in the events */

    num_legal_events = i;  /* This is the number of events that we are */
                           /* interested in */

    fclose(logfile);

    /* allocate space for the array of structures which holds the current */
    /* info about the processes */
    
    dbl_gridsize = sqrt((double) num_procs);

    gridsize = ceil(dbl_gridsize);

    proc = (struct procinfo *)malloc(sizeof(struct procinfo)*
				     gridsize*gridsize);

    cellwidth = cellheight = CANVAS_SIZE / gridsize;
	
    for(i=0;i<gridsize;i++){         /* the y-coordinate */
	for(j=0;j<gridsize;j++){        /* the x-coordinate */
	    proc[i*gridsize+j].x0 = j*cellwidth;
	    proc[i*gridsize+j].y0 = i*cellheight;
	    proc[i*gridsize+j].x1 = (j+1)*cellwidth - 1;
	    proc[i*gridsize+j].y1 = (i+1)*cellheight - 1;
	    proc[i*gridsize+j].color = 0;
	    }  /* End of inner "for" */

        }   /* End of outer "for" */

/*    for(i=0;i<num_procs;i++){
	printf("x0=%d y0=%d x1=%d y1=%d color=%s\n",proc[i].x0,
	       proc[i].y0,proc[i].x1,proc[i].y1,proc[i].color);
        }  */
    
}  /* End of Function InputData */
