#include <stdio.h>
#include <string.h>
#include <math.h>
#include <signal.h>

#ifdef IS_DEFINITION
#define EXTERN
#else
#define EXTERN extern
#endif

#define X_REL4 1

#ifdef X_REL4
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>   
#include <X11/Shell.h> 
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h> 
#include <X11/Xaw/Command.h>   
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Viewport.h>

/* APPLICATION RESOURCES */
#define XtNlogfile "logfile"
#define XtCLogfile "Logfile"
#define XtNstatefile "statefile"
#define XtCStatefile "Statefile"
#define XtNcanvasHeight "canvasHeight"
#define XtCCanvasHeight "CanvasHeight"
#define XtNhelp "help"
#define XtCHelp "Help"
#define XtNtasks "tasks"
#define XtCTasks "tasks"


#define XtNboxFont "boxFont"
#define XtCBoxFont "BoxFont"

#define XtNbigFont "bigFont"
#define XtCBigFont "BigFont"

#define XtNsmallFont "smallFont"
#define XtCSmallFont "SmallFont"

#define XtNxsmallFont "xsmallFont"
#define XtCXsmallFont "XsmallFont"

#define XtNtitleFont "titleFont"
#define XtCTitleFont "TitleFont"

#define XtNlabelFont "labelFont"
#define XtCLabelFont "LabelFont"

#endif


#define COLOR1  "white"
#define COLOR2 "black"
#define COLOR3  "red"
#define COLOR4  "firebrick"
#define COLOR5  "yellow"
#define COLOR6  "goldenrod2"
#define COLOR7  "green"
#define COLOR8  "OliveDrab"
#define COLOR9  "cyan"
#define COLOR10  "blue"
#define COLOR11  "plum"
#define COLOR12  "purple"
#define COLOR13  "orchid1"
#define COLOR14  "magenta"
#define COLOR15  "aquamarine"
#define COLOR16  "CadetBlue"
#define COLOR17  "SlateGray3"
#define COLOR18  "SlateGray4"
#define COLOR19  "RosyBrown3"
#define COLOR20  "burlywood4"


/** MISCELLANEOUS CONSTANTS -------------------------------------------------*/
#define XOR 1
#define TRUE 1
#define FALSE 0
#define BLACK 0
#define WHITE 1

#define MAX_NUM_CHILDREN 50  /* This is the maximum number of child */
                             /* processes allowed by upshot */


/** DRAWING CONSTANTS -------------------------------------------------------*/
#define STATEKEYWIDTH 80   /* width of the state key in pixels */
#define CANVAS_TOTAL 10    /* number of canvases that make up the pixmap */
#define CANVAS_HEIGHT 480  /* default height of the canvas*/
/*#define CANVAS_WIDTH 490*/ /* pixel width of the canvas and the minimum amount
                              of microseconds allowed on canvas */
#define CANVAS_WIDTH 475
/*#define X_OFFSET 20 */
#define X_OFFSET 5        /* distance between viewport edge and y-axis*/
#define Y_OFFSET 20        /*distance between viewpt edge and top of y-axis*/
#define PADDING 10         /*# of pixels added to pixmapwidth for padding*/
#define MINI_PROCWIDTH 6
#define PGBUTTONS_WIDTH 689/* width of pgButtons box */
#define STBAR_HEIGHT 12
#define EVBOX_WIDTH 12      /* width & height of "square" pixmap used for event
			      boxes*/


/** TIME AND EVENT-RELATED CONSTANTS ----------------------------------------*/
#define PROCESS_MAX 50     /*maximum number of processes*/
#define MAX_STR_LEN 2      /*max no. of digits in string that holds id */ 
#define EVENT_MAX (2000 + PROCESS_MAX) /* maximum number of events in buffer */
#define MAX_EVTYPES 125    /*maximum number of different types of events*/
#define DEFAULT_TIME_ON_CANVAS 600000 /*def. amt. of time displayed on canvas*/
#define CDATALEN 12    /* the max number of chars allowed for c_data */
#define BUFLEN 100     /* the max number of chars allowed for reading c_data */



/** FONTS -------------------------------------------------------------------*/
#define BIG_FONT "-*-*-bold-r-*-*-12-*-*-*-*-*-*-*" 
#define SMALL_FONT "-misc-*-medium-r-semicondensed--13-100-100-100-c-60-iso8859-1"
/*
#define XSMALL_FONT "-*-*-*-*-normal-*-6-60-*-*-*-40-*-*"
*/
#define XSMALL_FONT "-misc-fixed-medium-r-*--8-60-*-*-*-*-*"
#define BOX_FONT "-adobe-helvetica-medium-r-*-*-11-*-*-*-*-*-*-*"
#define LABEL_FONT "-b&h-lucida-bold-r-*-*-14-*-*-*-*-*-*-*"
#define TITLE_FONT "-b&h-lucida-medium-r-*-*-26-*-*-*-*-*-*-*"




/** WIDGET STUFF ------------------------------------------------------------*/
#ifdef X_REL4
EXTERN Pixmap canvas_pixmap; 
EXTERN Pixmap square,smllsquare;                       /*for drawing the event boxes*/
/*for b&w states : */
EXTERN Pixmap horizStripes,verStripes,rightSlant,leftSlant,checkerd, solid;
EXTERN Pixmap rightSlant2,leftSlant2,rightSlant3,leftSlant3;
EXTERN int totalPatterns;

EXTERN Display *display;
EXTERN int screen;
EXTERN GC gc,gcclear;
EXTERN XGCValues gcv;

/* Font stuff, used in loading fonts and specifying gc font.  The actual 
   loading is done using XLoadQueryFont in the x_graphics_init routine */
EXTERN XFontStruct *labelFont,*titleFont,*bigFont,*smallFont,*xsmallFont,*boxFont;
EXTERN Font bigFontId,smallFontId,xsmallFontId,boxFontId;

/* the SHELL widget */
EXTERN Widget toplevel;                    

/* form widgets organize the screen */
EXTERN Widget outline,YaxisLabel,Panelform,Canvasform,PgButtonsform,Buttonform;

EXTERN Widget canvas,miniCanvas,Bscroll,Cscroll;      /* canvas related widgets */
EXTERN Widget title,Units;                            /* labels */
EXTERN Widget EventKey;                               /*text widget used for ev. key*/
EXTERN Widget Zoomstep,Zoomout,Zoomin,Quit;           /* button widgets */
EXTERN Widget Edge;                                   /* another button.  DPN */
EXTERN Widget DisplayMenu,DMenuButton;            /* display definition menu */
EXTERN Widget StateDef,StateDefWindow;            /* State Definition widgets */
EXTERN Widget StateName,StartEv,EndEv,StateColor; /* State Def dialogs */
EXTERN Widget StateKeyWindow,StateKeyform;        /* State Key widgets */
EXTERN Widget StateKeyViewport;                   /* Holds State Key widget */
EXTERN Widget LogFile,StateFile;                  /* dialog-file widgets */
EXTERN Widget Summ;			           /* Summary popup */
EXTERN Widget DataBox;                            /* popup shell used for displaying
					      event data */

EXTERN Widget Procnumform;			   /* contains the proc num buttons */
EXTERN Widget *procbutton;			   /* ptr to the array of process
					      number buttons */

EXTERN Window w,bigwindow;

/* COLOR MAP */
EXTERN Colormap cmap;


/* X-SPECIFIC STRUCTURES */

/* APPLICATION OPTIONS 
   used in defining command line options specific to Upshot */

static XrmOptionDescRec app_options[] = {
/* OPTION            RESOURCE          ARGUMENT STYLE   VAL      */
  {"-l",          "*logfile",          XrmoptionSepArg, NULL},
  {"-logfile",    "*logfile",          XrmoptionSepArg, NULL},
  {"-s",          "*statefile",        XrmoptionSepArg, NULL},
  {"-statefile",  "*statefile",        XrmoptionSepArg, NULL},
  {"-ch",         "*canvasHeight",     XrmoptionSepArg, NULL},
  {"-cheight",    "*canvasHeight",     XrmoptionSepArg, NULL},
  {"-help",       "*help",             XrmoptionNoArg, "True"},
  {"-t",          "*tasks",            XrmoptionNoArg, "True"},
  {"-tasks",      "*tasks",            XrmoptionNoArg, "True"},
};


/* APPLICATION RESOURCES:
   used in retrieving application resources from database */

typedef struct {
  Pixel back;           /* background and foreground colors */
  Pixel fore;
  XFontStruct *font;
  XFontStruct *boxFont;
  XFontStruct *bigFont;
  XFontStruct *labelFont;
  XFontStruct *titleFont;
  XFontStruct *smallFont;
  XFontStruct *xsmallFont;
  char *logfile;        /* logfile name */
  char *statefile;      /* statefile name */
  int canvas_height;    /* height of the canvas in pixels */
  Boolean help;         /*flag indicates whether or not to print help message*/
  Boolean tasks;        /*flag indicates if upshot is to graph tasks, the 
                          default is to graph processes */
} ApplicationData, *ApplicationDataPtr;

static XtResource resources[] = 
{
  { XtNforeground,                        /* resource name */
      XtCForeground,                      /* class name */
      XtRPixel,                           /* data type or resource */
      sizeof(Pixel),                      /* size of data type */
      XtOffset(ApplicationDataPtr, fore), /* place to store converted value */ 
      XtRString,                          /* data type of default value */
      XtDefaultForeground                 /* default value */
      },

   { XtNbackground, 
       XtCBackground, 
       XtRPixel, 
       sizeof(Pixel),
       XtOffset(ApplicationDataPtr, back), 
       XtRString, 
       XtDefaultBackground 
       },

   { XtNfont,
       XtCFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, font),
       XtRString,
       "fixed"
       },

   { XtNboxFont,
       XtCBoxFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, boxFont),
       XtRString,
       BOX_FONT
       },


   { XtNbigFont,
       XtCBigFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, bigFont),
       XtRString,
       BIG_FONT
       },

   { XtNlabelFont,
       XtCLabelFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, labelFont),
       XtRString,
       LABEL_FONT
       },

   { XtNsmallFont,
       XtCSmallFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, smallFont),
       XtRString,
       SMALL_FONT
       },

   { XtNxsmallFont,
       XtCXsmallFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, xsmallFont),
       XtRString,
       XSMALL_FONT
       },

   { XtNtitleFont,
       XtCTitleFont,
       XtRFontStruct,
       sizeof(XFontStruct * ),
       XtOffset(ApplicationDataPtr, titleFont),
       XtRString,
       TITLE_FONT
       },


   { XtNlogfile,
       XtCLogfile,
       XtRString,
       sizeof(String),
       XtOffset(ApplicationDataPtr, logfile),
       XtRString,
       (caddr_t) NULL,
       },

   { XtNstatefile,
       XtCStatefile,
       XtRString,
       sizeof(String),
       XtOffset(ApplicationDataPtr, statefile),
       XtRString,
       (caddr_t) "",
       },

   { XtNcanvasHeight,
       XtCCanvasHeight,
       XtRInt,
       sizeof(int),
       XtOffset(ApplicationDataPtr, canvas_height),
       XtRImmediate,
       (caddr_t) CANVAS_HEIGHT,
       },

   { XtNhelp,
       XtCHelp,
       XtRBoolean,
       sizeof(Boolean),
       XtOffset(ApplicationDataPtr, help),
       XtRImmediate,
       (caddr_t) FALSE,
     },

    { XtNtasks,
	XtCTasks,
	XtRBoolean,
        sizeof(Boolean),
        XtOffset(ApplicationDataPtr, tasks),
        XtRImmediate,
        (caddr_t) FALSE,
      },
};

ApplicationData data;             /* pointer to the XtResource list     */




/* STATE DEFINITION:  
   color "cell" structure contains the color's name and its index/pixel val 
   used in making state's color choice*/
                                             
struct colorDescriptor{
  char color[55];
  int pixel;
};

struct colorDescriptor colortable[20];
#endif











/** GENERAL STRUCTURES INVOLVING GRAPHIC DEPENDENT COMPONENTS----------------*/

#ifdef X_REL4

/* PAGE */
struct page{                     /* PAGE: the logfile is divided into chunks */
  int number;                    /* smll enough to fit in a buffer containing*/
  long low;                   /* up to EVENT_MAX events.  The struct contains*/
  long high;                  /* info about a particular chunk: where it     */
  int eventTotal;             /* begins, ends in the file (byte offset) and  */
                              /* its number and total events it covers       */

  Widget button;              /* corresponding page widget */
};


/* STATE NODE */
struct stateNode{             /* state info components make up the */
  int start;                  /* states queue                      */
  int end;
  int color;
  char name[CDATALEN];
  struct stateNode *next;
  
  Widget colorKey;            /* referenced to create the StateKey */
};


#endif



/** GENERAL STRUCTURES -----------------------------------------------------*/

/* EVENT DATA */
struct eventData{                  /** log table components **/
  int id;              
  int event;
  int i_data;
  char c_data[CDATALEN];
  unsigned long time;
  /* Stuff for processing states */
  int      state_off;               /* index of matching event */
  struct   stateNode *statep;       /* pointer to state structure */
  int      state_num;               /* index of state structure */
  int      level;                   /* number of active states we this state
				       started, - 1*/
};

/* LINE REF */
struct line_ref{                 /* reference array components */
  int id;
  int proc_line;
};

/* STATE LINE INFO */
#define MAX_ACTIVE_STATES 10
struct state_line_info{          /*STATE LINE INFO is used in the plotting of*/
  int event;                     /* states it helps keep track of the events*/ 
  unsigned long time;            /*for each process line */
  /* The following is the "new" code */
  int      nactive_states;
  int      state_stack[MAX_ACTIVE_STATES];   /* state-number */
  int      state_off[MAX_ACTIVE_STATES];     /* location of matching state */
};


/* EVENT FORMAT */
struct eventFormatData{          /* each event format node contains the      */
  int event;                     /* printing format for string data of that  */
  char format[BUFLEN];           /* event                                    */
  struct eventFormatData *next;
};





/** ARRAYS AND POINTERS --------------------------------------------------- **/
EXTERN int    nevents;
EXTERN struct eventData *buffer;  /*holds the event data from tracefile */

EXTERN struct line_ref procTable[PROCESS_MAX];/*maps ids to proc lines  */

EXTERN struct page *firstPg; /*indicates the logfile page currently in the buffer */

EXTERN int    nstates;            /* Number of defined states */
EXTERN struct stateNode *states;  /* points to the beginning of the state queue */
EXTERN struct stateNode *available; /* points to queue of empty, ready to use nodes */

EXTERN struct state_line_info state_check[PROCESS_MAX]; /*helps keep track of states*/
EXTERN struct state_line_info bndry_check[PROCESS_MAX]; /*helps keep track of states
						  between page boundaries*/

EXTERN struct eventFormatData *dataFormat;     /* points to first event format node */

EXTERN int state_reference[MAX_EVTYPES]; /*in this vector events are matched to the */
		  /*state they are a part of: index = event, content = state */

EXTERN int children[MAX_NUM_CHILDREN];  /* An array of all of the PID's of the */
EXTERN int num_children;                /* children of upshot.  DPN */

EXTERN struct{            /* Array of structures which, when given a state number, */
    int start;     /* will tell you the starting and ending values of that  */
    int end;       /* state.  Used in Histogram().  Written by DPN. */
    char color[50];
}histohelp[100];



/** GENERAL GLOBALS ---------------------------------------------------------*/

EXTERN int entries;             /*total number of entries in the log file */
EXTERN int procTaskTotal;       /*number of different processes or tasks*/
EXTERN int event_types;         /*number of different types of events*/
EXTERN unsigned long fileBeginTime;  /* time of the first entry in the logfile */
EXTERN unsigned long fileEndTime;    /* timeo of the last entry in the logfile */
EXTERN unsigned long cycle_time;/*number of microseconds in one clock cycle*/
EXTERN unsigned long time_gap;  /*difference between start_time and cycle_time */
EXTERN int pgTotal;             /*records number of pages occupied by logfile */
EXTERN long header;            /*byte offset from beginning of file to end of header*/


EXTERN int draw_states;         /*flag indicates if states should be graphed*/
EXTERN int draw_events;         /*flag indicates events are being drawn*/

EXTERN int StatefileLoaded;     /*flag indicates statefile was successfully read in*/
EXTERN int colorScreen;         /*flag indicates whether to use color or not */
EXTERN int initState_ref;       /*keeps track of the whether the state_reference array
			   has been initialized or not */
EXTERN int DataBoxAlive;        /*indicates if data box is currently being displayed*/
                             
EXTERN long canvas_secs;        /* amt. microseconds seen on canvas at 1 time*/
EXTERN int canvas_height;       /* height of the canvas depends on the number of 
			    processes or tasks */
EXTERN char units_name[15];     /*name of the units labeled on time line */
EXTERN float interval;          /*units of time per pixel*/
EXTERN int sec_incrmnt;         /*number of time units between markers */
EXTERN int marker_tag;          /* used to manipulate the val of sec_incrmnt */
EXTERN unsigned long begin_label;  /*current screen time in appropriate time unit*/


EXTERN unsigned long start_time;/* time of first event in the buffer */
EXTERN unsigned long end_time;  /*time of last event in the buffer*/
EXTERN long view_time;          /*leftmost time displayed on the canvas*/
EXTERN long left_time;          /* left and right time boundaries of current graph */
EXTERN long right_time;

EXTERN int pix_incrmnt;         /* no. of pixels corresp. to given sec_incrmnt */
EXTERN int pixmapwidth;         /* the width of the pixmap in pixels */ 
EXTERN long pixmap_secs;        /* total microseconds currently graphed on pixmap*/

EXTERN int next_event;          /* index to buffer's first event graphed on pixmap */
EXTERN int last_displayed;      /* index to buffer's last event graphed on pixmap*/

EXTERN int bufferwidth;         /*present width of the buffer in pixels */

EXTERN float zoomfactor;        /*records the current zoomfactor */

EXTERN int drawMini;            /* indicates whether to draw part of mini upshot */

EXTERN FILE *logfileP;          /* Pointer to log file */


/* Inline some simple routines */
#define time_to_pixels(time) ((time - left_time) / interval)

int *proclistflag;	 /* ptr to an array of int; used as a set of flags
			    to determine the process list (arg to xhist) */

