BeginPackage["Words`", "Global`"]

(* 
Last modified 20.5.1992.

Juha Haataja, Centre for Scientific Computing.
E-mail: Juha.Haataja@csc.fi.
*)

(************************************************************************)
(*-----------------------------------------------------------------------
An example of use:

numwords = (symbwords = Words[{A,B},2]) /.
   {A->{{1001, 999}, {999, 1001}}, B->{{I*1001, 999}, {-999, I*1001}}};

images = Map[GenVal[#,0.5]&, N[numwords]];
------------------------------------------------------------------------*)
(************************************************************************)

GenVal::usage = "Calculate the image of complex number z using generator gen:
GenVal[gen,z]"

Words::usage = "Generate words of a group up to word length m, given
generators {g1,g2,...}."

(************************************************************************)

GenVal[{{a_,b_},{c_, d_}}, z_] := (a*z+b)/(c*z+d)

(************************************************************************)

Words[gen_List, n_Integer:1] :=
	Block[{genlist, len, indexes, w},
	If[n < 1, {},
		genlist = Join[gen, Map[Inverse,gen]]; 
		len = Length[genlist];
		indexes = Table[{i,n,1}, {i, len}];
		w = Table[GenWords[indexes[[i]], genlist[[i]], genlist],
			{i, len}];
		Flatten[w,1]]]


GenWords[{idx_,n_,level_}, elem_, genlist_List] :=
	Block[{len = Length[genlist], indexes, genl, w},
	If[n <= level, {elem},
	indexes = Drop[Table[i, {i, 1, len}], 
		{1+Mod[idx + len/2 - 1, len]}];
	genl = Map[Dot[#, elem]&, genlist[[indexes]]]; 
	len = Length[genl];
	indexes = Table[{indexes[[i]], n, level+1}, {i, 1, Length[indexes]}];
	w = Table[GenWords[indexes[[i]], genl[[i]], genlist], 
		{i, 1, len}];
	Join[{elem},Flatten[w,1]]]]


(************************************************************************)

EndPackage[]
Null

(************************************************************************)
