BeginPackage["TwoDiff`"]

(*

This package defines some routines for calculation of
2-differentials.

Version 0.9, March 5, 1992.

Send comments and bug reports to
  Juha Haataja, Centre for Scientific Computing (jhaataja@csc.fi).

*)


(************************************************************************)

GenVal::usage = "Calculate the image of complex number z using generator gen:
GenVal[gen,z]"

FixedPoints::usage = "Calculate the attracting and repulsing fixed points
of a Moebius transformation: FixedPoints[gen]"

TwoDiff::usage = "Calculates the 2-differentials (for the
two-generator case): \n \n
TwoDiff[{a1, a2, a3, b1, b2, b3, zeta, level}, {a,b}] \n \n
where a1 ... zeta are complex numbers, level is the iteration level
(integer 0, 1, ...), and a and b are Moebius transformations"

(************************************************************************)

GenVal[{{a_,b_},{c_, d_}}, z_] := (a*z+b)/(c*z+d)

FixedPoints[gen:{{a_,b_},{c_, d_}}] :=
	Block[{za, zr, z, val = GenVal[gen,z], k},
	{za,zr} = z /. NSolve[val == z, z];
	val = GenVal[gen, 0];
	k = (val - za)/(val - zr);
	If[k > 1, {za,zr}, {zr,za}]]

TwoDiff[lista:{a1_, a2_, a3_}, listb:{b1_, b2_, b3_}, zeta_, n_, gen_List] :=
	Block[{param = Map[Prepend[lista,#]&, listb], result, genlist, len, 
		omega, indexes, idmat = {{1,0},{0,1}}, mult},
	omega = Map[TwoOmega[#, zeta, idmat]&, param];
	result = If[n < 1, omega,
		genlist = Join[gen, Map[Inverse,gen]]; 
		len = Length[genlist];
		indexes = Table[{i,n,1}, {i, len}];
		w = Table[TwoGener[indexes[[i]], genlist[[i]], genlist, 
			param, zeta], {i, len}];
		omega = omega + Sum[w[[i]], {i, len}]];
	mult = Map[(-(# - a1)*(# - a2)*(# - a3)/(2*Pi))&, listb];
	N[mult]*result]


TwoOmega[{bj_, a1_, a2_, a3_}, z_, gen:{{a_,b_},{c_,d_}}] :=
        Block[{gz, upper, lower, result},
        upper = (a*d - b*c)^2;
        gz = GenVal[gen, z];
        lower = ((d + c*z)^4)*(gz - bj)*(gz - a1)*(gz - a2)*(gz - a3);
        If[N[Abs[lower]] == 0,
                Print[InputForm[gen]]; result = 0,
                result = upper/lower];
        result]

TwoGener[{idx_,n_,level_}, elem_List, genlist_List, param_List, zeta_] :=
	Block[{omega = Map[TwoOmega[#, zeta, elem]&, param],
		len = Length[genlist], indexes, genl, w},
	If[n <= level, omega,
	indexes = Drop[Table[i, {i, 1, len}], 
		{1+Mod[idx + len/2 - 1, len]}];
	indexes = Select[indexes, (0 != Det[genlist[[#]]]&)];
	genl = Map[Dot[#, elem]&, genlist[[indexes]]]; 
	len = Length[genl];
	indexes = Table[{indexes[[i]], n, level+1}, {i, 1, Length[indexes]}];
	w = Table[TwoGener[indexes[[i]], genl[[i]], genlist, param, zeta], 
		{i, 1, len}];
	omega = omega + Sum[w[[i]], {i, 1, len}]]]


(************************************************************************)



EndPackage[]
Null

