(************************************************************************)
<< Tessellate.m

(************************************************************************)

FindWholeArcs[{z1_,z2_}] :=
	Block[{c1 = GeodCircleCenter[z1,z2], 
		crc = Circle[ZToReIm[c1],Abs[c1-z1]]},
	SolveCircles[crc,UnitCircle]];

DrawCompletedTriangle[pts_List] :=
    Block[{triangle = Flatten[pts], len = Length[triangle],
       hypcenter, hypmiddles, centerarcs, segments, triarcpict,
       trianglepict, arcpict, ptpict},
    hypcenter = HypCenterOfPolygon[triangle];
    segments = Table[{triangle[[i]],triangle[[1+Mod[i,len]]]}, {i, 1, len}];
    triarcs = Map[FindWholeArcs, segments];
    hypmiddles = Map[HypMiddleOfArc, segments];
    centerarcs = Map[{#,hypcenter}&, hypmiddles];
    triarcpict = DrawArcs[triarcs, Prolog -> {AbsoluteThickness[0.5]},
        Trailer -> {DisplayFunction -> Identity}];
    trianglepict = DrawHypPolygons[triangle, Prolog -> {AbsoluteThickness[1.5]},
        Trailer -> {DisplayFunction -> Identity}];
    arcpict = DrawArcs[centerarcs, Trailer -> {DisplayFunction -> Identity}, 
        Prolog -> {AbsoluteThickness[0.9]}];
    ptpict = DrawPoints[Prepend[hypmiddles, hypcenter], 
        Trailer -> {DisplayFunction -> Identity}, 
        Prolog -> {AbsoluteThickness[1.5], UnitCircle, AbsolutePointSize[4]}];
    Show[triarcpict, trianglepict, arcpict, ptpict, 
        DisplayFunction -> $DisplayFunction, AspectRatio -> Automatic]]

(************************************************************************)

(* Hyperbolinen kolmio *)
triangle = {0.55 + 0.55*I, -0.6 + 0.45*I, -0.1 - 0.6*I};
trigraf = DrawCompletedTriangle[triangle]
(* Display["!psfix > triangle.ps", trigraf] *)

(************************************************************************)
