BeginPackage["Quasi`", "Global`", {"Moebius`"}]

(* 

A package for calculating limit sets of quasi-fuchsian groups.

Original programming by Jouni Parkkonen, modifications by Juha Haataja.

This package needs also the package "Moebius.m", available for
anonymous ftp at nic.funet.fi, directory "pub/sci/math/riemann/mathematica".

Last modified: May 18th, 1992.

Send comments and bug reports to 
  Juha Haataja, Centre for Scientific Computing (jhaataja@csc.fi).

*)

(************************************************************************)

(* 
An example of use:

p = 1.5;
A = MGenFromPoints[{-1,p I,0},{-p I,1,(1-p I)/2}];
B = MGenFromPoints[{-1,-p I,0},{p I,1,(1+p I)/2}];
gens = {A,B};

initpoints = {-1, p I, 1, -p I};

wordlength = 3;
pointset = Quasi[gens,initpoints,wordlength];

points = Map[{Re[#],Im[#]}&, pointset];

picture = ListPlot[points, AspectRatio->1, 
	PlotStyle->{AbsolutePointSize[1]}]

*)


(************************************************************************)

Quasi[generators_List, pts_List, n_Integer:1] :=
	Block[{genlist, len, indexes, w},
	If[n < 1, pts,
		genlist = Join[generators, Map[Inverse,generators]]; 
		len = Length[genlist];
		indexes = Table[{i,n,1}, {i, len}];
		w = Table[GenQuasi[indexes[[i]], genlist[[i]], genlist, pts], 
				{i, len}];
		Flatten[Join[pts, w]]]]

GenQuasi[{idx_,n_,level_}, elem_List, genlist_List, pts_List] :=
	Block[{w0 = ApplyMGen[elem,pts],
		len = Length[genlist], indexes, genl, w},
 	If[n <= level, w0, 
		indexes = Drop[Table[i, {i, 1, len}], 
			{1+Mod[idx + len/2 - 1, len]}];
		indexes = Select[indexes, (0 != Det[genlist[[#]]]&)];
		genl = Map[Dot[#, elem]&, genlist[[indexes]]]; 
		len = Length[genl];
		indexes = Table[{indexes[[i]], n, level+1}, 
				{i, 1, Length[indexes]}];
		w = Table[GenQuasi[indexes[[i]], genl[[i]], genlist, pts], 
				{i, 1, len}];
		Flatten[Join[pts, w, w0]]]]


(************************************************************************)


EndPackage[]
Null

