(*^

::[currentKernel; 
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e8,  24, "Times"; ;
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e6,  18, "Times"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, L1, e6,  14, "Times"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L1, a20,  18, "Times"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L1, a15,  14, "Times"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L1, a12,  12, "Times"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  10, "Times"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M23, N23, bold, L-5,  10, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L1,  12, "Courier"; ;
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, L1,  10, "Geneva"; ;
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = Left Header, inactive,  12, "Times"; ;
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7, L1,  12, "Times"; ;
	fontset = Left Footer, inactive,  12, "Times"; ;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  10, "Times"; ;
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;]
:[font = input; initialization; preserveAspect; ]
*)
BeginPackage["CrossRatio`", "Global`", 
   {"Algebra`ReIm`", "Moebius`", "Tessellate`"}]

(* 

A short package for calculation of double ratios 

Version 1.0, January 19th, 1993. 
Requires Mathematica version 2.0 or greater.

This newest version of this package is available for anonymous ftp at
nic.funet.fi, directory "pub/sci/math/riemann/mathematica".

Last modified: January 19th, 1993.

Send comments and bug reports to 
  Juha Haataja, Centre for Scientific Computing (jhaataja@csc.fi).

*)


(************************************************************************)

RealVar::usage = "Assert a variable real: RealVar[var]"

PlotZeros::usage = "Use ListPlot to plot a list of {x,y} values: 
PlotZeros[list]"

PlotPoly::usage = "Use ContourPlot to plot a polynomial of two
variables: PlotPoly[poly, {x,y}]"

MakePoly::usage = "Generate a polynomial from a cross ratio, and use
PlotPoly to make a graphical display: MakePoly[{h1, h2, h3}]"

CrossRatio::usage = "Calculate the cross ratio: CrossRatio[a,b,c,d]"

CrossRatioPoly::usage = "Calculate a polynomial from a cross ratio, using
numerical approximation: CrossRatioPoly[{f1, f2, f3}, {x, y}]"

PolySolve::usage = "Find the zeros of a polynomial in two variables along
vertical or horizontal lines: PolySolve[poly, {x,y}, linenr]"

MakeAndSolvePolys::usage = "Given a list of triples of generators,
calculate polynomials and their zeros along vertical lines:
MakeAndSolvePolys[comb]"

CrossRatioPicture::usage = "Calculate and draw the polynomial resulting 
from the cross ratio: CrossRatioPicture[{Ag,Aig,BAg}]"

(************************************************************************)

Options[PlotPoly] = {PlotRange -> {{-1,-1},{1,1}}, PlotPoints -> 30,
   PlotLabel -> ""}

Options[CrossRatioPicture] = {PlotRange -> {{-1,-1},{1,1}}, 
   Resolution -> 50, PlotLabel -> "", Precision -> 16}

(************************************************************************)

Begin["`Private`"]

(************************************************************************)

(* Function for asserting a variable real *)

RealVar[var_] := var/: Im[var] = 0

(************************************************************************)

(* Move complex points with a given generator *)

ApplyMGen[gen_,point_] :=
	(Divide @@ (Dot[gen, {point,1}]))  /; AtomQ[point]

ApplyMGen[{{a_,b_},{c_,d_}},point_] := a/c  /; SameQ[point,ComplexInfinity]

ApplyMGen[gen_,points_List] :=
	Map[ApplyMGen[gen,#]&, points]
	
(************************************************************************)

(* Graphics routines *)

MakeColorLevel[level_,maxlevel_] :=
        Hue[N[0.9*(maxlevel-level)/maxlevel],0.6,0.65]

PlotZeros[zeros_List, plrange_:{{-1,1},{-1,1}}] :=
		ListPlot[zeros, PlotRange -> plrange, 
		AspectRatio -> Automatic, 
		PlotStyle -> AbsolutePointSize[1]]

PlotPoly[poly_, {x_, y_}, opts___Rule] :=
   Block[{plotpoints, plotrange, plx, ply, plotlbl},
   plotpoints = PlotPoints /. {opts} /. Options[PlotPoly];
   plotrange = PlotRange /. {opts} /. Options[PlotPoly];
   plx = {plotrange[[1,1]], plotrange[[2,1]]};
   ply = {plotrange[[1,2]], plotrange[[2,2]]};
   plotlbl = PlotLabel /. {opts} /. Options[PlotPoly];
   ContourPlot[poly, {x,plx[[1]],plx[[2]]}, {y,ply[[1]],ply[[2]]},
      Contours->{0}, 
      ContourSmoothing->2, ContourShading->False, 
      ContourStyle->{MakeColorLevel[1,1], AbsoluteThickness[0.2]},
      Frame -> False,
      PlotPoints -> plotpoints, 
      DisplayFunction -> Identity,
      PlotLabel -> plotlbl]]

MakePoly[{f1_, f2_, f3_}, points_:80, precision_:16] :=
	PlotPoly[CrossRatioPoly[{f1, f2, f3}, {x,y}, precision], 
		{x,y}, points]

MakePoly[{f1_, f2_, f3_}, nr_Integer, max_Integer, 
		points_Integer, precision_:16] :=
	PlotPoly[CrossRatioPoly[{f1, f2, f3}, {x,y}, precision], 
		{x, y}, points, nr, max]


(************************************************************************)

DoubleRatio[a_,b_,c_,d_] :=
	((c - a)/(c - b)) / ((d - a)/(d - b))

(* Calculate the double ratio numerically *)

CrossRatioPoly[{f1_, f2_, f3_}, {x_, y_}, precision_:16] := 
	Block[{z, p, q, poly, upper, lower, PA, PB, PC, PD},
	(* Numerator and denominator of the double ratio *)
	p[z_] := (z-f2[z])(f1[z]-f3[z]);
	q[z_] := (z-f1[z])(f2[z]-f3[z]);
	(* Assert that x and y are real *)
	x/: Im[x] = 0; y/: Im[y] = 0;
	(* Calculate the polynomial as a function of x and y numerically *)
	poly = Together[N[p[x + I*y]/q[x + I*y], precision]];
	(* Split the fractions *)
	upper = Numerator[poly]; lower = Denominator[poly];
	(* Find out the imaginary part *)
	PA = Re[upper]; PB = Im[upper];
	PC = Re[lower]; PD = Im[lower];
	PB*PC - PA*PD]


PolySolve[poly_, {var1_, var2_}, lines_Integer:5, precision_:16] :=
	Block[{points = Table[i, {i,-1,1,2.0/lines}], sol, list, i},
	sol = Table[{points[[i]], var2} /. 
		NSolve[(poly /. var1 -> points[[i]])==0, var2, 
		WorkingPrecision -> precision], 
			{i,1,lines+1}];
	sol = Flatten[sol,1]; list = {};
	For[i=1, i<=Length[sol], i++,
		If[(Im[sol[[i,2]]]==0) && 
			(N[Abs[sol[[i,1]]]^2 + Abs[sol[[i,2]]]^2] <= 1.0005), 
		list = Append[list, sol[[i]]]]];
	list]


MakeAndSolvePolys[comb_List, linr_:200] := 
   Block[{soltable = Table[1, {linr + 1}, {linr + 1}],
		x, y, polyz, sol1, sol2, sol, xind, yind},
	polyz = Map[CrossRatioPoly[#,{x,y}]&, comb];
	sol1 = Flatten[Map[PolySolve[#,{x,y}, linr]&, polyz],1];
	sol2 = Map[RotateLeft,Flatten[Map[PolySolve[#,{y,x}, linr]&, 
		polyz],1]];
	sol = Join[sol1, sol2];   
	For[j = 1, j <= Length[sol], j++,
		xind = Round[1.0 + linr*(sol[[j,1]] + 1)/2.0];
		yind = Round[1.0 + linr*(sol[[j,2]] + 1)/2.0];
	soltable[[xind, yind]] = 0];
	soltable]

(************************************************************************)

CRPict[{g1_, g2_, g3_}, resolution_Integer:50, numprecision_Integer:16, 
      plotrange_List:{{-1,1},{1,1}}] :=
   Block[{h1, h2, h3, vars, x, y, z, numpoly, curvepict},
   h1[z_] = ApplyMGen[g1,z];
   h2[z_] = ApplyMGen[g2,z];
   h3[z_] = ApplyMGen[g3,z];
   vars = {x, y};
   numpoly = N[CrossRatioPoly[{h1, h2, h3}, vars], numprecision];
   curvepict = PlotPoly[numpoly, vars, PlotRange -> plotrange, 
      PlotPoints -> resolution]]

CrossRatioPicture[gensets_List, opts___Rule] :=
   Block[{curvepicts, polygon18, polygonpict,
      plotrange, resolution, plotlbl,precision}, 
   plotrange = PlotRange /. {opts} /. Options[CrossRatioPicture];
   resolution = Resolution /. {opts} /. Options[CrossRatioPicture];
   plotlbl = PlotLabel /. {opts} /. Options[CrossRatioPicture];
   precision = Precision /. {opts} /. Options[CrossRatioPicture];
   curvepicts = Map[CRPict[#, resolution, precision, plotrange]&, gensets];
   polygon18 = RegularPolygon[18, 2*Pi/3, 0];
   polygonpict = DrawHypPolygons[polygon18, DisplayFunction -> Identity, 
      Prolog -> {AbsoluteThickness[0.2]}, 
      Trailer -> {PlotRange -> plotrange}];
   Show[curvepicts, polygonpict, PlotLabel -> plotlbl, 
   DisplayFunction -> $DisplayFunction, 
      AspectRatio -> Automatic]]
	
(************************************************************************)
End[]

(************************************************************************)

EndPackage[]
Null

(************************************************************************)
(*
;[s]
9:0,0;1650,1;1658,0;1666,1;1748,0;1765,1;1856,0;6132,1;6133,0;7208,-1;
2:5,10,8,Courier,1,10,0,0,0;4,10,8,Courier,0,10,0,0,0;
^*)