/* genbet.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__9 = 9;
static integer c__1 = 1;
static integer c__4 = 4;

real genbet_(aa, bb)
real *aa, *bb;
{
    /* Initialized data */

    static real olda = (float)-1.;
    static real oldb = (float)-1.;

    /* System generated locals */
    real ret_val, r__1;

    /* Builtin functions */
    integer s_wsle(), do_lio(), e_wsle();
    /* Subroutine */ int s_stop();
    double sqrt(), log(), exp();

    /* Local variables */
    static real beta;
    extern real ranf_();
    static real a, b, gamma, r, s, alpha, t, v, w, delta, y, z;
    static logical qsame;
    static real k1, k2, u1, u2;

    /* Fortran I/O blocks */
    static cilist io___4 = { 0, 6, 0, 0, 0 };
    static cilist io___5 = { 0, 6, 0, 0, 0 };


/* ********************************************************************** 
*/

/*     REAL FUNCTION GENBET( A, B ) */
/*               GeNerate BETa random deviate */


/*                              Function */


/*     Returns a single random deviate from the beta distribution with */
/*     parameters A and B.  The density of the beta is */
/*               x^(a-1) * (1-x)^(b-1) / B(a,b) for 0 < x < 1 */


/*                              Arguments */


/*     A --> First parameter of the beta distribution */
/*                         REAL A */

/*     B --> Second parameter of the beta distribution */
/*                         REAL B */


/*                              Method */


/*     R. C. H. Cheng */
/*     Generating Beta Variatew with Nonintegral Shape Parameters */
/*     Communications of the ACM, 21:317-322  (1978) */
/*     (Algorithms BB and BC) */

/* ********************************************************************** 
*/
/*     .. Parameters .. */
/*     Close to the largest number that can be exponentiated */
/*     Close to the largest representable single precision number */
/*     .. */
/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Save statement .. */
/*     .. */
/*     .. Data statements .. */
/*     .. */
/*     .. Executable Statements .. */
    qsame = olda == *aa && oldb == *bb;
    if (qsame) {
	goto L20;
    }
    if (! (*aa <= (float)0. || *bb <= (float)0.)) {
	goto L10;
    }
    s_wsle(&io___4);
    do_lio(&c__9, &c__1, " AA or BB <= 0 in GENBET - Abort!", 33L);
    e_wsle();
    s_wsle(&io___5);
    do_lio(&c__9, &c__1, " AA: ", 5L);
    do_lio(&c__4, &c__1, (char *)&(*aa), (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " BB ", 4L);
    do_lio(&c__4, &c__1, (char *)&(*bb), (ftnlen)sizeof(real));
    e_wsle();
    s_stop(" AA or BB <= 0 in GENBET - Abort!", 33L);
L10:
    olda = *aa;
    oldb = *bb;
L20:
    if (! (min(*aa,*bb) > (float)1.)) {
	goto L100;
    }
/*     Alborithm BB */

/*     Initialize */

    if (qsame) {
	goto L30;
    }
    a = min(*aa,*bb);
    b = max(*aa,*bb);
    alpha = a + b;
    beta = sqrt((alpha - (float)2.) / (a * (float)2. * b - alpha));
    gamma = a + (float)1. / beta;
L30:
L40:
    u1 = ranf_();

/*     Step 1 */

    u2 = ranf_();
    v = beta * log(u1 / ((float)1. - u1));
    if (! (v > (float)89.)) {
	goto L50;
    }
    w = (float)1e38;
    goto L60;
L50:
    w = a * exp(v);
L60:
/* Computing 2nd power */
    r__1 = u1;
    z = r__1 * r__1 * u2;
    r = gamma * v - (float)1.3862944;
    s = a + r - w;

/*     Step 2 */

    if (s + (float)2.609438 >= z * (float)5.) {
	goto L70;
    }

/*     Step 3 */

    t = log(z);
    if (s > t) {
	goto L70;
    }

/*     Step 4 */

    if (r + alpha * log(alpha / (b + w)) < t) {
	goto L40;
    }

/*     Step 5 */

L70:
    if (! (*aa == a)) {
	goto L80;
    }
    ret_val = w / (b + w);
    goto L90;
L80:
    ret_val = b / (b + w);
L90:
    goto L230;
/*     Algorithm BC */

/*     Initialize */

L100:
    if (qsame) {
	goto L110;
    }
    a = max(*aa,*bb);
    b = min(*aa,*bb);
    alpha = a + b;
    beta = (float)1. / b;
    delta = a + (float)1. - b;
    k1 = delta * (b * (float).0416667 + (float).0138889) / (a * beta - (float)
	    .777778);
    k2 = ((float).25 / delta + (float).5) * b + (float).25;
L110:
L120:
    u1 = ranf_();

/*     Step 1 */

    u2 = ranf_();
    if (u1 >= (float).5) {
	goto L130;
    }

/*     Step 2 */

    y = u1 * u2;
    z = u1 * y;
    if (u2 * (float).25 + z - y >= k1) {
	goto L120;
    }
    goto L170;

/*     Step 3 */

L130:
/* Computing 2nd power */
    r__1 = u1;
    z = r__1 * r__1 * u2;
    if (! (z <= (float).25)) {
	goto L160;
    }
    v = beta * log(u1 / ((float)1. - u1));
    if (! (v > (float)89.)) {
	goto L140;
    }
    w = (float)1e38;
    goto L150;
L140:
    w = a * exp(v);
L150:
    goto L200;
L160:
    if (z >= k2) {
	goto L120;
    }

/*     Step 4 */


/*     Step 5 */

L170:
    v = beta * log(u1 / ((float)1. - u1));
    if (! (v > (float)89.)) {
	goto L180;
    }
    w = (float)1e38;
    goto L190;
L180:
    w = a * exp(v);
L190:
    if (alpha * (log(alpha / (b + w)) + v) - (float)1.3862944 < log(z)) {
	goto L120;
    }

/*     Step 6 */

L200:
    if (! (a == *aa)) {
	goto L210;
    }
    ret_val = w / (b + w);
    goto L220;
L210:
    ret_val = b / (b + w);
L220:
L230:
    return ret_val;
} /* genbet_ */

