/* dsytd2.f -- translated by f2c (version 19941103).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static doublereal c_b8 = 0.;
static doublereal c_b14 = -1.;

/* Subroutine */ int dsytd2_(uplo, n, a, lda, d, e, tau, info, uplo_len)
char *uplo;
integer *n;
doublereal *a;
integer *lda;
doublereal *d, *e, *tau;
integer *info;
ftnlen uplo_len;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2, i__3;

    /* Local variables */
    extern doublereal ddot_();
    static doublereal taui;
    extern /* Subroutine */ int dsyr2_();
    static integer i;
    static doublereal alpha;
    extern logical lsame_();
    extern /* Subroutine */ int daxpy_();
    static logical upper;
    extern /* Subroutine */ int dsymv_(), dlarfg_(), xerbla_();


/*  -- LAPACK routine (version 2.0) -- */
/*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd., */
/*     Courant Institute, Argonne National Lab, and Rice University */
/*     October 31, 1992 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DSYTD2 reduces a real symmetric matrix A to symmetric tridiagonal */
/*  form T by an orthogonal similarity transformation: Q' * A * Q = T. */

/*  Arguments */
/*  ========= */

/*  UPLO    (input) CHARACTER*1 */
/*          Specifies whether the upper or lower triangular part of the */
/*          symmetric matrix A is stored: */
/*          = 'U':  Upper triangular */
/*          = 'L':  Lower triangular */

/*  N       (input) INTEGER */
/*          The order of the matrix A.  N >= 0. */

/*  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N) */
/*          On entry, the symmetric matrix A.  If UPLO = 'U', the leading 
*/
/*          n-by-n upper triangular part of A contains the upper */
/*          triangular part of the matrix A, and the strictly lower */
/*          triangular part of A is not referenced.  If UPLO = 'L', the */
/*          leading n-by-n lower triangular part of A contains the lower 
*/
/*          triangular part of the matrix A, and the strictly upper */
/*          triangular part of A is not referenced. */
/*          On exit, if UPLO = 'U', the diagonal and first superdiagonal 
*/
/*          of A are overwritten by the corresponding elements of the */
/*          tridiagonal matrix T, and the elements above the first */
/*          superdiagonal, with the array TAU, represent the orthogonal */
/*          matrix Q as a product of elementary reflectors; if UPLO */
/*          = 'L', the diagonal and first subdiagonal of A are over- */
/*          written by the corresponding elements of the tridiagonal */
/*          matrix T, and the elements below the first subdiagonal, with 
*/
/*          the array TAU, represent the orthogonal matrix Q as a product 
*/
/*          of elementary reflectors. See Further Details. */

/*  LDA     (input) INTEGER */
/*          The leading dimension of the array A.  LDA >= max(1,N). */

/*  D       (output) DOUBLE PRECISION array, dimension (N) */
/*          The diagonal elements of the tridiagonal matrix T: */
/*          D(i) = A(i,i). */

/*  E       (output) DOUBLE PRECISION array, dimension (N-1) */
/*          The off-diagonal elements of the tridiagonal matrix T: */
/*          E(i) = A(i,i+1) if UPLO = 'U', E(i) = A(i+1,i) if UPLO = 'L'. 
*/

/*  TAU     (output) DOUBLE PRECISION array, dimension (N-1) */
/*          The scalar factors of the elementary reflectors (see Further 
*/
/*          Details). */

/*  INFO    (output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  if INFO = -i, the i-th argument had an illegal value. */

/*  Further Details */
/*  =============== */

/*  If UPLO = 'U', the matrix Q is represented as a product of elementary 
*/
/*  reflectors */

/*     Q = H(n-1) . . . H(2) H(1). */

/*  Each H(i) has the form */

/*     H(i) = I - tau * v * v' */

/*  where tau is a real scalar, and v is a real vector with */
/*  v(i+1:n) = 0 and v(i) = 1; v(1:i-1) is stored on exit in */
/*  A(1:i-1,i+1), and tau in TAU(i). */

/*  If UPLO = 'L', the matrix Q is represented as a product of elementary 
*/
/*  reflectors */

/*     Q = H(1) H(2) . . . H(n-1). */

/*  Each H(i) has the form */

/*     H(i) = I - tau * v * v' */

/*  where tau is a real scalar, and v is a real vector with */
/*  v(1:i) = 0 and v(i+1) = 1; v(i+2:n) is stored on exit in A(i+2:n,i), 
*/
/*  and tau in TAU(i). */

/*  The contents of A on exit are illustrated by the following examples */
/*  with n = 5: */

/*  if UPLO = 'U':                       if UPLO = 'L': */

/*    (  d   e   v2  v3  v4 )              (  d                  ) */
/*    (      d   e   v3  v4 )              (  e   d              ) */
/*    (          d   e   v4 )              (  v1  e   d          ) */
/*    (              d   e  )              (  v1  v2  e   d      ) */
/*    (                  d  )              (  v1  v2  v3  e   d  ) */

/*  where d and e denote diagonal and off-diagonal elements of T, and vi 
*/
/*  denotes an element of the vector defining H(i). */

/*  ===================================================================== 
*/

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = a_dim1 + 1;
    a -= a_offset;
    --d;
    --e;
    --tau;

    /* Function Body */
    *info = 0;
    upper = lsame_(uplo, "U", 1L, 1L);
    if (! upper && ! lsame_(uplo, "L", 1L, 1L)) {
	*info = -1;
    } else if (*n < 0) {
	*info = -2;
    } else if (*lda < max(1,*n)) {
	*info = -4;
    }
    if (*info != 0) {
	i__1 = -(*info);
	xerbla_("DSYTD2", &i__1, 6L);
	return 0;
    }

/*     Quick return if possible */

    if (*n <= 0) {
	return 0;
    }

    if (upper) {

/*        Reduce the upper triangle of A */

	for (i = *n - 1; i >= 1; --i) {

/*           Generate elementary reflector H(i) = I - tau * v * v'
 */
/*           to annihilate A(1:i-1,i+1) */

	    dlarfg_(&i, &a[i + (i + 1) * a_dim1], &a[(i + 1) * a_dim1 + 1], &
		    c__1, &taui);
	    e[i] = a[i + (i + 1) * a_dim1];

	    if (taui != 0.) {

/*              Apply H(i) from both sides to A(1:i,1:i) */

		a[i + (i + 1) * a_dim1] = 1.;

/*              Compute  x := tau * A * v  storing x in TAU(1:
i) */

		dsymv_(uplo, &i, &taui, &a[a_offset], lda, &a[(i + 1) * 
			a_dim1 + 1], &c__1, &c_b8, &tau[1], &c__1, 1L);

/*              Compute  w := x - 1/2 * tau * (x'*v) * v */

		alpha = taui * -.5 * ddot_(&i, &tau[1], &c__1, &a[(i + 1) * 
			a_dim1 + 1], &c__1);
		daxpy_(&i, &alpha, &a[(i + 1) * a_dim1 + 1], &c__1, &tau[1], &
			c__1);

/*              Apply the transformation as a rank-2 update: 
*/
/*                 A := A - v * w' - w * v' */

		dsyr2_(uplo, &i, &c_b14, &a[(i + 1) * a_dim1 + 1], &c__1, &
			tau[1], &c__1, &a[a_offset], lda, 1L);

		a[i + (i + 1) * a_dim1] = e[i];
	    }
	    d[i + 1] = a[i + 1 + (i + 1) * a_dim1];
	    tau[i] = taui;
/* L10: */
	}
	d[1] = a[a_dim1 + 1];
    } else {

/*        Reduce the lower triangle of A */

	i__1 = *n - 1;
	for (i = 1; i <= i__1; ++i) {

/*           Generate elementary reflector H(i) = I - tau * v * v'
 */
/*           to annihilate A(i+2:n,i) */

	    i__2 = *n - i;
/* Computing MIN */
	    i__3 = i + 2;
	    dlarfg_(&i__2, &a[i + 1 + i * a_dim1], &a[min(i__3,*n) + i * 
		    a_dim1], &c__1, &taui);
	    e[i] = a[i + 1 + i * a_dim1];

	    if (taui != 0.) {

/*              Apply H(i) from both sides to A(i+1:n,i+1:n) 
*/

		a[i + 1 + i * a_dim1] = 1.;

/*              Compute  x := tau * A * v  storing y in TAU(i:
n-1) */

		i__2 = *n - i;
		dsymv_(uplo, &i__2, &taui, &a[i + 1 + (i + 1) * a_dim1], lda, 
			&a[i + 1 + i * a_dim1], &c__1, &c_b8, &tau[i], &c__1, 
			1L);

/*              Compute  w := x - 1/2 * tau * (x'*v) * v */

		i__2 = *n - i;
		alpha = taui * -.5 * ddot_(&i__2, &tau[i], &c__1, &a[i + 1 + 
			i * a_dim1], &c__1);
		i__2 = *n - i;
		daxpy_(&i__2, &alpha, &a[i + 1 + i * a_dim1], &c__1, &tau[i], 
			&c__1);

/*              Apply the transformation as a rank-2 update: 
*/
/*                 A := A - v * w' - w * v' */

		i__2 = *n - i;
		dsyr2_(uplo, &i__2, &c_b14, &a[i + 1 + i * a_dim1], &c__1, &
			tau[i], &c__1, &a[i + 1 + (i + 1) * a_dim1], lda, 1L);

		a[i + 1 + i * a_dim1] = e[i];
	    }
	    d[i] = a[i + i * a_dim1];
	    tau[i] = taui;
/* L20: */
	}
	d[*n] = a[*n + *n * a_dim1];
    }

    return 0;

/*     End of DSYTD2 */

} /* dsytd2_ */

