/* trig.c
 * Trigonometric functions for RLaB */

/*  This file is a part of RLaB ("Our"-LaB)
    Copyright (C) 1992, 1994  Ian R. Searle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file ./COPYING
 ***********************************************************************/

#include "rlab.h"
#include "bltin.h"
#include "symbol.h"

#include "complex.h"
#include "scop1.h"
#include "matop1.h"
#include "matop2.h"
#include "list.h"
#include "listnode.h"
#include "r_string.h"
#include "util.h"
#include "mathl.h"

#include <math.h>

/* **************************************************************
 * Arc-Tangent. Only compute arc-tan-2 for scalars.
 * ************************************************************** */
void
Atan2 (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M1, *M2;

  /* Check n_args */
  if (n_args != 2)
    error_1 ("atan2: 2 arguments required", 0);

  M1 = bltin_get_numeric_matrix ("atan2", d_arg, 1);
  M2 = bltin_get_numeric_matrix ("atan2", d_arg, 2);
  *return_ptr = (VPTR) matrix_Atan2 (e_data (M1),
				     e_data (M2));
  remove_tmp_destroy (M1);
  remove_tmp_destroy (M2);
  return;
}

/* **************************************************************
 * sine function.
 * ************************************************************** */
void
Sin (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M;

  /* Check n_args */
  if (n_args != 1)
    error_1 ("sin: 1 argument allowed", 0);

  M = bltin_get_numeric ("sin", d_arg, 1);
  switch (e_type (M))
  {
  case SCALAR:
    *return_ptr = (VPTR) scalar_Sin (e_data (M));
    break;
    
  case MATRIX:
    *return_ptr = (VPTR) matrix_Sin (e_data (M));
    break;

  default:
    remove_tmp_destroy (M);
    error_1 ("sin: invalid argument", 0);
    break;
  }

  remove_tmp_destroy (M);
  return;
}

/* **************************************************************
 * arc-sine function.
 * ************************************************************** */
void
Asin (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M;

  /* Check n_args */
  if (n_args != 1)
    error_1 ("asin: 1 argument allowed", 0);

  M = bltin_get_numeric ("asin", d_arg, 1);
  switch (e_type (M))
  {
  case SCALAR:
    *return_ptr = (VPTR) scalar_Asin (e_data (M));
    break;
    
  case MATRIX:
    *return_ptr = (VPTR) matrix_Asin (e_data (M));
    break;

  default:
    remove_tmp_destroy (M);
    error_1 ("asin: invalid argument", 0);
    break;
  }

  remove_tmp_destroy (M);
  return;
}

/* **************************************************************
 * cosine function.
 * ************************************************************** */
void
Cos (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M;

  /* Check n_args */
  if (n_args != 1)
    error_1 ("cos: 1 argument allowed", 0);

  M = bltin_get_numeric ("cos", d_arg, 1);
  switch (e_type (M))
  {
  case SCALAR:
    *return_ptr = (VPTR) scalar_Cos (e_data (M));
    break;
    
  case MATRIX:
    *return_ptr = (VPTR) matrix_Cos (e_data (M));
    break;

  default:
    remove_tmp_destroy (M);
    error_1 ("cos: invalid argument", 0);
    break;
  }

  remove_tmp_destroy (M);
  return;
}

/* **************************************************************
 * arc-cosine function.
 * ************************************************************** */
void
Acos (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M;

  /* Check n_args */
  if (n_args != 1)
    error_1 ("acos: 1 argument allowed", 0);

  M = bltin_get_numeric ("acos", d_arg, 1);
  switch (e_type (M))
  {
  case SCALAR:
    *return_ptr = (VPTR) scalar_Acos (e_data (M));
    break;
    
  case MATRIX:
    *return_ptr = (VPTR) matrix_Acos (e_data (M));
    break;

  default:
    remove_tmp_destroy (M);
    error_1 ("acos: invalid argument", 0);
    break;
  }

  remove_tmp_destroy (M);
  return;
}

/* **************************************************************
 * tangent function.
 * ************************************************************** */
void
Tan (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M;

  /* Check n_args */
  if (n_args != 1)
    error_1 ("tan: 1 argument allowed", 0);

  M = bltin_get_numeric ("tan", d_arg, 1);
  switch (e_type (M))
  {
  case SCALAR:
    *return_ptr = (VPTR) scalar_Tan (e_data (M));
    break;
    
  case MATRIX:
    *return_ptr = (VPTR) matrix_Tan (e_data (M));
    break;

  default:
    remove_tmp_destroy (M);
    error_1 ("tan: invalid argument", 0);
    break;
  }

  remove_tmp_destroy (M);
  return;
}

/* **************************************************************
 * arc-tangent function.
 * ************************************************************** */
void
Atan (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  ListNode *M;
  
  /* Check n_args */
  if (n_args != 1)
    error_1 ("atan: 1 argument allowed", 0);

  M = bltin_get_numeric ("atan", d_arg, 1);
  switch (e_type (M))
  {
  case SCALAR:
    *return_ptr = (VPTR) scalar_Atan (e_data (M));
    break;
    
  case MATRIX:
    *return_ptr = (VPTR) matrix_Atan (e_data (M));
    break;

  default:
    remove_tmp_destroy (M);
    error_1 ("atan: invalid argument", 0);
    break;
  }

  remove_tmp_destroy (M);
  return;
}
