/* scop1.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1993  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef SCALAR_OP1_H
#define SCALAR_OP1_h

#include "scalar.h"

extern Scalar *scalar_Add _PROTO ((Scalar * s1, Scalar * s2));
extern Scalar *scalar_Subtract _PROTO ((Scalar * s1, Scalar * s2));
extern Scalar *scalar_Multiply _PROTO ((Scalar * s1, Scalar * s2));
extern Scalar *scalar_Divide _PROTO ((Scalar *, Scalar *));
extern Scalar *scalar_Exp _PROTO ((Scalar *));
extern Scalar *scalar_Pow _PROTO ((Scalar *, Scalar *));

extern Scalar *scalar_ChangeSign _PROTO ((Scalar * scalar));

extern Scalar *scalar_Abs _PROTO ((Scalar * s));
extern Scalar *scalar_Log _PROTO ((Scalar * s));
extern Scalar *scalar_Log10 _PROTO ((Scalar * s));

extern Scalar *scalar_Cos _PROTO ((Scalar * s));
extern Scalar *scalar_Sin _PROTO ((Scalar * s));
extern Scalar *scalar_Tan _PROTO ((Scalar * s));
extern Scalar *scalar_Acos _PROTO ((Scalar * s));
extern Scalar *scalar_Asin _PROTO ((Scalar * s));
extern Scalar *scalar_Atan _PROTO ((Scalar * s));

extern Scalar *scalar_Sqrt _PROTO ((Scalar * s));
extern Scalar *scalar_Int _PROTO ((Scalar * s));
extern Scalar *scalar_Ceil _PROTO ((Scalar * s));
extern Scalar *scalar_Floor _PROTO ((Scalar * s));
extern Scalar *scalar_Round _PROTO ((Scalar * s));
extern Scalar *scalar_Inv _PROTO ((Scalar * s));
extern Scalar *scalar_Mod _PROTO ((Scalar * s1, Scalar * s2));

extern double scalar_eq _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_ne _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_lt _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_le _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_gt _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_ge _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_and _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_or _PROTO ((Scalar * s1, Scalar * s2));
extern double scalar_not _PROTO ((Scalar * s));

#endif /* SCALAR_OP1_H */
