#
# Test dltest2
#

rfile ode23
rfile ode4

#
# Link in the rhs function (builtin)
#

vdpol = dlopen("./dltest2", "VDPolEq")

#
# Create a user-function equivilent
#

uvdpol = function ( t , x ) 
{
  local(xdot);

  xdot[1;1] = x[1] * (1 - x[2]^2) - x[2];
  xdot[2;1] = x[1];
  return xdot;
};

t0 = 0;
tf = 100;
x0 = [0; 0.25];

tic();
out = ode (vdpol, t0, tf, x0);
printf ("DL ode vdpol time = %f\n", toc());

tic();
out = ode (uvdpol, t0, tf, x0);
printf ("UF ode vdpol time = %f\n", toc());

tic();
out23 = ode23 (vdpol, t0, tf, x0);
printf ("DL ode23 vdpol time = %f\n", toc());

tic();
out23 = ode23 (vdpol, t0, tf, x0);
printf ("UF ode23 vdpol time = %f\n", toc());

