/* btree.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef BTREE_H
#define BTREE_H

#include "rlab.h"
#include "listnode.h"

#include <stdio.h>

struct _btree
{
  int type;
  char *name;
  int numNodes;
  ListNode *root_node;
};

typedef struct _btree Btree;

extern Btree *btree_Create _PROTO ((void));
extern void btree_Destroy _PROTO ((Btree *));
extern void btree_DestroyExcept _PROTO ((Btree *, int));

extern ListNode *btree_AddNode _PROTO ((Btree *, ListNode *));
extern ListNode *btree_FindNode _PROTO ((Btree *, char *));
extern ListNode *btree_FindNodeR _PROTO ((Btree *, ListNode *));

extern void btree_Print _PROTO ((Btree *, FILE * fn));
extern void btree_Write _PROTO ((Btree *, FILE * fn));
extern Btree *btree_Read _PROTO ((FILE * fn));

extern Btree *btree_CopyTree _PROTO ((Btree * root));
extern void btree_SetName _PROTO ((Btree *, char *));
extern char *btree_GetName _PROTO ((Btree *));
extern int btree_GetNumNodes _PROTO ((Btree *));
extern int btree_GetRealNumNodes _PROTO ((Btree *));


#endif /* BTREE_H */
