/* bl.h */

/*
 * Defines, and declarations for a
 * C => fortran, RLaB => BLAS interface.
 */

#ifndef RLAB_BL_H
#define RLAB_BL_H

#include "fi.h"

#ifdef HAVE_FORTRAN_UND_BACK

#define RSWAP rswap_
#define RGEMM rgemm_
#define XGEMM xgemm_

#endif

#ifdef HAVE_FORTRAN_UND_FRONT

#define RSWAP _rswap
#define RGEMM _rgemm
#define XGEMM _xgemm

#endif

#ifdef HAVE_FORTRAN_UPPERCASE
/* Do nothing, the existing code is OK */
#endif

#ifdef HAVE_FORTRAN_LOWERCASE

#define RSWAP rswap
#define RGEMM rgemm
#define XGEMM xgemm

#endif

extern F_INT RSWAP ();
extern F_INT RGEMM ();
extern F_INT XGEMM ();

#endif  /* RLAB_BL_H */
