##############################################################################
#
# Dependencies for plplot package.
#
# $Id: cf_depend.m4,v 1.22 1994/05/26 19:24:18 mjl Exp $
#
# $Log: cf_depend.m4,v $
# Revision 1.22  1994/05/26  19:24:18  mjl
# Fixes to account for consolidation of HP plotter drivers.
#
# Revision 1.21  1994/05/24  20:32:37  mjl
# Added build of "pltek" to default build list.
#
# Revision 1.20  1994/05/24  19:52:22  mjl
# Now pass the flags $(BIN_DIRFLAG), $(LIB_DIRFLAG), and $(TCL_DIRFLAG),
# for those files with a need to know.
#
# Revision 1.19  1994/05/14  05:45:55  mjl
# Fixed the hacked rule for building xwin.o under AIX.
#
# Revision 1.18  1994/05/09  18:01:54  furnish
# Hack to know about itcl.
#
# Revision 1.17  1994/05/07  03:30:19  mjl
# Removed obsolete dependency on pltk.o.
#
# Revision 1.16  1994/05/07  03:22:31  mjl
# Added some missing dependencies.  I know, I know.
#
# Revision 1.15  1994/04/18  19:23:29  furnish
# Added new function Pltk_Init to allow users to easily construct PLPLOT
# enhanced application specific extended wishen.  Works great, needs advert.
#
# Revision 1.14  1994/04/11  19:00:07  furnish
# Hack to know about Tk demos.
#
# Revision 1.13  1994/04/08  12:22:58  mjl
# Added dependency for LJIIp driver, new example program.
#
# Revision 1.12  1994/03/30  07:24:12  mjl
# Removed gratuitous -I option.  Changed x14f to x16f since it is for the
# same purpose as x16c -- eventually x14f and x15f may be written.
#
# Revision 1.11  1994/03/23  21:35:33  mjl
# Eliminated plctest.[co] dependencies and added new example programs.
#
# Revision 1.10  1994/03/22  23:18:25  furnish
# Get the Tk plframe widget code into the library if using Tk.
#
# Revision 1.9  1994/02/08  04:39:05  mjl
# Updated to use new macros for dealing with busted optimizers.
#
# Revision 1.8  1994/01/18  10:16:59  mjl
# Change to please Alpha/OSF linker.
#
# Revision 1.7  1994/01/15  17:31:30  mjl
# Added dependency and build rule for new file tcpip.c and fixed
# dependencies of files that now depend on pdf.h.
#
# Revision 1.6  1993/12/15  09:07:36  mjl
# Changes to support Tcl-DP use in TK driver.
#
# Revision 1.5  1993/12/08  06:22:00  mjl
# Fixes for the font building code and the inclusion of plplotX.h.
#
##############################################################################

# Object file macros
# Main sources.

OBJ =	\
	pdfutils.o \
	plargs.o \
	plbox.o \
	plcont.o \
	plcore.o \
	plctrl.o \
	plcvt.o \
	pldtik.o \
	plfill.o \
	plfont.o \
	plhist.o \
	plline.o \
	plot3d.o \
	plpage.o \
	plsdef.o \
	plshade.o \
	plstream.o \
	plstring.o \
	plsym.o \
	pltick.o \
	plvpor.o \
	plwind.o 

# Support files for font generators.

FONT_OBJ = \
	font01.o \
	font02.o \
	font03.o \
	font04.o \
	font05.o \
	font06.o \
	font07.o \
	font08.o \
	font09.o \
	font10.o \
	font11.o

# C & Fortran stubs for linking Plplot to Fortran.

ifdef({NO_FORTRAN},{

CSTUB_OBJ = 
FSTUB_OBJ =

},{

CSTUB_OBJ = \
	sc3d.o \
	sccont.o \
	scstubs.o

FSTUB_OBJ = \
	strutil.o \
	sfstubs.o 
})

# System-specific files.

# TK

TK_OBJ = \
	tk.o \
	tkshell.o \
	tcpip.o \
	plframe.o \
	plr.o

# TK server

SERVER_OBJ = \
	plserver.o 

# Amiga

AMIGA_OBJ = \
	pla_wn.o \
	pla_pr.o \
	pla_iff.o \
	pla_menu.o \
	plsupport.o 

# Drivers

DRIVERS_OBJ = \
	if_tk({$(TK_OBJ)}) \
	dg300.o \
	hpgl.o \
	impress.o \
	ljiip.o \
	ljii.o \
	next.o \
	null.o \
	plbuf.o \
	plmeta.o \
	ps.o \
	tek.o \
	xfig.o \
	xwin.o

##############################################################################
#
# Targets
# The default is now to make all the object libraries, plrender, and
# plserver (if the TK driver is being used).  Other targets:
#
#	libs		Object libraries
#	plrender	Metafile viewer
#	plserver	Renderer for Tk/DP driver 
#	pltek		Renderer for tek files
#	cdemos		All the C demos
#	fdemos		All the Fortran demos
#	x??[cf]		Demo number ??, C or fortran version
#	clean		Cleans up demo executables, output files
#	realclean	Cleans up object files, soft-links
#	install		Installs files user will need into public location

default: plplotP.h plrender if_tk({plserver}) pltek libs

everything: default

libs:	$(PLLIB)

##############################################################################
#
# Plot libraries.
#
# Note -- don't use ld libraries but ar libraries instead.
# Libraries created by ld cause grief on some systems because sometimes
# (reason unknown) a structure that needs to be initialized is not
# (happens on A/IX, VMS).  

if_unix({
$(PLLIB):	$(OBJ) $(DRIVERS_OBJ) $(CSTUB_OBJ) $(FSTUB_OBJ)
	-rm $(PLLIB)
	$(BUILD) $(PLLIB) $(OBJ) $(DRIVERS_OBJ) $(CSTUB_OBJ) $(FSTUB_OBJ)
	if_ranlib({ranlib $(PLLIB)},{if_alphaosf({ar ts $(PLLIB)})})
})
if_amiga({
$(PLLIB):	GST $(OBJ) $(DRIVERS_OBJ) $(AMIGA_OBJ)
	skshbin:join $(OBJ)         t:plobj.lib
	skshbin:join $(DRIVERS_OBJ) t:pldrivers.lib
	skshbin:join $(AMIGA_OBJ)   t:plamiga.lib
	skshbin:join t:pldrivers.lib t:plobj.lib t:plamiga.lib $(PLLIB)
	-delete t:plobj.lib t:pldrivers.lib t:plamiga.lib
})

##############################################################################
#
# Font files.
# Note it is no longer necessary to actually make these since as of
# PLPLOT 4.99a the font files are portable.
#
# sfont - standard font
# xfont - extended fonts

fonts:	sfont xfont

sfont:	$(PLFNT_PATH)plstnd5.fnt
xfont:	$(PLFNT_PATH)plxtnd5.fnt

$(PLFNT_PATH)plstnd5.fnt: stndfont.o pdfutils.o $(FONT_OBJ)
	$(LDC) $(LDC_FLAGS) -o stndfont \
		 stndfont.o pdfutils.o $(FONT_OBJ) $(LDC_PATH) $(LDC_LIBS)
	-./stndfont
	mv *.fnt $(PLFNT_DIR)

$(PLFNT_PATH)plxtnd5.fnt: xtndfont.o pdfutils.o $(FONT_OBJ)
	$(LDC) $(LDC_FLAGS) -o xtndfont \
		xtndfont.o pdfutils.o $(FONT_OBJ) $(LDC_PATH) $(LDC_LIBS)
	-./xtndfont
	mv *.fnt $(PLFNT_DIR)

##############################################################################
#
# Object file dependencies.

# source files

plargs.o:	plplotP.h plplot.h pdf.h plstream.h plargs.c
plbox.o:	plplotP.h plplot.h plbox.c 
plcont.o:	plplotP.h plplot.h plcont.c 
plcvt.o:	plplotP.h plplot.h plcvt.c 
pldtik.o:	plplotP.h plplot.h pldtik.c 
plfill.o:	plplotP.h plplot.h plfill.c 
plhist.o:	plplotP.h plplot.h plhist.c 
plline.o:	plplotP.h plplot.h plline.c 
plot3d.o:	plplotP.h plplot.h plot3d.c 
plpage.o:	plplotP.h plplot.h plpage.c 
plsdef.o:	plplotP.h plplot.h plsdef.c 
plshade.o:	plplotP.h plplot.h plshade.c 
plstream.o:	plplotP.h plplot.h pdf.h plstream.h plstream.c
plstring.o:	plplotP.h plplot.h plstring.c 
plsym.o:	plplotP.h plplot.h plsym.c 
pltick.o:	plplotP.h plplot.h pltick.c 
plvpor.o:	plplotP.h plplot.h plvpor.c 
plwind.o:	plplotP.h plplot.h plwind.c 
pdfutils.o:	plplotP.h plplot.h pdf.h pdfutils.c

# C language stubs for linking Plplot to Fortran.

sc3d.o:		plstubs.h plplotP.h plplot.h sc3d.c
scstubs.o:	plstubs.h plplotP.h plplot.h scstubs.c

# Optimizer on SX-3 makes bogus code here.

if_sx({
sccont.o:	plstubs.h plplotP.h plplot.h sccont.c
	$(CC) $(CC_FLAGS_NOOPT) sccont.c
},{
sccont.o:	plstubs.h plplotP.h plplot.h sccont.c
})

# Fortran language stubs for linking Plplot to Fortran.

strutil.o:	strutil.f
sfstubs.o:	sfstubs.f
sfstubs.f:	sfstubs.fm4 fmacs.m4

# Amiga

if_amiga({

pla_pr.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h plamiga.h \
		pla_pr.c
pla_iff.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h plamiga.h \
		pla_iff.c
pla_menu.o:	plplotP.h plplot.h plamiga.h pla_menu.c
plsupport.o:	plplotP.h plplot.h plamiga.h plsupport.c
pla_wn.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h plamiga.h \
		pla_wn.c

ifdef({GST},{
GST :		plplotP.h plplot.h plamiga.h
	gst unload GST
	$(CC) makegst GST $(CC_FLAGS) $(PLDEVICES) pla_gstskel.c
})
})

##############################################################################
#
# Explicit rules
#
# plctrl.c needs to know the bin directory for exec'ing plserver
# plfont.c needs to know the lib directory for its font files

plctrl.o:	plplotP.h plplot.h plctrl.c 
	$(CC) $(CC_FLAGS) $(BIN_DIRFLAG) plctrl.c

plfont.o:	plplotP.h plplot.h pdf.h plfont.c 
	$(CC) $(CC_FLAGS) $(LIB_DIRFLAG) plfont.c

# plcore.c and all the drivers need to know $(PLDEVICES).  The guts
# of the driver routine are not compiled if its name is not present in
# the device list.  You may want to leave drivers for specific systems
# (Amiga, MS-DOS, OS/2, etc) out of this list.

plcore.o:	plplotP.h plplot.h plcore.h drivers.h pdf.h plstream.h \
		plcore.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) plcore.c

dg300.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h dg300.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) dg300.c

hpgl.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h hpgl.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) hpgl.c

impress.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h impress.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) impress.c

ljii.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h ljii.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) ljii.c

ljiip.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h ljiip.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) ljiip.c

next.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h next.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) next.c

null.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h null.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) null.c

ps.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h ps.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) ps.c

tek.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h tek.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) tek.c

plbuf.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h metadefs.h \
		plbuf.c
	$(CC) $(CC_FLAGS) plbuf.c

plmeta.o:	plplotP.h plplot.h drivers.h pdf.h plstream.h metadefs.h \
		plmeta.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) plmeta.c

xfig.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h xfig.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) xfig.c

# Optimizer under AIX 3.2.3 bogues out here.

if_aix({
xwin.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h plplotX.h xwin.c
	$(CC) $(CC_FLAGS_NOOPT) $(PLDEVICES) xwin.c
},{
xwin.o:		plplotP.h plplot.h drivers.h pdf.h plstream.h plplotX.h xwin.c
	$(CC) $(CC_FLAGS) $(PLDEVICES) xwin.c
})

# TK driver

tk.o:		plserver.h plplotTK.h plplotX.h plplotP.h plplot.h drivers.h \
		pdf.h plstream.h metadefs.h plevent.h tk.c
	$(CC) $(CC_FLAGS) DEF_TK() DEF_DP() tk.c

tkshell.o:	plserver.h plplotTK.h plplotX.h plplotP.h plplot.h pdf.h \
		plstream.h tkshell.c
	$(CC) $(CC_FLAGS) $(TCL_DIRFLAG) DEF_TK() DEF_DP() tkshell.c

tcpip.o:	plserver.h plplotTK.h plplotX.h plplotP.h plplot.h pdf.h \
		plstream.h tcpip.c
	cc $(CC_FLAGS) DEF_TK() DEF_DP() tcpip.c

##############################################################################
#
# Utility programs.

plrender.o:	plplotP.h plplot.h metadefs.h pdf.h plrender.c

pltek:		pltek.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) pltek.o $(PLLIB_LDC) $(TO) $@ \
		$(LDC_PATH) $(LDC_LIBS)

plrender:	$(PLLIB) plrender.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) plrender.o $(PLLIB_LDC) $(TO) $@ \
		$(LDC_PATH) $(LDC_LIBS)

plserver.o:	plserver.h plplotP.h plplot.h pdf.h plstream.h plserver.c
	$(CC) $(CC_FLAGS) -I$(TK_INCDIR) DEF_TK() DEF_DP() \
		plserver.c

plframe.o:	plserver.h plplotP.h plplot.h pdf.h plstream.h plplotX.h \
		plframe.c
	$(CC) $(CC_FLAGS) -I$(TK_INCDIR) plframe.c

plr.o:		plserver.h plplotTK.h plplotX.h plplotP.h plplot.h pdf.h \
		plstream.h metadefs.h plevent.h plr.c
	$(CC) $(CC_FLAGS) -I$(TK_INCDIR) plr.c

plserver:	$(PLLIB) $(SERVER_OBJ)
	$(LDC) $(LDC_FLAGS) $(STARTUP) $(SERVER_OBJ) $(PLLIB_LDC) $(TO) $@ \
		$(LDC_PATH) $(LDC_LIBS)

##############################################################################
#
# Example programs, in C.

CDEMOS= x01c x02c x03c x04c x05c x06c x07c x08c x09c x10c x11c \
	x12c x13c x14c x15c x16c x17c tutor

cdemos:	$(CDEMOS)

x01c:	$(PLLIB) x01c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x01c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x02c:	$(PLLIB) x02c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x02c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x03c:	$(PLLIB) x03c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x03c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x04c:	$(PLLIB) x04c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x04c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x05c:	$(PLLIB) x05c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x05c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x06c:	$(PLLIB) x06c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x06c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x07c:	$(PLLIB) x07c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x07c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x08c:	$(PLLIB) x08c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x08c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x09c:	$(PLLIB) x09c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x09c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x10c:	$(PLLIB) x10c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x10c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x11c:	$(PLLIB) x11c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x11c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x12c:	$(PLLIB) x12c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x12c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x13c:	$(PLLIB) x13c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x13c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x14c:	$(PLLIB) x14c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x14c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x15c:	$(PLLIB) x15c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x15c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x16c:	$(PLLIB) x16c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x16c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

x17c:	$(PLLIB) x17c.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) x17c.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

tutor:	$(PLLIB) tutor.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) tutor.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

##############################################################################
#
# Example programs, in Fortran.

FDEMOS= x01f x02f x03f x04f x05f x06f x07f x08f x09f x10f x11f \
	x12f x13f x16f

fdemos:	$(FDEMOS)

x01f:	$(PLLIB) x01f.o
	$(LDF) $(LDF_FLAGS) x01f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x02f:	$(PLLIB) x02f.o
	$(LDF) $(LDF_FLAGS) x02f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x03f:	$(PLLIB) x03f.o
	$(LDF) $(LDF_FLAGS) x03f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x04f:	$(PLLIB) x04f.o
	$(LDF) $(LDF_FLAGS) x04f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x05f:	$(PLLIB) x05f.o
	$(LDF) $(LDF_FLAGS) x05f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x06f:	$(PLLIB) x06f.o
	$(LDF) $(LDF_FLAGS) x06f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x07f:	$(PLLIB) x07f.o
	$(LDF) $(LDF_FLAGS) x07f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x08f:	$(PLLIB) x08f.o
	$(LDF) $(LDF_FLAGS) x08f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x09f:	$(PLLIB) x09f.o
	$(LDF) $(LDF_FLAGS) x09f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x10f:	$(PLLIB) x10f.o
	$(LDF) $(LDF_FLAGS) x10f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x11f:	$(PLLIB) x11f.o
	$(LDF) $(LDF_FLAGS) x11f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x12f:	$(PLLIB) x12f.o
	$(LDF) $(LDF_FLAGS) x12f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x13f:	$(PLLIB) x13f.o
	$(LDF) $(LDF_FLAGS) x13f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)

x16f:	$(PLLIB) x16f.o
	$(LDF) $(LDF_FLAGS) x16f.o \
	       $(PLLIB_LDF) $(TO) $@ $(LDF_PATH) $(LDF_LIBS)


##############################################################################
#
# TK example programs.

TKDEMOS = xtk01 xtk02

tkdemos: $(TKDEMOS)

xtk01:  $(PLLIB) xtk01.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) xtk01.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)

xtk02:  $(PLLIB) xtk02.o
	$(LDC) $(LDC_FLAGS) $(STARTUP) xtk02.o \
	       $(PLLIB_LDC) $(TO) $@ $(LDC_PATH) $(LDC_LIBS)
