/* $Id: x07c.c,v 1.8 1994/03/30 07:21:51 mjl Exp $
 * $Log: x07c.c,v $
 * Revision 1.8  1994/03/30  07:21:51  mjl
 * Changes to all C example programs: special handling for malloc re: header
 * files eliminated, include of stdio.h and stdlib.h eliminated (now done
 * by plplot.h), include of "plplot.h" changed to <plplot.h> to enable
 * simpler builds by the general user, some cleaning up also.
 *
 * Revision 1.7  1993/07/28  05:47:23  mjl
 * Some minor desuckification.
 *
 * Revision 1.6  1993/07/02  07:06:50  mjl
 * Changed window bounds to fit well within the graphics window (page).
 *
 * Revision 1.5  1993/02/22  23:16:15  mjl
 * Changed over to new style of initialization using plinit(), and added
 * function to parse plplot command line flags.
 *
 * Revision 1.4  1993/01/23  06:10:27  mjl
 * Instituted exit codes for all example codes.  Also deleted color functions
 * no longer supported (plancol).  Enhanced x09c to exploit new contour
 * capabilities.
*/

/* Displays the plotter symbols for PLSYM */

#ifdef MSDOS
#pragma message("Microsoft programmers are sissies.")
#pragma optimize("",off)
#endif

#include <plplot.h>

static int base[17] =
{0, 200, 500, 600, 700, 800, 900,
 2000, 2100, 2200, 2300, 2400, 2500, 2600, 2700, 2800, 2900};

int
main(int argc, char *argv[])
{
    char text[4];
    int i, j, k, l;
    PLFLT x, y;

/* Parse and process command line arguments */

    (void) plParseInternalOpts(&argc, argv, PL_PARSE_FULL);

/* Initialize plplot */

    plinit();

    plfontld(1);
    for (l = 0; l < 17; l++) {
	pladv(0);

/* Set up viewport and window */

	plcol(2);
	plvpor(0.15, 0.95, 0.1, 0.9);
	plwind(0.0, 1.0, 0.0, 1.0);

/* Draw the grid using plbox */

	plbox("bcgt", 0.1, 0, "bcgt", 0.1, 0);

/* Write the digits below the frame */

	plcol(15);
	for (i = 0; i <= 9; i++) {
	    sprintf(text, "%d", i);
	    plmtex("b", (PLFLT) 1.5, (0.1 * i + 0.05), (PLFLT) 0.5, text);
	}

	k = 0;
	for (i = 0; i <= 9; i++) {

/* Write the digits to the left of the frame */

	    sprintf(text, "%d", base[l] + 10 * i);
	    plmtex("lv", (PLFLT) 1.0, (0.95 - 0.1 * i), (PLFLT) 1.0, text);
	    for (j = 0; j <= 9; j++) {
		x = 0.1 * j + 0.05;
		y = 0.95 - 0.1 * i;

/* Display the symbols */

		plsym(1, &x, &y, base[l] + k);
		k = k + 1;
	    }
	}

	plmtex("t", (PLFLT) 1.5, (PLFLT) 0.5, (PLFLT) 0.5,
	       "PLPLOT Example 7 - PLSYM symbols");
    }
    plend();
    exit(0);
}
