/*
    This is the index set structure
 */
/*I "set/iset.h" I*/

#ifndef __ISET
#define __ISET
/* General index set */
typedef struct {
    int n, na, *idx;
    } ISet;

/* Since range with stride */    
typedef struct {
    int is, ie, stride;
    } ISetRange;

/* Direct product of strides (up to 5 dimensions) */    
typedef struct {
    int ndim, is[5], ie[5], stride[5];
    } ISetProduct;

/* General index set (multiple representations).  Includes functions to
    manipulate them.  Not yet implemented */    
typedef struct {
    int type;
    union { ISet idxset; ISetRange ir; ISetProduct ip; } x;
    /* Question: should these ops be in a single ISetOps structure (advantage
       is more modular, share ops; disadvantage is additional pointer) */
    void (*Union)(), (*Intersection)(), (*Scatter)(), (*Gather)(),
         (*Compl_intersect)(), (*Destroy)();
    } ISetG;     /* G for general ISet */
    
/* Routines */
extern ISet *ISAlloc(), *ISCreateFromData();
extern ISetRange *ISRAlloc();
extern void ISDestroy(), ISUnion(), ISIntersection(), ISCompIntersection(),
 	    ISCompress(), ISDisableCache();
extern int  ISEnableCache();

/*M 
    ISSize - Return the number of elements in an index set

    Synopsis:
    int ISSize(is)
    ISet *is;

    Input parameter:
.   is - index set

M*/
#define ISSize(is) ((is)->n)

/*M
    ISIdx - Return a pointer to an integer array containing the indices

    Synopsis:
    int *ISIdx(is)
    ISet *is;

    Input parameter:
.   is - index set

M*/
#define ISIdx(is) ((is)->idx)

/* Eventually add
    ISCompressRange - generate range from set
    ISReAlloc       - allocate for a larger set
 */

/*M
    ISScatterD - Scatter doubles given an index set

    Synopsis:
    void ISScatterD( is, vin, vout )
    ISet   *is;
    double *vin, *vout;

    Input Parameters:
.   is - Index set
.   vin,vout - vout(is) <- vin    
M*/ 
#define ISScatterD(is,vin,vout){register int __i, *__p=(is)->idx, __n=(is)->n;\
   for (__i=0; __i<__n; __i++) vout[__p[__i]] = vin[__i]; }
#define ISRScatterD(is,vin,vout) {\
   register int __i, __e=(is)->ie, __incr=(is)->stride;\
   for (__i=(is)->is; __i <= __e; __i += __incr) vout[__i] = *vin++;
   
/*M
    ISGatherD - Gather doubles given an index set

    Synopsis:
    void ISGatherD( is, vin, vout )
    ISet   *is;
    double *vin, *vout;

    Input Parameters:
.   is - Index set
.   vin,vout - vout <- vin(is)    
M*/ 
#define ISGatherD(is,vin,vout) {register int __i, *__p=(is)->idx, __n=(is)->n;\
 for (__i=0; __i<__n; __i++) vout[__i] = vin[__p[__i]]; }
#define ISRGatherD(is,vin,vout) {\
   register int __i, __e=(is)->ie, __incr=(is)->stride;\
   for (__i=(is)->is; __i <= __e; __i += __incr) *vout++ = vin[__i];

/*M
    ISScatterI - Scatter ints given an index set

    Synopsis:
    void ISScatterI( is, vin, vout )
    ISet   *is;
    int    *vin, *vout;

    Input Parameters:
.   is - Index set
.   vin,vout - vout(is) <- vin    
M*/ 
#define ISScatterI(is,vin,vout){register int __i, *__p=(is)->idx, __n=(is)->n;\
   for (__i=0; __i<__n; __i++) vout[__p[__i]] = vin[__i]; }

/*M
    ISGatherI - Gather ints given an index set

    Synopsis:
    void ISGatherI( is, vin, vout )
    ISet   *is;
    int    *vin, *vout;

    Input Parameters:
.   is - Index set
.   vin,vout - vout <- vin(is)    
M*/ 
#define ISGatherI(is,vin,vout) {register int __i, *__p=(is)->idx, __n=(is)->n;\
 for (__i=0; __i<__n; __i++) vout[__i] = vin[__p[__i]]; }

#endif    
