#ifndef lint
static char SCCSid[] = "@(#) ./comm/sgray.c 07/23/93";
#endif

/*
   This file contains a routine to compute a "gray code" for sequences of
   arbitray length.  This mapping is optimal:

   If the length is even, then successive elements do differ by one bit.
   If the length is odd, then all except one element differs by one bit;

   the one exception differs by two bits from the preceding member.
*/
#define CM_MAX_GRAY 64

/*@
   PIcmgray - Computes an n term "gray code".
   
   input parameter:
.   n       - size of code to generate.

   output parameter:
.   g       - contains code.  Must be of size n (n+1 if n odd).
             g(0) == 0 always.
 Note: The idea for this algorithm is due to Doug Baxter
@*/
void PIcmgray( g, n )
int *g, n;
{
int     w[CM_MAX_GRAY];                 /* Workspace */
int     nn,                             /* Remainder to generate code for */
 	ln, 				/* current length of code */
	l, 				/* length of sequence being added */	
	k,                              /* l = 2**k */
	i, j;                           /* looping indices */
static int gray[64] = {
   0,    1,    3,    2,    6,    7,    5,    4,   12,   13,   15,   14,   10,
  11,    9,    8,   24,   25,   27,   26,   30,   31,   29,   28,   20,   21,
  23,   22,   18,   19,   17,   16,   48,   49,   51,   50,   54,   55,   53,
  52,   60,   61,   63,   62,   58,   59,   57,   56,   40,   41,   43,   42,
  46,   47,   45,   44,   36,   37,   39,   38,   34,   35,   33,   32 };
  
ln  = 0;
nn  = n;
if ( nn & 0x1 )
    nn++;

while (nn > 0) {
    /* find largest contained sequence */
    l   = 1;    k   = 0;
    while (l + l <= nn) {
	l   = l + l;    k   += 1;
	}
    /* move existing sequence into work area */
    for (i=0; i<ln; i++) 
	w[i]    = g[i];

    /* generate new values */
    for (i=0; i<l; i++) 
	g[i]    = gray[i] + ln;

    /* must rearange the old values to make a valid code if there are any */
    if (ln > 0) {
	/* the next l-1 values are w(l-1)...w(1) */
	for (i=1; i<l; i++) 
	    g[l+i-1]    = w[l-i];
	/* the next l-1 values are w(2l-2)...w(l) */
	for (i=1; i<l; i++) 
	    g[2*l-2+i]  = w[2*l-1-i];
	/* g now gets the rest of the values in w */
	for (i=1; i<=ln-2*l+1; i++) 
	    g[3*l-3+i]  = w[2*l-2+i];
	/* finally, the end of g gets w(0) */
	g[ln+l-1]   = w[0];
	}
    ln  += l;
    nn  -= l;
    }

/* now, must handle odd sequences. */
if ( n & 0x1 ) {
    for (i=0; i<=n; i++) {
	if (g[i] == n)
	    break;
        }
    for (j=i; j<n; j++) 
	g[j]    = g[j+1];
    }
/* finally, make sure that g(0) == 0 */
if (g[0] != 0) {
    for (i=0; i<n; i++) {
	w[i]    = g[i];
	if (g[i] == 0)
	    j   = i;
	}
    for (i=0; i<n; i++) 
	g[i]    = w[ (i+j) % n ];
    }
}
