#ifndef LINT
static char SCCSid[] = "@(#) ./comm/save/csync.c 07/23/93";
#endif

/*
    This file contains routines to provide the raw material necessary
    for a posteriori adjustment of the clocks
 */
#include "tools.h"

/* Turn off MOST of the event logging */
#ifndef LOGCOMMDISABLE
#define LOGCOMMDISABLE
#endif

#include "comm/comm.h"

#ifdef USE_ALOG
#ifdef ALOG_LOG
#undef ALOG_LOG
#endif
#include "alog/alog.h"
#define LOGMARK(a,b) ALOG_LOG(MYPROCID,a,b,(char *)0);
#else
#ifdef BLOG_LOG
#undef BLOG_LOG
#endif
#include "blog/blog.h"
#define LOGMARK(a,b) BLOG_LOGI(a,b)
#endif

/*
    PISync1 - routine to generate a pair-exchange used for computing
    clock offsets
 */
PISync1( nbr, ismaster, mtype )
int nbr, ismaster, mtype;
{
char *msgs, *msgr;
int  size;

size = 1;
MSGALLOCSEND( msgs, size, char );
MSGALLOCRECV( msgr, size, char );
if (ismaster) {
    SENDSYNC( mtype, msgs, size, nbr, MSG_OTHER );
    RECVSYNC( mtype, msgr, size, MSG_OTHER );
    LOGMARK( EVENT_PAIR_A1, nbr );
    SENDSYNC( mtype, msgs, size, nbr, MSG_OTHER );
    RECVSYNC( mtype, msgr, size, MSG_OTHER );
    LOGMARK( EVENT_PAIR_A2, nbr );
    }
else {    
    RECVSYNC( mtype, msgr, size, MSG_OTHER );
    SENDSYNC( mtype, msgs, size, nbr, MSG_OTHER );
    RECVSYNC( mtype, msgr, size, MSG_OTHER );
    LOGMARK( EVENT_PAIR_B1, nbr );
    SENDSYNC( mtype, msgs, size, nbr, MSG_OTHER );
    }
MSGFREESEND( msgs );
MSGFREERECV( msgr );
}

/*
    PIAddOffsetPair0 - add clock offset events for the "Dunnigan"
    method (all processors exchange with processor 0)
 */
PIAddOffsetPair0( mtype )
int mtype;
{
int i;

if (MYPROCID == 0) {
    for (i=1; i<NUMNODES; i++)
        PISync1( i, 0, mtype + i );
    }
else
    PISync1( 0, 1, mtype + MYPROCID );
}

/*
   PIAddOffsetPair1 - use a tree to add offset events

   Note:  This could execute in 4 steps by using the fact that
   alternate levels of the tree can be running simultaneously.  For
   modust numbers of processors, this 2log(p) method won't be much
   slower, and is vastly easier to code.
 */
PIAddOffsetPair1( mtype )
int mtype;
{
int l_child, r_child, parent;

PISetTreeNodes( MYPROCID, NUMNODES, &l_child, &r_child, &parent );
/* For this, I need to know if I'm a left child or a right child.  I exploit
   the fact that left children are odd and right children are even */
if (l_child)
    PISync1( l_child, 0, mtype );
if (parent && (MYPROCID & 0x1))
    PISync1( parent, 0, mtype );

if (r_child)
    PISync1( r_child, 0, mtype + 10 );
if (parent && (!(MYPROCID & 0x1)))
    PISync1( parent, 1, mtype + 10 );
}


PIAddOffsetPair2( mtype )
int mtype;
{
int nbr;

nbr = MYPROCID ^ 0x1;
if (nbr < NUMNODES) 
    PISync1( nbr, !(MYPROCID & 0x1), mtype );
if (MYPROCID & 0x1)
    nbr = MYPROCID - 1;
else
    nbr = MYPROCID + 1;
if (nbr >= 0 && nbr < NUMNODES)
    PISync1( nbr, (MYPROCID & 0x1), mtype + 1 );
}
