/* 
   This is a main program that uses the standard argument-passing node
   specification to determine the hosts that would be used by a Chameleon
   program.  This is used for debugging the host table code and can be used
   to debug the node-finding process.
 */

#include <stdio.h>
#include "tools.h"
#include "comm/pgcomm/pgcomm.h"
#include <ctype.h>
#include "comm/htable/bhost.h"
#include "system/system.h"
#include "comm/hosts.h"
#ifndef __MSDOS__
#include <sys/time.h>
#else
struct timeval { unsigned long tv_usec, tv_sec; };
#endif

main( argc, argv )
int  argc;
char **argv;
{
return PIiFormHostList( &argc, argv );
}

/*
  Form the p4 procgroup file.  Return the file name
  where it was stashed.  Returns 0 if it failed to write the file.
 */
int PIiFormHostList( argc, argv )
int  *argc;
char **argv;
{
int       dbg, tim;
char      arch[20], pname[1024], pgm[1024], bname[31], *path, *archpath;
char      hostfname[1024], cwd[1024];
FILE      *fout;
int       nl, i, nnp;
HostTable *table,*utable;
int       np, cpu, mem, pf, niceval, fsec;
struct timeval maxtime;

SYGetResourceDefaults( &cpu, &mem, &pf, &niceval, &fsec );

/* determine base name of our, to be created, process group */
PIBaseName( argv[0],0,bname, 31 );
SYGetDayTime( &maxtime );
maxtime.tv_sec += fsec;
SYGetResourceLimits( argc, argv, &cpu, &mem, &pf, &maxtime, 1 );

/* Set defaults; get special parameters */
SYGetArchType( arch, 20 );
np  = 1;
dbg = 0;
SYArgsToResources( argc, argv, &np, &dbg, arch, pname );

/* We need a version that allows multiple uses of the "local" processor,
   and that allows forming the host table from the command line or a
   generic file */
if (PIiFormHostTable( &utable, &table, np-1, mem, cpu, pf, arch, bname, cwd, 
		      argc, &argv, "TOOLSHOSTS", DEFAULTTOOLSHOSTS ) != 0)
    return 0;

/* Find a location for the procgroup file */
/* Write out the actual file */
PIPrintHostTable( utable, stdout );
PIDestroyHostTable(utable);
PIDestroyHostTable(table);
return 0;
}
