#ifndef lint
static char SCCSid[] = "@(#) ./comm/pdebug.c 07/23/93";
#endif

/* 
   This file contains some routines to help in debugging parallel programs
 */

#include <stdio.h>            /*I <stdio.h> I*/
#include "tools.h"
#include "comm/comm.h"
#include "comm/procset.h"

/*@ 
   PSPrintProcset - Display a processor set in a simplified fashion

   Input Parameters:
.  ps - procset to display
.  form - format to use
$   form = 0 : line (give processor numbers)
$   form = 1 to numprocs : mesh of that dimenision (in x), with the 
            members marked with an *
.  fp - file pointer

   Note:
   A good value for form on a mesh of processors is the number of columns
   in the processor.  This gives a clear display of the processor set. 
@*/
void PSPrintProcset( ps, form, fp )
ProcSet *ps;
int     form;
FILE    *fp;
{
int  i, j, *nd, nn;
char *c;

nd = ps->node_nums;
nn = ps->npset;

if (form == 0) {
    for (i=0; i<nn; i++) fprintf( fp, "%d ", nd[i] );
    fputs( "\n", fp );
    }
else {
    c = MALLOC( PInumtids + 1 );   CHKPTR(c);
    for (i=0; i< PInumtids; i++) c[i] = ' ';
    c[PInumtids] = 0;
    for (i=0; i<nn; i++) {
	c[nd[i]] = '*';
	}
    for (j=PInumtids-form; j>=0; j-=form) {
	c[j+form] = 0;
	fputs( c + j, fp );
	fputs( "\n", fp );
	}
    FREE( c );
    }
}

/*@
   PSPrintProcsetDetails - Prints the full contents of the procset

   Input parameters:
.  ps  - procset to print
.  fp  - file to print to
@*/
void PSPrintProcsetDetails( ps, fp )
ProcSet *ps;
FILE    *fp;
{
fprintf( fp, "Mytid = %d, Numtids = %d\n", ps->myid, ps->nump );
fprintf( fp, "Tree: lchild = %d, rchild = %d, parent = %d, root = %d\n", 
	 ps->l_child, ps->r_child, ps->parent, ps->root );
fprintf( fp, "Ring: right = %d, left = %d\n", ps->right, ps->left );
fprintf( fp, "2-d mesh: nx = %d, ny = %d, n = %d, s = %d, e = %d, w = %d\n",
	 ps->nx, ps->ny, ps->north, ps->south, ps->east, ps->west );
fprintf( fp, "Ctxoffset = %d, procset name = %d\n", 
	 ps->ctxoff, ps->name );
fprintf( fp, "Number in set = %d, rank in set = %d\n", ps->npset, ps->lidx );
}
