#ifndef lint
static char SCCSid[] = "@(#) ./comm/mcomm/bvec.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/mcomm/mcomm.h"

/* Currently does not support xdr; we need to change that */

MSGBVEC *PIGetBvec( maxcnt )
int maxcnt;
{
MSGBVEC *bvec;

bvec     = NEW(MSGBVEC);    CHKPTRN(bvec);
bvec->BV = (struct iovec *)MALLOC( maxcnt * sizeof(struct iovec) );
           CHKPTRN(bvec->BV);
bvec->datatype = (int *)MALLOC( maxcnt * sizeof(int) );    
           CHKPTRN(bvec->datatype);
bvec->maxcnt = maxcnt;

return bvec;
}

void PIFreeBvec( bvec )
MSGBVEC *bvec;
{
FREE( bvec->BV );
FREE( bvec->datatype );
FREE( bvec );
}

PISendVSync( type, bvec, to, is_force )
int     type, to, is_force;
MSGBVEC *bvec;
{
int  i, nbytes;
char *buf, *p;

/* Compute size of buffer */
nbytes = 0;
for (i=0; i<bvec->cnt; i++) 
    nbytes += bvec->BV[i].iov_len;
MSGALLOCSEND(buf,nbytes,char);

/* Pack the buffer */
p  = buf;
for (i=0; i<bvec->cnt; i++) {
    MEMCPY(p,bvec->BV[i].iov_base,bvec->BV[i].iov_len);
    p += bvec->BV[i].iov_len;
    }

/* Send it */
if (is_force) {
    SENDSYNCFORCE(type,buf,nbytes,to,MSG_OTHER);
    }
else {
    SENDSYNC(type,buf,nbytes,to,MSG_OTHER);
    }

/* Free the buffer */
MSGFREESEND(buf);
}

PIRecvVSync( type, bvec, is_force )
int     type, is_force;
MSGBVEC *bvec;
{
int  i, nbytes;
char *buf, *p;

/* Compute size of buffer */
nbytes = 0;
for (i=0; i<bvec->cnt; i++) 
    nbytes += bvec->BV[i].iov_len;
MSGALLOCRECV(buf,nbytes,char);

if (is_force) {
    RECVSYNCFORCE(type,buf,nbytes,MSG_OTHER);
    }
else {
    RECVSYNC(type,buf,nbytes,MSG_OTHER);
    }

/* Unpack the buffer */
p  = buf;
for (i=0; i<bvec->cnt; i++) {
    MEMCPY(bvec->BV[i].iov_base,p,bvec->BV[i].iov_len);
    p += bvec->BV[i].iov_len;
    }

/* Free the buffer */
MSGFREERECV(buf);
}

/*ARGSUSED*/
/* Stubs for wait */
void PISendVWait(type,bvec,to,id,is_force)
int     type, to, id, is_force;
MSGBVEC *bvec;
{}
/*ARGSUSED*/
void PIRecvVWait(type,bvec,id,is_force)
int     type, id, is_force;
MSGBVEC *bvec;
{}

