#ifndef lint
static char SCCSid[] = "@(#) ./comm/io/pidebug.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"
#include <stdio.h>

/*@
    PIFPrintArraySpec - print a distributed array specifier
    
    Input Parameters:
.   fp - file pointer to write on
.   sz - array descriptor in PIArrayPart format
.   nd - number of dimensions

    Note: 
    For parallel processors, this must be called by every processor
    (each processor writes out its part of the sz array).
@*/    
void PIFPrintArraySpec( fp, sz, nd )
FILE        *fp;
PIArrayPart *sz;
int         nd; 
{
int i,j;

if (!fp) fp = stdout;
nd --;
for (i=0; i<=NUMNODES; i++) {
    if (GTOKEN(0,i)) {
	fprintf( fp, "\nprocessor: %d", MYPROCID);
	
	fprintf( fp, "\nGlobal size (mdim)    :");
	for (j=0; j<=nd; j++) 
	    fprintf( fp, "  %d", sz[j].mdim);
	
	fprintf( fp, "\nLocal length (ndim)   :");
	for (j=0; j<=nd; j++)
	    fprintf( fp, "  %d",sz[j].ndim);
	
	fprintf( fp, "\nLocal (gstart,gend)   :");
	for (j=0; j<=nd; j++)
	    fprintf( fp, "  (%d, %d)",sz[j].gstart,sz[j].gend);
	
	fprintf( fp, "\nRelative  (start,end) :");
	for (j=0; j<=nd; j++)
	    fprintf( fp, "  (%d, %d)",sz[j].start,sz[j].end);
	
	fprintf( fp, "\nLocal written         :");
	for (j=0; j<=nd; j++)
	    fprintf( fp, "  (%d, %d)", sz[j].gstart + sz[j].start,
		     sz[j].gstart + sz[j].end);
	fprintf( fp, "\n");
	fflush(fp);
	}
    }
}


