#ifndef lint
static char SCCSidI[] = "@(#) ./comm/initp4.c 07/23/93";
#endif

/* p4 specific routines */

static int P4ARGC, (*P4ROUTINE)();
static char **P4ARGV;
static int   p4argc;
static char  **p4argv;

#include <ctype.h>
#include "comm/htable/bhost.h"
#include "system/system.h"
#include "comm/hosts.h"

/* Hold the globals for p4 here */
int __P4FROM, __P4LEN, __P4TYPE;
int __P4SpinWait = 0;
int __P4NoPrealloc = 1;
int __P4MYTID = -1;
int __P4NUMTIDS = -1;
void PIWriteP4PG();
extern char *getenv();

/* This is used to find memory problems, probably having to do with the 
   hosts table */
#ifdef FOO
#define DBUGMEMORY(a) \
    {char buf[100]; sprintf( buf, "[%d] %s\n", __P4MYTID, a ); trvalid( buf );\
     fflush( stdout );}
#else
#define DBUGMEMORY(a)
#endif
      
/*
    p4exitall- terminate all processes in an execution (parallel exit)
    See init.c for a complete description of the interface.
 */
static void p4exitall(msg,rc)
char *msg;
int  rc;
{
p4_error( msg ? msg : "ExitAll", 0 );
}

/* 
   This routine converts a p4 version into a double value.
   If the value contains a letter modifier, that is added to the 
   end (as .01 * (letter - 'a' + 1) 
 */
static double p4versionvalue()
{
extern char *p4_version();
char   *p = p4_version(), *p1, c;
double val;

/* First, find the numeric part */
p1 = p;
while (*p1 && (isdigit(*p1) || *p1 == '.')) p1++;
c   = *p1;
*p1 = 0;
sscanf( p, "%lf", &val ); 
if (c != 0) 
       val += 0.01 * (c - 'a' + 1);

return val;
}

/*
   PIcall - Call a routine in a parellel execution mode.
   See init.c for a complete description of the interface.
 */
int PIcall( np, procgroup, pfname, routine, argc, argv )
int  np, argc;
char **procgroup, *pfname;
char **argv;
int  (*routine)();
{
int  i, amslave = 0, haspgfile = 0, hasport = 0;
char tmplate[1024];
int  wrotepgfile = 0;
FILE *fp;
int  fsec, hashelp = 0, rc;
double p4version;

P4ROUTINE = routine;

/* Set an initial choice of resource limits incase something goes wrong 
   before we're ready to set the final limits */
#ifdef rs6000
/* Allow for slow startups on the rs6000s (particularly the SP-1) */
SYGetDayTime( &maxtime );
maxtime.tv_sec += 600; 
SYSetResourceLimits( 100, 600, 1000, &maxtime );
SYSetResourceLimits( 100, 600, 1000, (void *)0 );
#else
SYGetDayTime( &maxtime );
maxtime.tv_sec += 120; 
SYSetResourceLimits( 10, 60, 1000, &maxtime );
SYSetResourceLimits( 10, 60, 1000, (void *)0 );
#endif

/* Set default resource limits */
SYGetResourceDefaults( &cpu, &mem, &pf, &niceval, &fsec );
SYGetDayTime( &maxtime );
maxtime.tv_sec += fsec;
/* Get the resource limits and remove them from the argument list 
   (note that the master will over-write these when the the slaves start) */
SYGetResourceLimits( &argc, argv, &cpu, &mem, &pf, &maxtime, 1 );
SYArgGetInt( &argc, argv, 1, "-nice", &niceval );

p4version = p4versionvalue();
/* 
   Copy the arguments.
   There is one special case:  we want -help to work as the user
   expects, not to give the p4 help message.  What we do is to 
   remove it if we find it.
 */
p4argv    = (char **) MALLOC( (argc + 5) * sizeof(char *) );
if (!p4argv) {
    fprintf( stderr, "Can not create argument list for p4_initenv\n" );
    return;
    }
p4argc = 0;
for (i=0; i<argc; i++) {
    if (p4version > 1.22) {
	if (strcmp( "-p4amslave",   argv[i] ) == 0) amslave   = 1;
	if (strcmp( "-p4pg",        argv[i] ) == 0) haspgfile = 1;
	if (strcmp( "-p4ssport",    argv[i] ) == 0) 
	    hasport = atoi( argv[i+1] );
	}
    else {
	if (strcmp( "-amp4slave", argv[i] ) == 0) amslave   = 1;
	if (strcmp( "-pg",        argv[i] ) == 0) haspgfile = 1;
	if (strcmp( "-ssport",    argv[i] ) == 0) 
	    hasport = atoi( argv[i+1] );
	}
    if (strcmp( "-help",      argv[i] ) == 0) hashelp = 1;
    else
	p4argv[p4argc++] = argv[i];
    }
/* For backend processors, we can automagically add the -amp4slave option */
#ifdef intelnx
if (!amslave && mynode() != 0) {
    if (p4version > 1.22) {
	p4argv[p4argc++] = "-p4amslave";
	}
    else {
	p4argv[p4argc++] = "-amp4slave";
	}
    amslave          = 1;
    }
#endif

DBUGMEMORY("Before processing pg file");
if (!amslave && !haspgfile) {
    if (p4version > 1.22) {
	p4argv[p4argc++] = "-p4pg";
	}
    else {
	p4argv[p4argc++] = "-pg";
	}
    p4argc++;          /* leave room for the procgroup name */
    if (pfname) 
	p4argv[p4argc-1] = pfname;
    else {
	/* See the notes at the end of this file about an alternate
	   approach for this */
#if defined(intelnx) || defined(cm5)
	wrotepgfile = PIiFormP4PGFileForBackend( &argc, argv, np, tmplate );
#else	
	wrotepgfile = PIiFormP4PGFile( &argc, argv, tmplate, 
				       np, mem, cpu, pf );
#endif
	DBUGMEMORY("Formed pg file");
	if (!wrotepgfile) {
	    fprintf( stderr, "Could not create p4 procgroup file\n" );
	    return;
	    }
	pfname           = tmplate;
	p4argv[p4argc-1] = pfname;
	}
    }
/* printf( "About to call p4_initenv; amslave = %d\n", amslave ); */
p4_initenv( &p4argc, p4argv );
DBUGMEMORY("After p4_initenv");

/* Set up usage controls and default signal handlers.  p4 catches SIGINT;
   we look here for other exceptions. 
   Users may override these by resetting them in the slave process.
   Q: Should these go just before p4_initenv? */
SYSetExitAll(p4exitall);
SYSetDefaultSignals( (void (*)())0 );

/* Pass only remaining args to other routines */
P4ARGC    = argc;
P4ARGV    = argv;

DBUGMEMORY("About to create procgroup");
if (p4_get_my_id() == 0) {
    /* p4_dprintf( "Creating procgroup\n" ); */
#ifndef FOO
    p4_create_procgroup();
#else
#include "/home/lusk/p4-1.2b/lib/p4.h"
    if ((p4_local->procgroup = read_procgroup()) == NULL)
	return (-1);
    DBUGMEMORY("About to call p4_startup");
    p4_startup(p4_local->procgroup);
#endif
    }
DBUGMEMORY("Created procgroup");
__P4MYTID   = p4_get_my_id();
__P4NUMTIDS = (p4_num_total_slaves()+1);
DBUGMEMORY("About to start slave" );
rc = slave();
/* Delete the procgroup file */
if (wrotepgfile) 
    unlink( pfname );
p4_wait_for_end();
FREE(p4argv);
return rc;
}

/* p4 requires a slave program named slave.  Here it is */
#define CBUFLEN 10
int slave( )
{
int rc;	
char cbuf[CBUFLEN];

DBUGMEMORY("Start of Slave");
LOGPUSHATOMIC;
/* p4_dprintf( "id = %d, nprocs = %d\n", MYPROCID, NUMNODES ); */
/* Distribute the arguments from the main program */
/* printf( "[%d] Starting slave; processings args\n", MYPROCID ); 
   fflush( stdout ); fflush(stderr); */
PISetupCollectiveTree( );
LOGpush(); LOGDISABLE;
DBUGMEMORY("Before Broadcast args");
PIBroadcastArgs( &P4ARGC, &P4ARGV, MYPROCID == 0, (ProcSet *)0 );
LOGpop();
PIGetDebugArgs( &P4ARGC, P4ARGV );
LOGpush(); LOGDISABLE;
/* printf( "[%d] should have disabled logging\n", MYPROCID ); 
   fflush( stdout );fflush(stderr); */

#ifdef DUMP_ARGS
{ int i;
printf( "On node %d\n", MYPROCID );
for (i=0; i<P4ARGC; i++) {
    printf( "[%d] %s\n", i, P4ARGV[i] );
    }
}
#endif

/* Distribute the usage limits */
DBUGMEMORY("Before Broadcastlimits");
PIBroadcastLimits( &cpu, &mem, &pf, &maxtime, &niceval, MYPROCID == 0, 
		   (ProcSet *)0 );
SYSetResourceLimits( mem, cpu, pf, &maxtime );
if (niceval > 0) SYSetNice( niceval );

/* Check for p4-specific options */
while (SYArgGetString( &P4ARGC, P4ARGV, 1, "-p4", cbuf, CBUFLEN ))
    PISetOption( "p4", cbuf, (void *)0 );

LOGpop();

LOGPOPATOMIC;

/* printf( "[%d] About to run initlog and routine\n", MYPROCID ); fflush(stdout);fflush(stderr); */
DBUGMEMORY("Before PIinitlog");
PIinitlog();
rc = (*P4ROUTINE)( P4ARGC, P4ARGV );
PIendlog();
return rc;
}

/*
   Write a procgroup file given a host list.
   utable contains the hosts to use.
 */
void PIWriteP4PG( utable, fout )
FILE      *fout;
HostTable *utable;
{
  int i,j, np, maxarches = MAXARCHES, wrotelocal = 0;
  char *machine,*program;

  /* determine what if any machine in list is host */
  /* if the host will run several of the processes */
  /* we want them to communicate with shared memory */
  /* this means we have to start them with the local n */
  /* command in the p4 procgroup file              */
  for ( i=0; i<maxarches; i++ ) {
    if (utable->archtable[i].np) {
      for ( j=0; j<utable->archtable[i].ne; j++ ) {
        machine = utable->archtable[i].hosts[j]->name;
        if (SYIsMachineHost(machine)) {
          np = utable->archtable[i].hosts[j]->np;
          fprintf( fout, "local %d\n",np );
          wrotelocal = 1;
          utable->archtable[i].hosts[j]->np = 0;
        }
      }  
    }  
  }  
  if (!wrotelocal) fprintf( fout, "local 0\n" );
  for ( i=0; i<maxarches; i++ ) {
    if (utable->archtable[i].np) {
      for ( j=0; j<utable->archtable[i].ne; j++ ) {
        machine = utable->archtable[i].hosts[j]->name;
        np = utable->archtable[i].hosts[j]->np;
        if (np) {
          program = utable->archtable[i].fname;
#if defined(DIFFERENTHOMEDIRECTORYNAMES)
          SYRemoveHomeDir(program);
#endif
          fprintf(fout, "%s %d %s \n",machine, np,program);
        }
      }  
    }  
  }  
}

#if !defined(intelnx) && !defined(cm5)

/*
  Form the p4 procgroup file.  Return the file name
  where it was stashed.  Returns 0 if it failed to write the file.
 */
int PIiFormP4PGFile( argc, argv, pfname, np, mem, cpu, pf )
int  *argc;
char **argv, *pfname;
int  np, mem, cpu, pf;
{
int       dbg, tim;
char      arch[20], pname[1024], pgm[1024], bname[31], *path, *archpath;
char      hostfname[1024], cwd[1024];
FILE      *fout;
int       nl, i, nnp;
HostTable *table,*utable;

/* determine base name of our, to be created, process group */
PIBaseName( argv[0],0,bname, 31 );

/* Set defaults; get special parameters */
SYGetArchType( arch, 20 );
SYArgsToResources( argc, argv, &np, &dbg, arch, pname );

/* We need a version that allows multiple uses of the "local" processor,
   and that allows forming the host table from the command line or a
   generic file */
if (PIiFormHostTable( &utable, &table, np-1, mem, cpu, pf, arch, bname, cwd, 
		      argc, &argv, "TOOLSHOSTS", DEFAULTTOOLSHOSTS ) != 0)
    return 0;

DBUGMEMORY("Formed host table");

/* Find a location for the procgroup file */
fout = SYOpenWritableFile( "./:~/", "/tmp/PIXXXXXX", "PIXXXXXX", pfname, 1 );
if (!fout) {
    fprintf( stderr, "Could not open file for P4 Procgroup\n" );
    return 0;
    }
/* Write out the actual file */
PIWriteP4PG( utable, fout );
fclose( fout );
if (SYArgHasName( argc, argv, 1, "-listnodes" )) {
    PIPrintHostTable( utable, stdout );
    }
/* This is a bug.  The problem is that the utable may be a shallow copy and
   thus the free's in here will free space twice.  This leaks a little space,
   but since this routine should be called at most once, it should not be too
   serious */
/* PIDestroyHostTable(utable); */
PIDestroyHostTable(table);
DBUGMEMORY("Destroyed host tables" );
return 1;
}

#else
/* This routine generates the special procgroup file for a "backend" 
   run in hostless mode */
int PIiFormP4PGFileForBackend( argc, argv, np, pfname )
int  *argc;
char **argv;
int  np;
char *pfname;
{
FILE *fout;
char arch[20], pname[1024], pgm[1024], bname[31];
int  dbg;

PIBaseName( argv[0], 0, bname, 31 );

/* Set defaults; get special parameters */
SYGetArchType( arch, 20 );
dbg  = 0;
if (argv[0][0] != '/') {
    SYGetwd( pname, 1024 );
    strcat( pname, "/" );
    strcat( pname, argv[0] );
    }
else
    strcpy( pname, argv[0] );
SYArgsToResources( argc, argv, &np, &dbg, arch, pname );
PIBuildPgmName( pname, arch, pgm );

fout = SYOpenWritableFile( "./:~/", "/tmp/PIXXXXXX", "PIXXXXXX", pfname, 1 );
if (!fout) {
    fprintf( stderr, "Could not open file for P4 Procgroup\n" );
    return 0;
    }
fprintf( fout, "local %d %s\n", np - 1, pgm );
fclose( fout );
return 1;
}
#endif

/*
   Start p4 daemon

   The p4 daemon needs to know the port #.  For now, this has to be passed
   in (with the -ssport # argument).  In fact, this is how we decide 
   whether a daemon is available.
 */
PIP4StartDaemon( )
{
}

/*
  In the newest versions of p4, it is possible to dispense with the 
  procgroup files entirely.  Do this with
  p4_startup( pg )
  struct p4_procgroup *pg;
  
  This should replace p4_initenv() (?).

  This contains entries of the form
  struct p4_procgroup_entry; 
  see /usr/local/p4t1/include/p4.h for the definitions.

  Note that the structure still has some problems, as the "fullpathname"
  of the slave may exceed 100 characters.  

  We must convice the p4 group to use either MAXPATHLEN or dynamic allocation.

  Also, there is STILL no clean include file that I can use.  Note that
  many of the p4 include files will break if they are included more than
  once.
 */

#define PI_HAS_INIT
#define PI_HAS_EXIT

#define PI_HAS_SET_OPTION
void PISetOption( version, name, val )
char *version, *name;
void *val;
{
if (strcmp( version, "p4" ) != 0) return;

if (strcmp( name, "list" ) == 0) {
    fprintf( (FILE*)val, "list     - generate this list\n" );
    fprintf( (FILE*)val, "busywait - use busy wait on receives\n" );
    /* fprintf( (FILE*)val, "noalloc  - do not preallocate p4 message buffers\n" ); */
    return;
    }

if (strcmp( name, "busywait" ) == 0) {
    __P4SpinWait = 1;
    }
/*
else if (strcmp( name, "noalloc" ) == 0) {
    __P4NoPrealloc = 1;
    }
 */
}

