/*
    These are the definitions particular to the nx implementation.

    Define USE_NATIVE_GLOBAL if you want the IntelNX global routines to
    be used when the procset is NULL.  At least until recently, the Intel
    routines were slower than the general purpose routines.
 */

#ifndef __commnx
#define __commnx

#ifndef __commh
#include "comm/comm.h"
#endif

#define MSG_INT   0
#define MSG_LNG   1
#define MSG_FLT   2
#define MSG_DBL   3
#define MSG_OTHER 4
#define MSG_SHRT  5

extern int __NXLEN, __NXFROM;

typedef int ASYNCRecvId_t;
typedef int ASYNCSendId_t;

#ifdef LOGCOMMEVENTS
/* probing may not be used with asynchronous messages */
#define LOGRECVQ(type) LOGRECVWAIT(type);cprobe(type);LOGRECVREADY(type);
#define LOGGETLENS {__NXLEN=infocount();__NXFROM=infonode();}
#else
#define LOGRECVQ(type)
#define LOGGETLENS
#endif

#define SENDASYNC(type,buffer,length,to,datatype,id) \
        {LOGSENDSTART(length,type,to);\
	     id=isend(type,(char*)(buffer),length,to,0);LOGSENDEND(type);}
#define RECVASYNC(type,buffer,length,datatype,id) \
        {id=irecv(type,(char*)(buffer),length);}
#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	 csend(type,(char*)(buffer),length,to,0);\
         LOGSENDEND(type);}
#define RECVSYNC(type,buffer,length,datatype)  \
        {LOGRECVQ(type);crecv(type,(char*)(buffer),length);\
	 LOGGETLENS;LOGRECVEND(type,__NXLEN,__NXFROM);}
#define SENDWAIT(type,buffer,length,to,datatype,id)  msgwait(id)
#define RECVWAIT(type,buffer,length,datatype,id)     \
        {LOGRECVWAIT(type);msgwait(id);LOGRECVREADY(type);\
	     LOGGETLENS;LOGRECVEND(type,__NXLEN,__NXFROM);}
#define SENDASYNCNOMEM(type,buffer,length,to,datatype,id) \
        SENDASYNC(type,buffer,length,to,datatype,id)
#define RECVASYNCNOMEM(type,buffer,length,datatype,id) \
        RECVASYNC(type,buffer,length,dataype,id)
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        RECVSYNC(type,buffer,length,datatype)
#define SENDWAITNOMEM(type,buffer,length,to,datatype,id)  msgwait(id)
#define RECVWAITNOMEM(type,buffer,length,datatype,id)     \
        RECVWAIT(type,buffer,length,datatype,id)
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
        LOGRECVWAIT(type);cprobe(type);LOGRECVREADY(type);\
	size=infocount();bufp=MALLOC(size);crecv(type,bufp,size);\
        LOGGETLENS;LOGRECVEND(type,size,__NXFROM);}

#define BASE_FORCE 0x40000000
#define SENDASYNCFORCE(type,buffer,length,to,datatype,id) \
        {LOGSENDSTART(length,type,to);\
        id=isend((type)|BASE_FORCE,(char*)(buffer),length,to,0);\
	    LOGSENDEND(type);}
#define RECVASYNCFORCE(type,buffer,length,datatype,id) \
        id=irecv((type)|BASE_FORCE,(char*)(buffer),length)
#define SENDSYNCFORCE(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
        csend((type)|BASE_FORCE,(char*)(buffer),length,to,0);LOGSENDEND(type);}
#define RECVSYNCFORCE(type,buffer,length,datatype)  \
        {LOGRECVQ((type)|BASE_FORCE);\
	     crecv((type)|BASE_FORCE,(char*)(buffer),length);\
	     LOGGETLENS;LOGRECVEND(type,__NXLEN,__NXFROM);}
#define SENDWAITFORCE(type,buffer,length,to,datatype,id)  msgwait(id)
#define RECVWAITFORCE(type,buffer,length,datatype,id)     \
        RECVWAIT((type)|BASE_FORCE,buffer,length,datatype,id)
#define SENDWAITNOMEMFORCE(type,buffer,length,to,datatype,id)  \
        SENDWAITFORCE(type,buffer,length,to,datatype,id)
#define SENDASYNCNOMEMFORCE(type,buffer,length,to,datatype,id) \
        SENDASYNCFORCE(type,buffer,length,to,datatype,id)
#define RECVASYNCNOMEMFORCE(type,buffer,length,datatype,id) \
        RECVASYNCFORCE(type,buffer,length,dataype,id)
#define SENDSYNCNOMEMFORCE(type,buffer,length,to,datatype) \
        SENDSYNCFORCE(type,buffer,length,to,datatype)
#define RECVSYNCNOMEMFORCE(type,buffer,length,datatype)  \
        RECVSYNCFORCE(type,buffer,length,datatype)
#define RECVWAITNOMEMFORCE(type,buffer,length,datatype,id)     \
        RECVWAITFORCE(type,buffer,length,datatype,id)
#define SENDWAITNOMEM(type,buffer,length,to,datatype,id)  msgwait(id)

/* Inorder to make RECVFROM/RECVLEN correct, we need to load up _NXxx
   in the probe cases */
#if defined(LOGCOMMEVENTS)
#define SYNCPROBE(type)  {cprobe(type);__NXLEN=infocount();\
			      __NXFROM=infonode();}
extern int PInxIprobe();
#define ASYNCPROBE(type) PInxIprobe(type)
#else
#define SYNCPROBE(type) cprobe(type)
#define ASYNCPROBE(type) iprobe(type)
#endif

#define RECVPROBED(type,buffer,length,datatype) \
        RECVSYNC(type,buffer,length,datatype)
#define ASYNCDONE(id)    msgdone(id)
#define RECVCANCEL(id)   msgcancel(id)
#define SENDCANCEL(id)   msgcancel(id)

#if defined(LOGCOMMEVENTS)
#define RECVLEN()  __NXLEN
#define RECVFROM() __NXFROM
#define RECVTYPE() infotype()
#else
#define RECVLEN() infocount()
#define RECVFROM() infonode()
#define RECVTYPE() infotype()
#endif

/* Always make the global versions available */
#define GSCATTERGLOB(buf,siz,issrc,datatype) {\
        if(issrc)csend(1000000000,buf,siz,-1,0);else\
                 crecv(1000000000,buf,siz);}
#define GSCATTERSRCGLOB(buf,siz,src,datatype) {\
        if((src)==MYPROCID)csend(1000000000,buf,siz,-1,0);else\
                           crecv(1000000000,buf,siz);}
#define GSYNCGLOB()           gsync()
#define GISUMGLOB(val,n,work) gisum(val,n,work)
#define GDSUMGLOB(val,n,work) gdsum(val,n,work)
#define GFSUMGLOB(val,n,work) gssum(val,n,work)
#define GIMAXGLOB(val,n,work) gihigh(val,n,work)
#define GDMAXGLOB(val,n,work) gdhigh(val,n,work)
#define GIMINGLOB(val,n,work) gilow(val,n,work)
#define GDMINGLOB(val,n,work) gdlow(val,n,work)
/* #define GIORGLOB(val,n,work)  gior( */
#define GCOLGLOB(lbuf,lsize,gbuf,gsiz,glen,datatype) \
      gcol(lbuf,lsize,gbuf,gsiz,glen)
#define GCOLXGLOB(lbuf,gsizes,gbuf,datatype) \
        gcolx(lbuf,gsizes,gbuf)

#ifndef USE_NATIVE_GLOBAL 
#define NO_NATIVE_GLOBAL
#endif

#define MSGALLOCSEND(msg,max,type)  msg = (type *)MALLOC(max)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,max,type)  msg = (type *)MALLOC(max)
#define MSGFREERECV(msg)               FREE(msg)

#define NUMNODES numnodes()
#define MYPROCID mynode()
/* The max value below is approximate */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=1000000000;}
#define MSGSIZES(min,max)      {*min=0;*max=16384;}
/* These are the hypercube versions */
#define MSGDISTANCE(from,to)   gdisthc(from,to)
#if defined(inteldelta)
#define MSGDIAMETER            gdiamdelta()
#elif defined(intelparagon)
#define MSGDIAMETER            gdiamdelta()
#else
#define MSGDIAMETER            nodedim()
#endif
#endif

