#ifndef LINT
static char SCCSid[] = "@(#) ./blog/el.c 07/23/93";
#endif

/* 
   This file contains routines for reading and writing an ALOG file
 */

#define EL_PRIVATE
/* tools.h is used for TRMALLOC and TRFREE.  Define these as malloc and
   free if you don't want the tools versions */
#include "tools.h"
#ifndef TRMALLOC
#define TRMALLOC(a) malloc((unsigned)(a))
extern char *malloc();
#define TRFREE(a)   free((char *)(a))
#endif

#include <stdio.h>
#include <ctype.h>
#include "alog/elog.h"

/* forward references for instances */
int ELreadALOG(), ELwriteALOG();

ELData *ELopen( fname, mode )
char *fname, *mode;
{
ELData *el;
FILE   *fp;

el = (ELData *) TRMALLOC( sizeof(ELData) );
if (!el) return 0;

fp = fopen( fname, mode );
if (!fp) { TRFREE( el ); return 0; }

el->fd   = fp;
el->rnum = 0;
/* We should actually try to read a header to identify the type of the
   logfile (kind of entries) and the type of clock data (cycles,
   microseconds, etc).  This should recognize some default format; if
   the expected header is not found, set the defaults and reposition */
el->t_to_sec = 1.0e-6;

el->read     = ELreadALOG;
el->write    = ELwriteALOG;
el->is_ascii = 1;

return el;
}

ELclose( el )
ELData *el;
{
fclose( el->fd );
TRFREE( el );	
}	

/* This is the alog version */
int ELreadALOG( el, entry )
ELData  *el;
ELEntry *entry;
{
char *cp;
int  i;

if (el->is_ascii) {
    fscanf(el->fd, "%d %d %d %d %d %lu",
            &(entry->type),&(entry->proc_id),&(entry->X.ALOG.task_id),
	    &(entry->X.ALOG.i_data), &(entry->t1), &(entry->t2));

    el->rnum++;
 
    cp = entry->X.ALOG.c_data;
    i = 0;
    /* Skip whitespace */
    do {
        *cp = getc( el->fd );
        } while ( *cp == ' ' || *cp == '\t' );
    i++;
    /* Copy the rest of the data into the buffer */
    while ( *cp != '\n' && i < ALOG_MAX_STRING-1 ) {
        *++cp = getc( el->fd );
        i++;
        }
    *cp = '\0';
    }
else {
    /* Read as binary (fixed integer fields and fixed length character
       string.  Q: should this be a separate routine? */
    }    
return feof( el->fd );
}

/* This is the alog version */
ELwriteALOG( el, entry )
ELData  *el;
ELEntry *entry;	
{
fprintf( el->fd, "%d %d %d %d %d %lu %s\n", entry->type,
         entry->proc_id, entry->X.ALOG.task_id, entry->X.ALOG.i_data,
         entry->t2, entry->t1, entry->X.ALOG.c_data);
}	

#ifdef FOO
/* This is a "precompiled" fscanf for alog/blog records. */
/* ReadRecord - since we read LOTS of records, and we want to do it
   fast, this code reads them KNOWING the format */
int ReadRecord( fp, event, proc_id, task, i_data, cycle, time, c_data )
FILE          *fp;
int           *event, *proc_id, *task, *i_data;
unsigned long *cycle, *time;
char          *c_data; 
{
/* Format is %d %d %d %d %lu %lu %s\n */
int c, k, isign;
int l, v[4];
unsigned long ul, uv[2];

c = getc( fp );
for (k=0; k<4; k++) {
    while (c != EOF && isspace(c)) c = getc(fp);
    if (c == '-') {
	isign = 1;
	l     = 0;
	}
    else {
	isign = 0;
	l = c - '0'; 
	}
    c = getc(fp);
    /* u * 10 == (u * (8+2)) == (u*8 + u*2) == (u << 3) + (u << 1); this
       is faster on SPARC's without integer multiply */
    while (c != EOF && isdigit(c)) { l = l * 10 + (c - '0'); c = getc(fp); }
    v[k] = (isign) ? -l : l;
    }
for (k=0; k<2; k++) {
    while (c != EOF && isspace(c)) c = getc(fp);
    ul = c - '0'; 
    c  = getc(fp);
    while (c != EOF && isdigit(c)) { ul = ul * 10 + (c - '0'); c = getc(fp); }
    uv[k] = ul;
    }
if (c == EOF) return EOF;
*event   = v[0];
*proc_id = v[1];
*task    = v[2];
*i_data  = v[3];
*cycle   = uv[0];
*time    = uv[1];
/* Get the string.  Get only the leading characters */
while (c != EOF && c != '\n' && isspace(c)) c = getc(fp);
c_data[0] = (char) c;
for (k=1; k<12; k++) {
    c = getc(fp);
    if (c == EOF || c == '\n') break;
    c_data[k] = (char)c;
    }
c_data[k] = 0;
while (c != EOF && c != '\n') c = getc(fp);
return 1;
}
#endif
