#ifndef _BLOG
#define _BLOG

#include <stdio.h>
#include "tools.h"
#include "system/time/usec.h"

/* Force the alog routines to be defined even when logging is turned off,
   when building the libraries */
#if !defined(NOTRACE) || defined(BLOG_PRIVATE)

#define BLOG_LOGFILE		"BLOGfile.p"

#define BLOG_TRUNCATE		0
#define BLOG_WRAP		1

#define BLOG_OFF		0
#define BLOG_ON			1

#define BLOG_EVENT_SYNC        -101
#define BLOG_EVENT_PAIR_A1     -102
#define BLOG_EVENT_PAIR_A2     -103
#define BLOG_EVENT_PAIR_B1     -104

#define MAX_DIRNAME_LEN         512

/* Here is the definition of a BLOG record: */


/*
Note that this is variable-sized, and that "size" is in ints.
This really isn't sufficient.  We really need to identify the type of
data.  Thus, I propose:
 */
typedef struct {
    short len;
    short dtype;
    int   other[1];
    } BLOG_VFIELD;

typedef struct {
    short len;
    short event;
    SYusc_time_t time;
    } BLOG_HEADER;
 
/*
   This assumes that sizeof(short) % sizeof(int) == 0.
   The use of shorts keeps the size of the individual records down.
   Using pairs is helpful, since we want ints to be on int boundaries.
	
There are further assumptions for "alog" records:

if (size == 4), record has no "other" part.
if (size > 4)   record is:
    size, event, time, data1, string
*/

/*
  To make these easier to use, the following macros are provided:
*/
#define BLOG_INT 0
#define BLOG_CHAR 1
#define BLOG_DOUBLE 2

/* These give the sizes in ints */
#define BLOGHEADERSIZE    (sizeof(BLOG_HEADER)/sizeof(int))
#define BLOGVFIELDSIZE(n) ((sizeof(BLOG_VFIELD)/sizeof(int))+(n-1))

#define BLOGADDHEADER(b,ev) \
{   b           = (BLOG_HEADER *)(xx_BLOG + xx_BLOG_i);\
    b->len      = (sizeof(BLOG_HEADER)/sizeof(int));;\
    b->event    = ev; \
    SYusc_clock( &b->time ); \
    xx_BLOG_i   += b->len; }
#define BLOGADDINTS(b,v,n,i) \
{    v           = (BLOG_VFIELD *)(xx_BLOG + xx_BLOG_i);\
    v->len      = (sizeof(BLOG_VFIELD) / sizeof(int)) + (n-1);\
    b->len      += v->len;\
    v->dtype    = BLOG_INT;\
    MEMCPY(v->other,i,n*sizeof(int) ); \
    xx_BLOG_i   += v->len;  }
#define BLOGADDSTRING(b,v,str) \
{   int ln, ln4;\
    ln          = strlen(str) + 1;\
    ln4         = (ln + sizeof(int) - 1) / sizeof(int);\
    v           = (BLOG_VFIELD *)(xx_BLOG + xx_BLOG_i);\
    v->len      = (sizeof(BLOG_VFIELD) / sizeof(int)) + ln4 - 1;\
    b->len      += v->len;\
    v->dtype    = BLOG_CHAR;\
    MEMCPY( v->other, str, ln );\
    xx_BLOG_i   += v->len;}
#define BLOGZEROTIME(b) \
{ b->time.s1[0] = 0; b->time.s1[1] = 0; }

extern int  xx_BLOG_status;
extern char xx_BLOG_outdir[];
extern int *xx_BLOG;
extern int xx_BLOG_i;
extern int xx_BLOG_size;

#define BLOG_DEC

#define BLOG_STATUS(status) \
	if ((status) == BLOG_ON) \
		xx_BLOG_status |= 0x1; \
	else \
		xx_BLOG_status &= ~0x1

#define BLOG_ENABLE BLOG_STATUS(BLOG_ON)

#define BLOG_DISABLE BLOG_STATUS(BLOG_OFF)

#define BLOG_SETDIR(dir) {\
	strncpy(xx_BLOG_outdir,(dir),MAX_DIRNAME_LEN); \
	xx_BLOG_outdir[MAX_DIRNAME_LEN] = '\0'; \
	}

#define BLOG_SETUP(flag) xx_BLOG_setup((flag))

#define BLOG_MASTER(flag) {\
	xx_BLOG_setup((flag)); \
	}
#define BLOG_FIX_CLOCKS() xx_BLOG_FixClocks()
#define BLOG_DEFINE(event,edef) xx_BLOG_def((event),(edef))
#define BLOG_DEFINE_STATE(sevent,eevent,color,name) \
    xx_BLOG_def_state(sevent,eevent,color,name)

/* Allow the use of inline logging code */
#ifdef BLOG_INLINE
#define BLOG_LOG(type) \
	{\
	if (xx_BLOG_status & 0x1) {\
	    if (xx_BLOG_i > xx_BLOG_size)\
		xx_BLOG_flush();\
            xx_BLOG[xx_BLOG_i++]  = 4;\
	    xx_BLOG[xx_BLOG_i++]  = type;\
	    SYusc_clock( (SYusc_time_t *)(xx_BLOG+xx_BLOG_i) );\
	    xx_BLOG_i += 2;\
	    }}

#define BLOG_LOGI(type,d1) \
	{\
	if (xx_BLOG_status & 0x1) {\
	    if (xx_BLOG_i > xx_BLOG_size)\
		xx_BLOG_flush();\
            xx_BLOG[xx_BLOG_i++]  = 5;\
	    xx_BLOG[xx_BLOG_i++]  = type;\
	    SYusc_clock( (SYusc_time_t *)&xx_BLOG[xx_BLOG_i] );\
	    xx_BLOG_i += 2;\
            xx_BLOG[xx_BLOG_i++]  = d1;\
	    }}
#else
extern void xx_BLOG_LOG(), xx_BLOG_LOGI();
#ifdef INLINE_BLOG_CHECKS 
#define BLOG_LOG(type) {if (xx_BLOG_status >= 3) {\
 SETERRC(1,"Blog setup not called before logging");}else xx_BLOG_LOG(type); }
#define BLOG_LOGI(type,d1) {if (xx_BLOG_status >= 3){ \
 SETERRC(1,"Blog setup not called before logging");}\
 else xx_BLOG_LOGI(type,d1);}
#define BLOG_LOG4(n1,n2,n3,n4) {if (xx_BLOG_status >= 3){ \
 SETERRC(1,"Blog setup not called before logging");}\
 else xx_BLOG_LOG4(n1,n2,n3,n4);}
#else
#define BLOG_LOG(type)         xx_BLOG_LOG(type)
#define BLOG_LOGI(type,d1)     xx_BLOG_LOGI(type,d1)
#define BLOG_LOG4(n1,n2,n3,n4) xx_BLOG_LOG4(n1,n2,n3,n4)
#endif
#endif

/* This output version includes calls to adjust the clocks */
/* We should look for something like ClocksAreSynchronous */
/* Also, rather than a simple dump, we should do 
   if (parallel & output_single_log_file) merge_log_files
 */
#define BLOG_OUTPUT {xx_BLOG_adjusttimes();xx_BLOG_dump((FILE *)0);}

/* These are used for providing information about synchronizing clocks */
#define BLOG_SYNC_CLOCKS BLOG_LOG(BLOG_EVENT_SYNC)
#define BLOG_SYNC_PAIR1(opid) BLOG_LOGI(BLOG_EVENT_PAIR1,opid)
#define BLOG_SYNC_PAIR2(opid) BLOG_LOGI(BLOG_EVENT_PAIR2,opid)

/* 
 * Function declarations 
 */

void xx_BLOG_dump(), xx_BLOG_setup();
int  xx_BLOG_flush();
#else

#define BLOG_DEC 
#define BLOG_STATUS(a)
#define BLOG_ENABLE
#define BLOG_DISABLE
#define BLOG_SETDIR(a)
#define BLOG_SETUP(a,b)
#define BLOG_MASTER(a,b)
#define BLOG_DEFINE(a,b)
#define BLOG_LOG(a)
#define BLOG_OUTPUT

#define BLOG_SYNC_CLOCKS
#define BLOG_SYNC_PAIR1(b)
#define BLOG_SYNC_PAIR2(b)

#endif  /* ifndef NOTRACE */

extern int BLOGIsPicl();

#endif
